/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.basicdeferred;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.BaseTypeSafeConstraint;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;

public class ExpressionEvaluation
extends BaseTypeSafeConstraint {
    private IExpressionEvaluator evaluator;

    public ExpressionEvaluation(PBody pSystem, IExpressionEvaluator evaluator, PVariable outputVariable) {
        super(pSystem, ExpressionEvaluation.getPVariablesOfExpression(pSystem, evaluator), outputVariable);
        this.evaluator = evaluator;
    }

    public IExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Override
    protected String toStringRest() {
        return String.valueOf(new FlatTuple(new ArrayList(this.inputVariables).toArray()).toString()) + "|=" + this.evaluator.getShortDescription();
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies() {
        if (this.outputVariable == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.inputVariables, Collections.singleton(this.outputVariable));
    }

    private static Set<PVariable> getPVariablesOfExpression(PBody pSystem, IExpressionEvaluator evaluator) {
        HashSet<PVariable> result = new HashSet<PVariable>();
        for (String name : evaluator.getInputParameterNames()) {
            PVariable variable = pSystem.getOrCreateVariableByName(name);
            result.add(variable);
        }
        return result;
    }
}

