/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.base.api.DataTypeListener;
import org.eclipse.incquery.runtime.base.api.FeatureListener;
import org.eclipse.incquery.runtime.base.api.InstanceListener;
import org.eclipse.incquery.runtime.base.api.NavigationHelper;
import org.eclipse.incquery.runtime.rete.boundary.Disconnectable;
import org.eclipse.incquery.runtime.rete.boundary.IManipulationListener;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.eval.PredicateEvaluatorNode;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;

public class BaseIndexListener
implements FeatureListener,
InstanceListener,
DataTypeListener,
IManipulationListener {
    private final ReteBoundary boundary;
    private final NavigationHelper baseIndex;
    private final IncQueryEngine iqEngine;
    private final Set<EClass> classes = new HashSet<EClass>();
    private final Set<EDataType> dataTypes = new HashSet<EDataType>();
    private final Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();

    public BaseIndexListener(IncQueryEngine iqEngine, ReteEngine engine, NavigationHelper baseIndex) {
        this.iqEngine = iqEngine;
        this.boundary = engine.getBoundary();
        this.baseIndex = baseIndex;
        engine.addDisconnectable((Disconnectable)this);
    }

    public void ensure(EClass eClass) {
        if (this.classes.add(eClass)) {
            Set<EClass> newClasses = Collections.singleton(eClass);
            if (!this.baseIndex.isInWildcardMode()) {
                this.baseIndex.registerEClasses(newClasses);
            }
            this.baseIndex.addInstanceListener(newClasses, (InstanceListener)this);
        }
    }

    public void ensure(EDataType eDataType) {
        if (this.dataTypes.add(eDataType)) {
            Set<EDataType> newDataTypes = Collections.singleton(eDataType);
            if (!this.baseIndex.isInWildcardMode()) {
                this.baseIndex.registerEDataTypes(newDataTypes);
            }
            this.baseIndex.addDataTypeListener(newDataTypes, (DataTypeListener)this);
        }
    }

    public void ensure(EStructuralFeature feature) {
        if (this.features.add(feature)) {
            Set<EStructuralFeature> newFeatures = Collections.singleton(feature);
            if (!this.baseIndex.isInWildcardMode()) {
                this.baseIndex.registerEStructuralFeatures(newFeatures);
            }
            this.baseIndex.addFeatureListener(newFeatures, (FeatureListener)this);
        }
    }

    public void instanceInserted(EClass clazz, EObject instance) {
        this.boundary.updateUnary(Direction.INSERT, (Object)instance, (Object)clazz);
        this.boundary.updateInstantiation(Direction.INSERT, (Object)clazz, (Object)instance);
    }

    public void instanceDeleted(EClass clazz, EObject instance) {
        this.boundary.updateUnary(Direction.REVOKE, (Object)instance, (Object)clazz);
        this.boundary.updateInstantiation(Direction.REVOKE, (Object)clazz, (Object)instance);
    }

    public void dataTypeInstanceInserted(EDataType type, Object instance, boolean first) {
        if (first) {
            this.boundary.updateUnary(Direction.INSERT, instance, (Object)type);
            this.boundary.updateInstantiation(Direction.INSERT, (Object)type, instance);
        }
    }

    public void dataTypeInstanceDeleted(EDataType type, Object instance, boolean last) {
        if (last) {
            this.boundary.updateUnary(Direction.REVOKE, instance, (Object)type);
            this.boundary.updateInstantiation(Direction.REVOKE, (Object)type, instance);
        }
    }

    public void featureInserted(EObject host, EStructuralFeature feature, Object value) {
        this.boundary.updateBinaryEdge(Direction.INSERT, (Object)host, value, (Object)feature);
    }

    public void featureDeleted(EObject host, EStructuralFeature feature, Object value) {
        this.boundary.updateBinaryEdge(Direction.REVOKE, (Object)host, value, (Object)feature);
    }

    public void registerSensitiveTerm(Object element, PredicateEvaluatorNode termEvaluatorNode) {
    }

    public void unregisterSensitiveTerm(Object element, PredicateEvaluatorNode termEvaluatorNode) {
    }

    public void disconnect() {
        this.baseIndex.removeFeatureListener(this.features, (FeatureListener)this);
        this.features.clear();
        this.baseIndex.removeInstanceListener(this.classes, (InstanceListener)this);
        this.classes.clear();
        this.baseIndex.removeDataTypeListener(this.dataTypes, (DataTypeListener)this);
        this.dataTypes.clear();
    }
}

