/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ModelConnectorTreeViewerKey;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcherRoot;
import org.eclipse.ui.IEditorPart;

public class MatcherTreeViewerRoot {
    private Map<ModelConnectorTreeViewerKey, ObservablePatternMatcherRoot> roots = new HashMap<ModelConnectorTreeViewerKey, ObservablePatternMatcherRoot>();

    public void addPatternMatcherRoot(IEditorPart editorPart, Notifier notifier) {
        ModelConnectorTreeViewerKey key = new ModelConnectorTreeViewerKey(editorPart, notifier);
        this.addPatternMatcherRoot(key);
    }

    public void addPatternMatcherRoot(ModelConnectorTreeViewerKey key) {
        if (!this.roots.containsKey(key)) {
            ObservablePatternMatcherRoot root = ObservablePatternMatcherRoot.createPatternMatcherRoot(key);
            this.roots.put(key, root);
            if (QueryExplorer.getInstance() != null) {
                QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
            }
        }
    }

    public void removePatternMatcherRoot(IEditorPart editorPart, ResourceSet res) {
        ModelConnectorTreeViewerKey key = new ModelConnectorTreeViewerKey(editorPart, (Notifier)res);
        this.removePatternMatcherRoot(key);
    }

    public void removePatternMatcherRoot(ModelConnectorTreeViewerKey key) {
        if (this.roots.containsKey(key)) {
            ObservablePatternMatcherRoot root = this.roots.get(key);
            root.dispose();
            AdvancedIncQueryEngine engine = root.getKey().getEngine();
            if (engine != null) {
                engine.dispose();
            }
            this.roots.remove(key);
            if (QueryExplorer.getInstance() != null) {
                QueryExplorer.getInstance().getMatcherTreeViewer().refresh((Object)this);
            }
        }
    }

    public Map<ModelConnectorTreeViewerKey, ObservablePatternMatcherRoot> getRootsMap() {
        return this.roots;
    }

    public List<ObservablePatternMatcherRoot> getRoots() {
        return new ArrayList<ObservablePatternMatcherRoot>(this.roots.values());
    }
}

