/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.incquery.databinding.runtime.adapter.DatabindingAdapterUtil;
import org.eclipse.incquery.databinding.runtime.api.IncQueryObservables;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.tooling.ui.queryexplorer.QueryExplorer;
import org.eclipse.incquery.tooling.ui.queryexplorer.content.matcher.ObservablePatternMatcher;
import org.eclipse.incquery.tooling.ui.queryexplorer.util.DisplayUtil;

public class ObservablePatternMatch {
    private String text;
    private IPatternMatch match;
    private ObservablePatternMatcher parent;
    private String message;
    private ParameterValueChangedListener listener;
    private List<IObservableValue> affectedValues;

    public ObservablePatternMatch(ObservablePatternMatcher parent, IPatternMatch match) {
        this.parent = parent;
        this.match = match;
        this.message = DisplayUtil.getMessage(match);
        this.listener = new ParameterValueChangedListener();
        if (this.message != null) {
            this.setText(DatabindingAdapterUtil.getMessage((IPatternMatch)match, (String)this.message));
            this.affectedValues = IncQueryObservables.observeFeatures((IPatternMatch)match, (IValueChangeListener)this.listener, (String)this.message);
        } else {
            this.text = match.toString();
        }
    }

    public void dispose() {
        if (this.affectedValues != null) {
            for (IObservableValue val : this.affectedValues) {
                val.removeValueChangeListener((IValueChangeListener)this.listener);
            }
        }
    }

    public void setText(String text) {
        this.text = text;
        String[] properties = new String[]{"text"};
        if (QueryExplorer.getInstance() != null) {
            QueryExplorer.getInstance().getMatcherTreeViewer().update((Object)this, properties);
        }
    }

    public String getText() {
        return this.text;
    }

    public ObservablePatternMatcher getParent() {
        return this.parent;
    }

    public IPatternMatch getPatternMatch() {
        return this.match;
    }

    public Object[] getLocationObjects() {
        return this.match.toArray();
    }

    private class ParameterValueChangedListener
    implements IValueChangeListener {
        private ParameterValueChangedListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            ObservablePatternMatch.this.setText(DatabindingAdapterUtil.getMessage((IPatternMatch)ObservablePatternMatch.this.match, (String)ObservablePatternMatch.this.message));
        }
    }
}

