/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.ui.IncQueryGUIPlugin;
import org.eclipse.incquery.tooling.ui.wizards.NewEiqFileWizardContainerConfigurationPage;
import org.eclipse.incquery.tooling.ui.wizards.internal.ElementSelectionDialog;
import org.eclipse.incquery.tooling.ui.wizards.internal.ImportListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.ui.PlatformUI;

public class ImportListAdapter
implements IListAdapter<EPackage> {
    private NewEiqFileWizardContainerConfigurationPage firstPage;
    private IEiqGenmodelProvider metamodelProviderService;
    private ILog logger = IncQueryGUIPlugin.getDefault().getLog();

    public ImportListAdapter(NewEiqFileWizardContainerConfigurationPage firstPage, IEiqGenmodelProvider metamodelProviderService) {
        this.firstPage = firstPage;
        this.metamodelProviderService = metamodelProviderService;
    }

    public void customButtonPressed(ListDialogField<EPackage> field, int index) {
        if (index == 0) {
            ElementSelectionDialog listDialog = new ElementSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), new ImportListLabelProvider(), "EPackage");
            listDialog.setTitle("Select packages to import");
            listDialog.setMessage("Select one or more package(s) (* = any string, ? = any char):");
            Object[] input = this.getElements(field);
            listDialog.setElements(input);
            listDialog.open();
            Object[] result = listDialog.getResult();
            if (result != null && result.length > 0) {
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    field.addElement((Object)((EPackage)obj));
                    ++n2;
                }
            }
        }
    }

    private Object[] getElements(ListDialogField<EPackage> field) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        try {
            Collection packages = this.metamodelProviderService.getAllMetamodelObjects(this.firstPage.getProject());
            for (EPackage ePackage : packages) {
                if (this.fieldContains(field, ePackage)) continue;
                result.add(ePackage);
            }
        }
        catch (CoreException e) {
            this.logger.log((IStatus)new Status(4, "org.eclipse.incquery.tooling.ui", "Error during EPackage collecting: " + e.getCause().getMessage(), e.getCause()));
        }
        return result.toArray();
    }

    private boolean fieldContains(ListDialogField<EPackage> field, EPackage _package) {
        for (EPackage _p : field.getElements()) {
            if (!_p.getNsURI().matches(_package.getNsURI())) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(ListDialogField<EPackage> field) {
    }

    public void doubleClicked(ListDialogField<EPackage> field) {
    }
}

