package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.ClassifierParentsMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassifierParentsQuerySpecification;
import org.eclipse.uml2.uml.Classifier;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.classifierParents pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link ClassifierParentsMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (directlyRealizedInterfaces()-{@literal >}union(self.allParents()-{@literal >}collect(directlyRealizedInterfaces()))-{@literal >}asSet())
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: directlyRealizedInterfaces
 * //pattern classifierAllRealizedInterfaces(source: Classifier, target: Interface) {}
 * 
 * 
 * (directlyUsedInterfaces()-{@literal >}union(self.allParents()-{@literal >}collect(directlyUsedInterfaces()))-{@literal >}asSet())
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: directlyUsedInterfaces
 * //pattern classifierAllUsedInterfaces(source: Classifier, target: Interface) {}
 * 
 * 
 * (inhs-{@literal >}reject(inh |
 *   inh.oclIsKindOf(RedefinableElement) and
 *   ownedMember-{@literal >}select(oclIsKindOf(RedefinableElement))-{@literal >}
 *     select(redefinedElement-{@literal >}includes(inh.oclAsType(RedefinableElement)))
 *        -{@literal >}notEmpty()))
 * 
 * // Can't compile OCL to IncQuery because of org.eclipse.ocl.SemanticException: Unrecognized variable: (inhs)
 * //pattern classifierInherit(source: Classifier, target: NamedElement) {}
 * 
 * 
 * (member-{@literal >}select(m | c.hasVisibilityOf(m)))
 * 
 * // Can't compile OCL to IncQuery because of org.eclipse.ocl.SemanticException: Unrecognized variable: (c)
 * //pattern classifierInheritableMembers(source: Classifier, target: NamedElement) {}
 * 
 * 
 * (generalization.general-{@literal >}asSet())
 * 
 * {@literal @}QueryExplorer(checked = false)
 * pattern classifierParents(
 *     self : Classifier,
 *     classifier : Classifier
 * ) {
 *     Classifier.generalization(self, generalization);
 *     temp1 == generalization;
 *     Generalization.general(temp1, classifier);
 * }
 * </pre></code>
 * 
 * @see ClassifierParentsMatch
 * @see ClassifierParentsProcessor
 * @see ClassifierParentsQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class ClassifierParentsMatcher extends BaseMatcher<ClassifierParentsMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ClassifierParentsMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    ClassifierParentsMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new ClassifierParentsMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_CLASSIFIER = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(ClassifierParentsMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public ClassifierParentsMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public ClassifierParentsMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return matches represented as a ClassifierParentsMatch object.
   * 
   */
  public Collection<ClassifierParentsMatch> getAllMatches(final Classifier pSelf, final Classifier pClassifier) {
    return rawGetAllMatches(new Object[]{pSelf, pClassifier});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return a match represented as a ClassifierParentsMatch object, or null if no match is found.
   * 
   */
  public ClassifierParentsMatch getOneArbitraryMatch(final Classifier pSelf, final Classifier pClassifier) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pClassifier});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Classifier pSelf, final Classifier pClassifier) {
    return rawHasMatch(new Object[]{pSelf, pClassifier});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Classifier pSelf, final Classifier pClassifier) {
    return rawCountMatches(new Object[]{pSelf, pClassifier});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Classifier pSelf, final Classifier pClassifier, final IMatchProcessor<? super ClassifierParentsMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pClassifier}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Classifier pSelf, final Classifier pClassifier, final IMatchProcessor<? super ClassifierParentsMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pClassifier}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public ClassifierParentsMatch newMatch(final Classifier pSelf, final Classifier pClassifier) {
    return ClassifierParentsMatch.newMatch(pSelf, pClassifier);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Classifier> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<Classifier> results = new HashSet<Classifier>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Classifier> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Classifier> getAllValuesOfself(final ClassifierParentsMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Classifier> getAllValuesOfself(final Classifier pClassifier) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pClassifier
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for classifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Classifier> rawAccumulateAllValuesOfclassifier(final Object[] parameters) {
    Set<Classifier> results = new HashSet<Classifier>();
    rawAccumulateAllValues(POSITION_CLASSIFIER, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for classifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Classifier> getAllValuesOfclassifier() {
    return rawAccumulateAllValuesOfclassifier(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for classifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Classifier> getAllValuesOfclassifier(final ClassifierParentsMatch partialMatch) {
    return rawAccumulateAllValuesOfclassifier(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for classifier.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Classifier> getAllValuesOfclassifier(final Classifier pSelf) {
    return rawAccumulateAllValuesOfclassifier(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected ClassifierParentsMatch tupleToMatch(final Tuple t) {
    try {
    	return ClassifierParentsMatch.newMatch((org.eclipse.uml2.uml.Classifier) t.get(POSITION_SELF), (org.eclipse.uml2.uml.Classifier) t.get(POSITION_CLASSIFIER));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ClassifierParentsMatch arrayToMatch(final Object[] match) {
    try {
    	return ClassifierParentsMatch.newMatch((org.eclipse.uml2.uml.Classifier) match[POSITION_SELF], (org.eclipse.uml2.uml.Classifier) match[POSITION_CLASSIFIER]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ClassifierParentsMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return ClassifierParentsMatch.newMutableMatch((org.eclipse.uml2.uml.Classifier) match[POSITION_SELF], (org.eclipse.uml2.uml.Classifier) match[POSITION_CLASSIFIER]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<ClassifierParentsMatcher> querySpecification() throws IncQueryException {
    return ClassifierParentsQuerySpecification.instance();
  }
}
