/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.specific.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.Event;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventHandler;
import org.eclipse.incquery.runtime.evm.api.event.EventSource;
import org.eclipse.incquery.runtime.evm.api.event.EventType;
import org.eclipse.incquery.runtime.evm.notification.AttributeMonitor;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventSource;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryEventTypeEnum;
import org.eclipse.incquery.runtime.evm.specific.event.LightweightAttributeMonitor;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public class IncQueryEventHandler<Match extends IPatternMatch>
implements EventHandler<Match> {
    private final IncQueryEventSource<Match> source;
    private final EventFilter<Match> filter;
    private final RuleInstance<Match> instance;
    private AttributeMonitor<Match> attributeMonitor;
    private final Map<IncQueryEventTypeEnum, IMatchProcessor<Match>> processors;

    protected IncQueryEventHandler(IncQueryEventSource<Match> source, EventFilter<Match> filter, RuleInstance<Match> instance) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"Cannot create handler with null source");
        Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"Cannot create handler with null filter");
        this.instance = instance;
        this.source = source;
        this.filter = filter;
        this.processors = Maps.newEnumMap(IncQueryEventTypeEnum.class);
    }

    @Override
    public void handleEvent(Event<Match> event) {
        EventType eventType;
        IPatternMatch eventAtom = (IPatternMatch)event.getEventAtom();
        if (this.filter.isProcessable(eventAtom) && this.processors.containsKey(eventType = event.getEventType())) {
            IMatchProcessor<Match> processor = this.processors.get(eventType);
            processor.process((IPatternMatch)event.getEventAtom());
        }
    }

    @Override
    public EventSource<Match> getSource() {
        return this.source;
    }

    @Override
    public EventFilter<Match> getEventFilter() {
        return this.filter;
    }

    protected AttributeMonitor<Match> prepareAttributeMonitor() {
        LightweightAttributeMonitor monitor = null;
        try {
            monitor = new LightweightAttributeMonitor(this.source.getMatcher().getEngine().getBaseIndex());
        }
        catch (IncQueryException e) {
            IncQueryLoggingUtil.getDefaultLogger().error((Object)"Error happened while accessing base index", (Throwable)e);
        }
        return monitor;
    }

    protected void setInstance(RuleInstance<Match> instance) {
        Preconditions.checkArgument((instance != null ? 1 : 0) != 0, (Object)"Instance cannot be null!");
        this.instance.setHandler(this);
        this.attributeMonitor = (AttributeMonitor)Preconditions.checkNotNull(this.prepareAttributeMonitor(), (Object)"Prepared attribute monitor is null!");
        this.prepareEventProcessors(this.processors);
        this.source.addHandler(this);
        this.attributeMonitor.addAttributeMonitorListener(this.source.getAttributeMonitorListener());
    }

    protected void activationStateTransition(Activation<Match> activation, IncQueryEventTypeEnum eventType) {
        ActivationState nextActivationState = this.instance.activationStateTransition(activation, eventType);
        if (IncQueryActivationStateEnum.INACTIVE.equals(nextActivationState)) {
            this.attributeMonitor.unregisterFor((IPatternMatch)activation.getAtom());
        }
    }

    protected void prepareEventProcessors(Map<IncQueryEventTypeEnum, IMatchProcessor<Match>> processors) {
        processors.put(IncQueryEventTypeEnum.MATCH_APPEARS, new DefaultMatchEventProcessor(){

            @Override
            protected void activationExists(Activation<Match> activation) {
                IncQueryEventHandler.this.activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_APPEARS);
            }

            @Override
            protected void activationMissing(Match atom) {
                Activation activation = IncQueryEventHandler.this.instance.createActivation(atom);
                if (IncQueryEventHandler.this.instance.getLifeCycle().containsTo(IncQueryActivationStateEnum.UPDATED)) {
                    IncQueryEventHandler.this.attributeMonitor.registerFor(atom);
                }
                IncQueryEventHandler.this.activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_APPEARS);
            }
        });
        processors.put(IncQueryEventTypeEnum.MATCH_UPDATES, new DefaultMatchEventProcessor(){

            @Override
            protected void activationExists(Activation<Match> activation) {
                IncQueryEventHandler.this.activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_UPDATES);
            }

            @Override
            protected void activationMissing(Match atom) {
                Preconditions.checkState((boolean)false, (Object)String.format("Atom %s updated without existing activation in rule instance %s!", atom, this));
            }
        });
        processors.put(IncQueryEventTypeEnum.MATCH_DISAPPEARS, new DefaultMatchEventProcessor(){

            @Override
            protected void activationExists(Activation<Match> activation) {
                IncQueryEventHandler.this.activationStateTransition(activation, IncQueryEventTypeEnum.MATCH_DISAPPEARS);
            }

            @Override
            protected void activationMissing(Match atom) {
                Preconditions.checkState((boolean)false, (Object)String.format("Match %s disappeared without existing activation in rule instance %s!", atom, this));
            }
        });
    }

    @Override
    public void dispose() {
        this.source.removeHandler(this);
        this.attributeMonitor.dispose();
    }

    private abstract class DefaultMatchEventProcessor
    implements IMatchProcessor<Match> {
        private DefaultMatchEventProcessor() {
        }

        public void process(Match atom) {
            Preconditions.checkNotNull(atom, (Object)"Cannot process null match!");
            Map column = IncQueryEventHandler.this.instance.getActivations().column(atom);
            if (column.size() > 0) {
                Preconditions.checkArgument((column.size() == 1 ? 1 : 0) != 0, (Object)String.format("%s activations in the same rule for the same match", column.size() == 0 ? "No" : "Multiple"));
                Activation act = (Activation)column.values().iterator().next();
                this.activationExists(act);
            } else {
                this.activationMissing(atom);
            }
        }

        protected abstract void activationExists(Activation<Match> var1);

        protected abstract void activationMissing(Match var1);
    }
}

