/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.evm.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.evm.api.Activation;
import org.eclipse.incquery.runtime.evm.api.RuleBase;
import org.eclipse.incquery.runtime.evm.api.RuleInstance;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.ActivationState;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.api.event.EventRealm;
import org.eclipse.incquery.runtime.evm.api.resolver.ConflictResolver;
import org.eclipse.incquery.runtime.evm.api.resolver.ScopedConflictSet;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;

public class RuleEngine {
    private static final String FILTER_MUST_BE_SPECIFIED = "Filter must be specified";
    private static final String RULE_SPECIFICATION_MUST_BE_SPECIFIED = "Rule specification must be specified!";
    private RuleBase ruleBase;

    protected RuleEngine(RuleBase ruleBase) {
        this.ruleBase = (RuleBase)Preconditions.checkNotNull((Object)ruleBase, (Object)"Cannot create rule engine with null ruleBase!");
    }

    public static RuleEngine create(RuleBase ruleBase) {
        return new RuleEngine(ruleBase);
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        Preconditions.checkNotNull((Object)conflictResolver, (Object)"Conflict resolver cannot be null!");
        this.ruleBase.getAgenda().setConflictResolver(conflictResolver);
    }

    public <EventAtom> ScopedConflictSet createScopedConflictSet(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> eventFilter) {
        return this.createScopedConflictSet(this.ruleBase.getAgenda().getConflictSet().getConflictResolver(), (Multimap<RuleSpecification<?>, EventFilter<?>>)ImmutableMultimap.of(specification, eventFilter));
    }

    public ScopedConflictSet createScopedConflictSet(Multimap<RuleSpecification<?>, EventFilter<?>> specifications) {
        return this.createScopedConflictSet(this.ruleBase.getAgenda().getConflictSet().getConflictResolver(), specifications);
    }

    public ScopedConflictSet createScopedConflictSet(ConflictResolver conflictResolver, Multimap<RuleSpecification<?>, EventFilter<?>> specifications) {
        Preconditions.checkNotNull((Object)conflictResolver, (Object)"Conflict resolver cannot be null!");
        Preconditions.checkNotNull(specifications, (Object)"Specification set cannot be null!");
        ScopedConflictSet scopedConflictSet = this.ruleBase.createScopedConflictSet(conflictResolver, specifications);
        return scopedConflictSet;
    }

    public <EventAtom> boolean addRule(RuleSpecification<EventAtom> specification) {
        return this.addRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean addRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        RuleInstance<? super EventAtom> instance = this.ruleBase.getInstance(specification, filter);
        boolean added = false;
        if (instance == null) {
            this.ruleBase.instantiateRule(specification, filter);
            added = true;
        }
        return added;
    }

    public <EventAtom> boolean containsRule(RuleSpecification<EventAtom> specification) {
        return this.containsRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean containsRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        return this.ruleBase.getRuleSpecificationMultimap().containsEntry(specification, filter);
    }

    public Multimap<ActivationState, Activation<?>> getActivations() {
        return ImmutableMultimap.copyOf(this.ruleBase.getAgenda().getActivations());
    }

    public Activation<?> getNextActivation() {
        return this.ruleBase.getAgenda().getConflictSet().getNextActivation();
    }

    public Set<Activation<?>> getConflictingActivations() {
        return ImmutableSet.copyOf(this.ruleBase.getAgenda().getConflictSet().getConflictingActivations());
    }

    public Set<Activation<?>> getActivations(IncQueryActivationStateEnum state) {
        Preconditions.checkNotNull((Object)state, (Object)"Activation state must be specified!");
        return ImmutableSet.copyOf(this.ruleBase.getAgenda().getActivations(state));
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification) {
        return this.getActivations(specification, specification.createEmptyFilter());
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        return ImmutableSet.copyOf(this.ruleBase.getInstance(specification, filter).getAllActivations());
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, ActivationState state) {
        return this.getActivations(specification, specification.createEmptyFilter(), state);
    }

    public <EventAtom> Set<Activation<EventAtom>> getActivations(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter, ActivationState state) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull((Object)state, (Object)"Activation state must be specified!");
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        return ImmutableSet.copyOf(this.ruleBase.getInstance(specification, filter).getActivations(state));
    }

    public Multimap<RuleSpecification<?>, EventFilter<?>> getRuleSpecificationMultimap() {
        return ImmutableMultimap.copyOf(this.ruleBase.getRuleSpecificationMultimap());
    }

    public <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        return this.ruleBase.removeRule(specification, specification.createEmptyFilter());
    }

    public <EventAtom> boolean removeRule(RuleSpecification<EventAtom> specification, EventFilter<? super EventAtom> filter) {
        Preconditions.checkNotNull(specification, (Object)RULE_SPECIFICATION_MUST_BE_SPECIFIED);
        Preconditions.checkNotNull(filter, (Object)FILTER_MUST_BE_SPECIFIED);
        return this.ruleBase.removeRule(specification, filter);
    }

    protected RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public EventRealm getEventRealm() {
        return this.ruleBase.getEventRealm();
    }

    public Logger getLogger() {
        return this.ruleBase.getLogger();
    }

    public void dispose() {
        this.ruleBase.dispose();
    }
}

