package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.EncapsulatedClassifierOwnedPortMatch;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Port;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.encapsulatedClassifierOwnedPort pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class EncapsulatedClassifierOwnedPortProcessor implements IMatchProcessor<EncapsulatedClassifierOwnedPortMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final EncapsulatedClassifier pSource, final Port pTarget);
  
  @Override
  public void process(final EncapsulatedClassifierOwnedPortMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
