/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.security.AccessControlContext;
import java.time.Duration;
import java.util.Locale;
import java.util.Optional;
import jdk.incubator.http.Http2ClientImpl;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestBuilderImpl;
import jdk.incubator.http.ImmutableHeaders;
import jdk.incubator.http.internal.common.HttpHeadersImpl;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.websocket.WebSocketRequest;

class HttpRequestImpl
extends HttpRequest
implements WebSocketRequest {
    private final HttpHeaders userHeaders;
    private final HttpHeadersImpl systemHeaders;
    private final URI uri;
    private InetSocketAddress authority;
    private final String method;
    final HttpRequest.BodyProcessor requestProcessor;
    final boolean secure;
    final boolean expectContinue;
    private boolean isWebSocket;
    private AccessControlContext acc;
    private final Duration duration;
    private final Optional<HttpClient.Version> version;

    public HttpRequestImpl(HttpRequestBuilderImpl httpRequestBuilderImpl) {
        String string = httpRequestBuilderImpl.method();
        this.method = string == null ? "GET" : string;
        this.userHeaders = ImmutableHeaders.of(httpRequestBuilderImpl.headers().map(), Utils.ALLOWED_HEADERS);
        this.systemHeaders = new HttpHeadersImpl();
        this.uri = httpRequestBuilderImpl.uri();
        this.expectContinue = httpRequestBuilderImpl.expectContinue();
        this.secure = this.uri.getScheme().toLowerCase(Locale.US).equals("https");
        this.requestProcessor = httpRequestBuilderImpl.body() == null ? HttpRequest.noBody() : httpRequestBuilderImpl.body();
        this.duration = httpRequestBuilderImpl.duration();
        this.version = httpRequestBuilderImpl.version();
    }

    public HttpRequestImpl(HttpRequest httpRequest) {
        String string = httpRequest.method();
        this.method = string == null ? "GET" : string;
        this.userHeaders = httpRequest.headers();
        if (httpRequest instanceof HttpRequestImpl) {
            this.systemHeaders = ((HttpRequestImpl)httpRequest).systemHeaders;
            this.isWebSocket = ((HttpRequestImpl)httpRequest).isWebSocket;
        } else {
            this.systemHeaders = new HttpHeadersImpl();
        }
        this.uri = httpRequest.uri();
        this.expectContinue = httpRequest.expectContinue();
        this.secure = this.uri.getScheme().toLowerCase(Locale.US).equals("https");
        this.requestProcessor = !httpRequest.bodyProcessor().isPresent() ? HttpRequest.noBody() : httpRequest.bodyProcessor().get();
        this.duration = httpRequest.duration();
        this.version = httpRequest.version();
    }

    public HttpRequestImpl(URI uRI, String string, HttpRequestImpl httpRequestImpl) {
        this.method = string == null ? "GET" : string;
        this.userHeaders = httpRequestImpl.userHeaders;
        this.isWebSocket = httpRequestImpl.isWebSocket;
        this.systemHeaders = httpRequestImpl.systemHeaders;
        this.uri = uRI;
        this.expectContinue = httpRequestImpl.expectContinue;
        this.secure = uRI.getScheme().toLowerCase(Locale.US).equals("https");
        this.requestProcessor = httpRequestImpl.requestProcessor;
        this.acc = httpRequestImpl.acc;
        this.duration = httpRequestImpl.duration;
        this.version = httpRequestImpl.version();
    }

    HttpRequestImpl(String string, HttpClientImpl httpClientImpl, InetSocketAddress inetSocketAddress) {
        this.method = string;
        this.systemHeaders = new HttpHeadersImpl();
        this.userHeaders = ImmutableHeaders.empty();
        this.uri = URI.create("socket://" + inetSocketAddress.getHostString() + ":" + Integer.toString(inetSocketAddress.getPort()) + "/");
        this.requestProcessor = HttpRequest.noBody();
        this.authority = inetSocketAddress;
        this.secure = false;
        this.expectContinue = false;
        this.duration = null;
        this.version = Optional.of(httpClientImpl.version());
    }

    static HttpRequestImpl createPushRequest(HttpRequestImpl httpRequestImpl, HttpHeadersImpl httpHeadersImpl) throws IOException {
        return new HttpRequestImpl(httpRequestImpl, httpHeadersImpl);
    }

    private HttpRequestImpl(HttpRequestImpl httpRequestImpl, HttpHeadersImpl httpHeadersImpl) throws IOException {
        this.method = httpHeadersImpl.firstValue(":method").orElseThrow(() -> new IOException("No method in Push Promise"));
        String string = httpHeadersImpl.firstValue(":path").orElseThrow(() -> new IOException("No path in Push Promise"));
        String string2 = httpHeadersImpl.firstValue(":scheme").orElseThrow(() -> new IOException("No scheme in Push Promise"));
        String string3 = httpHeadersImpl.firstValue(":authority").orElseThrow(() -> new IOException("No authority in Push Promise"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2).append("://").append(string3).append(string);
        this.uri = URI.create(stringBuilder.toString());
        this.userHeaders = ImmutableHeaders.of(httpHeadersImpl.map(), Utils.ALLOWED_HEADERS);
        this.systemHeaders = httpRequestImpl.systemHeaders;
        this.expectContinue = httpRequestImpl.expectContinue;
        this.secure = httpRequestImpl.secure;
        this.requestProcessor = httpRequestImpl.requestProcessor;
        this.acc = httpRequestImpl.acc;
        this.duration = httpRequestImpl.duration;
        this.version = httpRequestImpl.version;
    }

    public String toString() {
        return (this.uri == null ? "" : this.uri.toString()) + " " + this.method;
    }

    @Override
    public HttpHeaders headers() {
        return this.userHeaders;
    }

    InetSocketAddress authority() {
        return this.authority;
    }

    void setH2Upgrade(Http2ClientImpl http2ClientImpl) {
        this.systemHeaders.setHeader("Connection", "Upgrade, HTTP2-Settings");
        this.systemHeaders.setHeader("Upgrade", "h2c");
        this.systemHeaders.setHeader("HTTP2-Settings", http2ClientImpl.getSettingsString());
    }

    @Override
    public boolean expectContinue() {
        return this.expectContinue;
    }

    InetSocketAddress proxy(HttpClientImpl httpClientImpl) {
        ProxySelector proxySelector = httpClientImpl.proxy().orElse(null);
        if (proxySelector == null) {
            proxySelector = httpClientImpl.proxy().orElse(null);
        }
        if (proxySelector == null || this.method.equalsIgnoreCase("CONNECT")) {
            return null;
        }
        return (InetSocketAddress)proxySelector.select(this.uri).get(0).address();
    }

    boolean secure() {
        return this.secure;
    }

    @Override
    public void isWebSocket(boolean bl) {
        this.isWebSocket = bl;
    }

    boolean isWebSocket() {
        return this.isWebSocket;
    }

    @Override
    public Optional<HttpRequest.BodyProcessor> bodyProcessor() {
        return Optional.of(this.requestProcessor);
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public Duration duration() {
        return this.duration;
    }

    HttpHeaders getUserHeaders() {
        return this.userHeaders;
    }

    HttpHeadersImpl getSystemHeaders() {
        return this.systemHeaders;
    }

    @Override
    public Optional<HttpClient.Version> version() {
        return this.version;
    }

    void addSystemHeader(String string, String string2) {
        this.systemHeaders.addHeader(string, string2);
    }

    @Override
    public void setSystemHeader(String string, String string2) {
        this.systemHeaders.setHeader(string, string2);
    }

    public InetSocketAddress getAddress(HttpClientImpl httpClientImpl) {
        URI uRI = this.uri();
        if (uRI == null) {
            return this.authority();
        }
        int n = uRI.getPort();
        if (n == -1) {
            n = uRI.getScheme().equalsIgnoreCase("https") ? 443 : 80;
        }
        String string = uRI.getHost();
        if (this.proxy(httpClientImpl) == null) {
            return new InetSocketAddress(string, n);
        }
        return InetSocketAddress.createUnresolved(string, n);
    }
}

