/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.callback.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.GenerictListenerImpl;

public abstract class ListenerBase {
    protected ListenerBase() {
    }

    public String getShortName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return name;
    }

    protected void prePersist(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.prePersist in class " + this, b);
        b.setPrePersistCalled(true);
        b.addPrePersistCall(this.getShortName());
        String testName = b.getTestName();
        if ("prePersistRuntimeExceptionTest".equals(testName)) {
            TestUtil.logTrace((String)"Throwing ArithmeticException in ListenerBase");
            throw new ArithmeticException("RuntimeException from PrePersist.");
        }
    }

    protected void postPersist(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In ListenerBase.postPersist." + this, p);
        if (!p.isPrePersistCalled()) {
            TestUtil.logTrace((String)"When calling postPersist, prePersist has not been called.");
            throw new IllegalStateException("When calling postPersist, prePersist has not been called.");
        }
        p.setPostPersistCalled(true);
        p.addPostPersistCall(this.getShortName());
    }

    protected void preRemove(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.preRemove." + this, b);
        b.setPreRemoveCalled(true);
        b.addPreRemoveCall(this.getShortName());
    }

    protected void postRemove(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In ListenerBase.postRemove." + this, p);
        if (!p.isPreRemoveCalled()) {
            TestUtil.logTrace((String)"When calling postRemove, preRemove has not been called.");
            throw new IllegalStateException("When calling postRemove, preRemove has not been called.");
        }
        p.setPostRemoveCalled(true);
        p.addPostRemoveCall(this.getShortName());
    }

    protected void preUpdate(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.preUpdate." + this, b);
        b.setPreUpdateCalled(true);
        b.addPreUpdateCall(this.getShortName());
    }

    protected void postUpdate(Object b) {
        CallbackStatusIF p = (CallbackStatusIF)b;
        GenerictListenerImpl.logTrace("In ListenerBase.postUpdate." + this, p);
        if (!p.isPreUpdateCalled()) {
            TestUtil.logErr((String)"When calling postUpdate, preUpdate has not been called.");
            throw new IllegalStateException("When calling postUpdate, preUpdate has not been called.");
        }
        p.setPostUpdateCalled(true);
        p.addPostUpdateCall(this.getShortName());
    }

    protected void postLoad(CallbackStatusIF b) {
        GenerictListenerImpl.logTrace("In ListenerBase.postLoad." + this, b);
        b.setPostLoadCalled(true);
        b.addPostLoadCall(this.getShortName());
    }
}

