/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.aspects.factory.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.aspects.factory.AspectFactory;
import org.eclipse.jwt.we.conf.model.aspects.factory.RegistryAspectFactory;
import org.eclipse.jwt.we.conf.model.aspects.factory.internal.EclassAspectFactory;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;

public class AspectFactoryRegistryImpl
implements AspectFactory.Registry {
    public static final String ASPECT_FACTORY_EXTENSION_POINT_FACTORY_CLASS = "class";
    protected List<RegistryAspectFactory> registryAspectFactories = new ArrayList<RegistryAspectFactory>();
    protected RegistryAspectFactory defaultEclassAspectFactory = new EclassAspectFactory();

    protected AspectFactoryRegistryImpl() {
    }

    public static AspectFactory.Registry createRegistry() {
        AspectFactoryRegistryImpl aspectFactoryImpl = new AspectFactoryRegistryImpl();
        aspectFactoryImpl.loadDeclaredFactories();
        return aspectFactoryImpl;
    }

    public AspectFactory getFactory(Aspect aspect) {
        for (RegistryAspectFactory registryAspectFactory : this.registryAspectFactories) {
            if (!registryAspectFactory.isFactoryFor(aspect)) continue;
            return registryAspectFactory;
        }
        if (!this.defaultEclassAspectFactory.isFactoryFor(aspect)) {
            ConfPlugin.logger.severe("Creating aspect : no suitable aspect factoryfound in aspect factory registry for aspect " + aspect.getId() + " with eclassifier " + aspect.getAspectInstanceEType());
        }
        return this.defaultEclassAspectFactory;
    }

    protected void loadDeclaredFactories() {
        ConfPlugin.logger.debug("get aspectFactories from extension point org.eclipse.jwt.we.conf.model.registryAspectFactory");
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint aspectFactoryExtensionPoint = registry.getExtensionPoint("org.eclipse.jwt.we.conf.model.registryAspectFactory");
            if (aspectFactoryExtensionPoint == null || aspectFactoryExtensionPoint.getConfigurationElements() == null) {
                ConfPlugin.logger.debug("No declared aspect factory extension found at point org.eclipse.jwt.we.conf.model.registryAspectFactory");
                return;
            }
            IConfigurationElement[] iConfigurationElementArray = aspectFactoryExtensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elt = iConfigurationElementArray[n2];
                Object factory = elt.createExecutableExtension(ASPECT_FACTORY_EXTENSION_POINT_FACTORY_CLASS);
                if (factory instanceof RegistryAspectFactory) {
                    this.registryAspectFactories.add((RegistryAspectFactory)factory);
                    ConfPlugin.logger.info("ConfModel extension - found registered aspect factory at org.eclipse.jwt.we.conf.model.registryAspectFactory: " + factory);
                } else {
                    ConfPlugin.logger.warning("ConfModel Extension - at org.eclipse.jwt.we.conf.model.registryAspectFactory: " + factory + " is not a registered aspect factory");
                }
                ++n2;
            }
        }
        catch (Exception e) {
            ConfPlugin.logger.severe("Error loading registered aspect factories", e);
        }
    }
}

