/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.builder;

import org.eclipse.keyple.calypso.command.PoClass;
import org.eclipse.keyple.calypso.command.po.CalypsoPoCommands;
import org.eclipse.keyple.calypso.command.po.PoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.PoModificationCommand;
import org.eclipse.keyple.calypso.command.po.PoSendableInSession;

public final class DecreaseCmdBuild
extends PoCommandBuilder
implements PoSendableInSession,
PoModificationCommand {
    private static final CalypsoPoCommands command = CalypsoPoCommands.DECREASE;

    public DecreaseCmdBuild(PoClass poClass, byte sfi, byte counterNumber, int decValue, String extraInfo) throws IllegalArgumentException {
        super(command, null);
        if (counterNumber < 1) {
            throw new IllegalArgumentException("Counter number out of range!");
        }
        if (decValue < 0 || decValue > 0xFFFFFF) {
            throw new IllegalArgumentException("Decrement value out of range!");
        }
        byte[] decValueBuffer = new byte[]{(byte)(decValue >> 16 & 0xFF), (byte)(decValue >> 8 & 0xFF), (byte)(decValue & 0xFF)};
        byte cla = poClass.getValue();
        byte p2 = (byte)(sfi * 8);
        this.request = this.setApduRequest(cla, command, counterNumber, p2, decValueBuffer, (byte)0);
        if (extraInfo != null) {
            this.addSubName(extraInfo);
        }
    }
}

