/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.session;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession10RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession24RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession31RespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.OpenSession32RespPars;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.seproxy.message.ApduResponse;

public abstract class AbstractOpenSessionRespPars
extends AbstractApduResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private final PoRevision revision;
    SecureSession secureSession;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    AbstractOpenSessionRespPars(ApduResponse response, PoRevision revision) {
        super(response);
        this.revision = revision;
        this.secureSession = this.toSecureSession(response.getDataOut());
    }

    public static AbstractOpenSessionRespPars create(ApduResponse response, PoRevision revision) {
        switch (revision) {
            case REV1_0: {
                return new OpenSession10RespPars(response);
            }
            case REV2_4: {
                return new OpenSession24RespPars(response);
            }
            case REV3_1: 
            case REV3_1_CLAP: {
                return new OpenSession31RespPars(response);
            }
            case REV3_2: {
                return new OpenSession32RespPars(response);
            }
        }
        throw new IllegalArgumentException("Unknow revision " + (Object)((Object)revision));
    }

    abstract SecureSession toSecureSession(byte[] var1);

    public byte[] getPoChallenge() {
        return this.secureSession.getChallengeRandomNumber();
    }

    public int getTransactionCounterValue() {
        return ByteBuffer.wrap(this.secureSession.getChallengeTransactionCounter()).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public boolean wasRatified() {
        return this.secureSession.isPreviousSessionRatified();
    }

    public boolean isManageSecureSessionAuthorized() {
        return this.secureSession.isManageSecureSessionAuthorized();
    }

    public byte getSelectedKif() {
        return this.secureSession.getKIF();
    }

    public byte getSelectedKvc() {
        return this.secureSession.getKVC();
    }

    public byte[] getRecordDataRead() {
        return this.secureSession.getOriginalData();
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(26368, new AbstractApduResponseParser.StatusProperties(false, "Lc value not supported."));
        m.put(26880, new AbstractApduResponseParser.StatusProperties(false, "Transaction Counter is 0"));
        m.put(27009, new AbstractApduResponseParser.StatusProperties(false, "Command forbidden (read requested and current EF is a Binary file)."));
        m.put(27010, new AbstractApduResponseParser.StatusProperties(false, "Security conditions not fulfilled (PIN code not presented, AES key forbidding the compatibility mode, encryption required)."));
        m.put(27013, new AbstractApduResponseParser.StatusProperties(false, "Access forbidden (Never access mode, Session already opened)."));
        m.put(27014, new AbstractApduResponseParser.StatusProperties(false, "Command not allowed (read requested and no current EF)."));
        m.put(27265, new AbstractApduResponseParser.StatusProperties(false, "Wrong key index."));
        m.put(27266, new AbstractApduResponseParser.StatusProperties(false, "File not found."));
        m.put(27267, new AbstractApduResponseParser.StatusProperties(false, "Record not found (record index is above NumRec)."));
        m.put(27392, new AbstractApduResponseParser.StatusProperties(false, "P1 or P2 value not supported (key index incorrect, wrong P2)."));
        STATUS_TABLE = m;
    }

    public static class SecureSession {
        private final byte[] challengeTransactionCounter;
        private final byte[] challengeRandomNumber;
        private final boolean previousSessionRatified;
        private final boolean manageSecureSessionAuthorized;
        private final byte kif;
        private final Byte kvc;
        private final byte[] originalData;
        private final byte[] secureSessionData;

        public SecureSession(byte[] challengeTransactionCounter, byte[] challengeRandomNumber, boolean previousSessionRatified, boolean manageSecureSessionAuthorized, byte kif, byte kvc, byte[] originalData, byte[] secureSessionData) {
            this.challengeTransactionCounter = challengeTransactionCounter;
            this.challengeRandomNumber = challengeRandomNumber;
            this.previousSessionRatified = previousSessionRatified;
            this.manageSecureSessionAuthorized = manageSecureSessionAuthorized;
            this.kif = kif;
            this.kvc = kvc;
            this.originalData = originalData;
            this.secureSessionData = secureSessionData;
        }

        public SecureSession(byte[] challengeTransactionCounter, byte[] challengeRandomNumber, boolean previousSessionRatified, boolean manageSecureSessionAuthorized, Byte kvc, byte[] originalData, byte[] secureSessionData) {
            this.challengeTransactionCounter = challengeTransactionCounter;
            this.challengeRandomNumber = challengeRandomNumber;
            this.previousSessionRatified = previousSessionRatified;
            this.manageSecureSessionAuthorized = manageSecureSessionAuthorized;
            this.kif = (byte)-1;
            this.kvc = kvc;
            this.originalData = originalData;
            this.secureSessionData = secureSessionData;
        }

        public byte[] getChallengeTransactionCounter() {
            return this.challengeTransactionCounter;
        }

        public byte[] getChallengeRandomNumber() {
            return this.challengeRandomNumber;
        }

        public boolean isPreviousSessionRatified() {
            return this.previousSessionRatified;
        }

        public boolean isManageSecureSessionAuthorized() {
            return this.manageSecureSessionAuthorized;
        }

        public byte getKIF() {
            return this.kif;
        }

        public byte getKVC() {
            return this.kvc;
        }

        public byte[] getOriginalData() {
            return this.originalData;
        }

        public byte[] getSecureSessionData() {
            return this.secureSessionData;
        }
    }
}

