/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.util;

import java.util.Hashtable;
import opencard.opt.util.Tag;
import org.eclipse.keyple.util.ByteArrayUtils;

public class TLV {
    private Tag tag;
    private int length;
    private byte[] value;
    private TLV parent;
    private TLV sibling;
    private TLV child;
    private TLV lastChild;

    public TLV() {
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
    }

    public TLV(byte[] binary) {
        int[] offset = new int[]{0};
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
        TLV.fromBinary(binary, offset, this, null);
    }

    public TLV(byte[] binary, int[] offset) {
        this.tag = new Tag(0, 0, false);
        this.length = 0;
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = null;
        this.lastChild = null;
        TLV.fromBinary(binary, offset, this, null);
    }

    public TLV(Tag tag, byte[] value) {
        int[] offset = new int[]{0};
        TLV newTLV = new TLV();
        this.tag = new Tag(tag);
        if (this.tag.isConstructed()) {
            while (offset[0] < value.length) {
                TLV.fromBinary(value, offset, newTLV, this);
            }
        } else {
            this.length = value != null ? value.length : 0;
            this.value = value;
            this.child = null;
            this.lastChild = null;
        }
        this.parent = null;
        this.sibling = null;
    }

    public TLV(Tag tag, int number) {
        this.tag = new Tag(tag);
        this.value = number < 256 ? new byte[1] : (number < 65536 ? new byte[2] : (number < 0x1000000 ? new byte[3] : new byte[4]));
        for (int i = this.value.length - 1; i >= 0; --i) {
            this.value[i] = (byte)(number % 256);
            number /= 256;
        }
        this.length = this.value.length;
        this.child = null;
        this.lastChild = null;
        this.parent = null;
        this.sibling = null;
    }

    public TLV(Tag tag, TLV tlv) {
        this.tag = new Tag(tag);
        this.tag.setConstructed(true);
        this.value = null;
        this.parent = null;
        this.sibling = null;
        this.child = tlv;
        this.lastChild = tlv;
        this.length = tlv != null ? tlv.tag.size() + tlv.lenBytes() + tlv.length : 0;
    }

    public TLV add(TLV tlv) {
        int deltaReprLength = 0;
        if (this.tag.isConstructed()) {
            tlv.parent = this;
            tlv.sibling = null;
            if (this.lastChild != null) {
                this.lastChild.sibling = tlv;
            }
            this.lastChild = tlv;
            TLV iterTLV = this;
            while (iterTLV != null) {
                int originalReprLength = iterTLV.lenBytes();
                iterTLV.length += tlv.length + tlv.tag.size() + tlv.lenBytes() + deltaReprLength;
                deltaReprLength += iterTLV.lenBytes() - originalReprLength;
                iterTLV = iterTLV.parent;
            }
            return this;
        }
        return null;
    }

    public TLV findTag(Tag tag, TLV cursor) {
        TLV iterTLV = cursor == null ? this.child : cursor.sibling;
        if (tag == null) {
            return iterTLV;
        }
        while (iterTLV != null) {
            if (iterTLV.tag.equals(tag)) {
                return iterTLV;
            }
            iterTLV = iterTLV.sibling;
        }
        return null;
    }

    private static void fromBinary(byte[] binary, int[] offset, TLV tlv, TLV parent) {
        boolean i = false;
        int oldOffset = offset[0];
        tlv.tag.fromBinary(binary, offset);
        tlv.length = 0;
        if ((binary[offset[0]] & 0xFFFFFF80) == 0) {
            tlv.length += binary[offset[0]];
        } else {
            for (int numBytes = binary[offset[0]] & 0x7F; numBytes > 0; --numBytes) {
                offset[0] = offset[0] + 1;
                int j = binary[offset[0]];
                tlv.length = tlv.length + (j < 0 ? (j += 256) : j);
                if (numBytes <= 1) continue;
                tlv.length *= 256;
            }
        }
        offset[0] = offset[0] + 1;
        if (tlv.tag.isConstructed()) {
            tlv.value = null;
            if (tlv.length > 0) {
                tlv.child = new TLV();
                TLV.fromBinary(binary, offset, tlv.child, tlv);
                TLV iterTLV = tlv.child;
                while (offset[0] <= oldOffset + tlv.length) {
                    iterTLV.sibling = new TLV();
                    TLV.fromBinary(binary, offset, iterTLV.sibling, tlv);
                    iterTLV = iterTLV.sibling;
                }
                tlv.lastChild = iterTLV;
            } else {
                tlv.child = null;
            }
        } else {
            tlv.child = null;
            tlv.sibling = null;
            tlv.value = new byte[tlv.length];
            System.arraycopy(binary, offset[0], tlv.value, 0, tlv.length);
            offset[0] = offset[0] + tlv.length;
        }
        tlv.parent = parent;
    }

    private int lenBytes() {
        return TLV.lenBytes(this.length);
    }

    private static int lenBytes(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public int length() {
        return this.length;
    }

    public static byte[] lengthToBinary(int length) {
        byte[] binary = new byte[TLV.lenBytes(length)];
        if (length < 128) {
            binary[0] = (byte)length;
        } else if (length < 256) {
            binary[0] = -127;
            binary[1] = (byte)length;
        } else if (length < 65536) {
            binary[0] = -126;
            binary[1] = (byte)(length / 256);
            binary[2] = (byte)(length % 256);
        } else if (length < 0x1000000) {
            binary[0] = -125;
            binary[1] = (byte)(length / 65536);
            binary[2] = (byte)(length / 256);
            binary[3] = (byte)(length % 256);
        }
        return binary;
    }

    public void setValue(byte[] newValue) {
        int originalReprLength = this.lenBytes();
        int oldLength = this.length;
        this.value = newValue;
        this.length = newValue != null ? this.value.length : 0;
        int deltaReprLength = this.lenBytes() - originalReprLength;
        TLV iterTLV = this.parent;
        while (iterTLV != null) {
            originalReprLength = iterTLV.lenBytes();
            iterTLV.length += this.length - oldLength + deltaReprLength;
            deltaReprLength += iterTLV.lenBytes() - originalReprLength;
            iterTLV = iterTLV.parent;
        }
    }

    public Tag tag() {
        return this.tag;
    }

    public byte[] toBinary() {
        int[] offset = new int[]{0};
        int totalLength = this.tag.size() + this.lenBytes() + this.length;
        byte[] binary = new byte[totalLength];
        this.toBinaryHelper(binary, offset, totalLength);
        return binary;
    }

    public byte[] toBinaryContent() {
        int[] offset = new int[]{0};
        int totalLength = this.length;
        byte[] binary = new byte[totalLength];
        this.toBinaryHelperContent(binary, offset, totalLength);
        return binary;
    }

    private void toBinaryHelper(byte[] binary, int[] offset, int max) {
        boolean i = false;
        this.tag.toBinary(binary, offset);
        this.toBinaryLength(binary, offset);
        if (this.child != null) {
            this.child.toBinaryHelper(binary, offset, max);
        } else if (this.value != null) {
            System.arraycopy(this.value, 0, binary, offset[0], this.value.length);
            offset[0] = offset[0] + this.value.length;
        }
        if (this.sibling != null && offset[0] < max) {
            this.sibling.toBinaryHelper(binary, offset, max);
        }
    }

    private void toBinaryHelperContent(byte[] binary, int[] offset, int max) {
        boolean i = false;
        if (this.child != null) {
            this.child.toBinaryHelper(binary, offset, max);
        } else if (this.value != null) {
            System.arraycopy(this.value, 0, binary, offset[0], this.value.length);
            offset[0] = offset[0] + this.value.length;
        }
    }

    private void toBinaryLength(byte[] binary, int[] offset) {
        if (this.length < 128) {
            binary[offset[0]] = (byte)this.length;
        } else if (this.length < 256) {
            binary[offset[0]] = -127;
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)this.length;
        } else if (this.length < 65536) {
            binary[offset[0]] = -126;
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length / 256);
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length % 256);
        } else if (this.length < 0x1000000) {
            binary[offset[0]] = -125;
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length / 65536);
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length / 256);
            offset[0] = offset[0] + 1;
            binary[offset[0]] = (byte)(this.length % 256);
        }
        offset[0] = offset[0] + 1;
    }

    public String toString() {
        return "Tag: " + this.tag + ", Length: " + this.length + ", Value: " + ByteArrayUtils.toHex(this.value);
    }

    public String toString(Hashtable ht, int level) {
        int i;
        StringBuilder s = new StringBuilder();
        for (i = 0; i < level; ++i) {
            s.append(" ");
        }
        if (ht == null) {
            s.append("[").append(this.tag).append(" ").append(this.length).append("] ");
        } else {
            s.append(ht.get(this.tag)).append(" ");
        }
        if (this.tag.isConstructed()) {
            s.append("\n");
            for (i = 0; i < level; ++i) {
                s.append(" ");
            }
        }
        s.append("( ");
        if (this.tag.isConstructed()) {
            s.append("\n");
            s.append(this.child.toString(ht, level + 2));
            for (i = 0; i < level; ++i) {
                s.append(" ");
            }
            s.append(")\n");
        } else {
            boolean fPrintable = true;
            if (this.value != null) {
                for (i = 0; i < this.value.length; ++i) {
                    if (this.value[i] >= 32) continue;
                    fPrintable = false;
                }
                if (fPrintable) {
                    s.append("\"").append(new String(this.value)).append("\"");
                } else {
                    s.append("'");
                    s.append(ByteArrayUtils.toHex(this.value));
                    s.append("'");
                }
            }
            s.append(" )\n");
        }
        if (this.sibling != null) {
            s.append(this.sibling.toString(ht, level));
        }
        return s.toString();
    }

    public byte[] valueAsByteArray() {
        return this.value;
    }

    public int valueAsNumber() {
        int number = 0;
        for (int i = 0; i < this.value.length; ++i) {
            int j = this.value[i];
            number = number * 256 + (j < 0 ? (j += 256) : j);
        }
        return number;
    }
}

