/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.seproxy.message;

import java.io.Serializable;
import java.util.List;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.seproxy.message.SelectionStatus;
import org.eclipse.keyple.util.ByteArrayUtils;

public final class SeResponse
implements Serializable {
    static final long serialVersionUID = 265369841119873812L;
    private boolean channelPreviouslyOpen;
    private final SelectionStatus selectionStatus;
    private List<ApduResponse> apduResponses;

    public SeResponse(boolean channelPreviouslyOpen, SelectionStatus selectionStatus, List<ApduResponse> apduResponses) {
        this.channelPreviouslyOpen = channelPreviouslyOpen;
        this.selectionStatus = selectionStatus;
        this.apduResponses = apduResponses;
    }

    public boolean wasChannelPreviouslyOpen() {
        return this.channelPreviouslyOpen;
    }

    public SelectionStatus getSelectionStatus() {
        return this.selectionStatus;
    }

    public List<ApduResponse> getApduResponses() {
        return this.apduResponses;
    }

    public String toString() {
        String string = this.selectionStatus != null ? String.format("SeResponse:{RESPONSES = %s, ATR = %s, FCI = %s, HASMATCHED = %b CHANNELWASOPEN = %b}", this.getApduResponses(), this.selectionStatus.getAtr().getBytes() == null ? "null" : ByteArrayUtils.toHex(this.selectionStatus.getAtr().getBytes()), ByteArrayUtils.toHex(this.selectionStatus.getFci().getBytes()), this.selectionStatus.hasMatched(), this.wasChannelPreviouslyOpen()) : String.format("SeResponse:{RESPONSES = %s, ATR = null, FCI = null, HASMATCHED = false CHANNELWASOPEN = %b}", this.getApduResponses(), this.wasChannelPreviouslyOpen());
        return string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeResponse)) {
            return false;
        }
        SeResponse seResponse = (SeResponse)o;
        return seResponse.getSelectionStatus().equals(this.selectionStatus) && (seResponse.getApduResponses() == null ? this.apduResponses == null : seResponse.getApduResponses().equals(this.apduResponses)) && seResponse.wasChannelPreviouslyOpen() == this.channelPreviouslyOpen;
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + (this.selectionStatus.getAtr() == null ? 0 : this.selectionStatus.getAtr().hashCode());
        hash = 7 * hash + (this.apduResponses == null ? 0 : this.apduResponses.hashCode());
        hash = 29 * hash + (this.channelPreviouslyOpen ? 1 : 0);
        return hash;
    }
}

