/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.plugin.pcsc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.eclipse.keyple.seproxy.exception.KeypleBaseException;
import org.eclipse.keyple.seproxy.exception.KeypleChannelStateException;
import org.eclipse.keyple.seproxy.exception.KeypleIOReaderException;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.exception.NoStackTraceThrowable;
import org.eclipse.keyple.seproxy.plugin.AbstractThreadedLocalReader;
import org.eclipse.keyple.seproxy.protocol.Protocol;
import org.eclipse.keyple.seproxy.protocol.SeProtocol;
import org.eclipse.keyple.seproxy.protocol.TransmissionMode;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcscReader
extends AbstractThreadedLocalReader {
    private static final Logger logger = LoggerFactory.getLogger(PcscReader.class);
    public static final String SETTING_KEY_TRANSMISSION_MODE = "transmission_mode";
    public static final String SETTING_TRANSMISSION_MODE_CONTACTS = "contacts";
    public static final String SETTING_TRANSMISSION_MODE_CONTACTLESS = "contactless";
    public static final String SETTING_KEY_PROTOCOL = "protocol";
    public static final String SETTING_PROTOCOL_T0 = "T0";
    public static final String SETTING_PROTOCOL_T1 = "T1";
    public static final String SETTING_PROTOCOL_T_CL = "TCL";
    public static final String SETTING_PROTOCOL_TX = "Tx";
    public static final String SETTING_KEY_MODE = "mode";
    public static final String SETTING_MODE_EXCLUSIVE = "exclusive";
    public static final String SETTING_MODE_SHARED = "shared";
    public static final String SETTING_KEY_DISCONNECT = "disconnect";
    public static final String SETTING_DISCONNECT_RESET = "reset";
    public static final String SETTING_DISCONNECT_UNPOWER = "unpower";
    public static final String SETTING_DISCONNECT_LEAVE = "leave";
    public static final String SETTING_DISCONNECT_EJECT = "eject";
    public static final String SETTING_KEY_THREAD_TIMEOUT = "thread_wait_timeout";
    public static final String SETTING_KEY_LOGGING = "logging";
    private static final String PROTOCOL_T0 = "T=0";
    private static final String PROTOCOL_T1 = "T=1";
    private static final String PROTOCOL_T_CL = "T=CL";
    private static final String PROTOCOL_ANY = "T=0";
    private static final long SETTING_THREAD_TIMEOUT_DEFAULT = 5000L;
    private final CardTerminal terminal;
    private String parameterCardProtocol;
    private boolean cardExclusiveMode;
    private boolean cardReset;
    private TransmissionMode transmissionMode;
    private Card card;
    private CardChannel channel;
    private boolean logging;

    protected PcscReader(String pluginName, CardTerminal terminal) {
        super(pluginName, terminal.getName());
        this.terminal = terminal;
        this.card = null;
        this.channel = null;
        this.protocolsMap = new HashMap();
        try {
            this.setParameter(SETTING_KEY_TRANSMISSION_MODE, null);
            this.setParameter(SETTING_KEY_PROTOCOL, null);
            this.setParameter(SETTING_KEY_MODE, null);
            this.setParameter(SETTING_KEY_DISCONNECT, null);
            this.setParameter(SETTING_KEY_LOGGING, null);
        }
        catch (KeypleBaseException keypleBaseException) {
            // empty catch block
        }
    }

    protected void closePhysicalChannel() throws KeypleChannelStateException {
        try {
            if (this.card != null) {
                if (this.logging) {
                    logger.trace("[{}] closePhysicalChannel => closing the channel.", (Object)this.getName());
                }
                this.channel = null;
                this.card.disconnect(this.cardReset);
                this.card = null;
            } else if (this.logging) {
                logger.trace("[{}] closePhysicalChannel => card object is null.", (Object)this.getName());
            }
        }
        catch (CardException e) {
            throw new KeypleChannelStateException("Error while closing physical channel", (Throwable)e);
        }
    }

    protected boolean checkSePresence() throws NoStackTraceThrowable {
        try {
            return this.terminal.isCardPresent();
        }
        catch (CardException e) {
            logger.trace("[{}] Exception occured in isSePresent. Message: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new NoStackTraceThrowable();
        }
    }

    protected boolean waitForCardPresent(long timeout) throws NoStackTraceThrowable {
        try {
            return this.terminal.waitForCardPresent(timeout);
        }
        catch (CardException e) {
            logger.trace("[{}] Exception occured in waitForCardPresent. Message: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new NoStackTraceThrowable();
        }
    }

    protected boolean waitForCardAbsent(long timeout) throws NoStackTraceThrowable {
        try {
            return this.terminal.waitForCardAbsent(timeout);
        }
        catch (CardException e) {
            logger.trace("[{}] Exception occured in waitForCardAbsent. Message: {}", (Object)this.getName(), (Object)e.getMessage());
            throw new NoStackTraceThrowable();
        }
    }

    protected byte[] transmitApdu(byte[] apduIn) throws KeypleIOReaderException {
        ResponseAPDU apduResponseData;
        try {
            apduResponseData = this.channel.transmit(new CommandAPDU(apduIn));
        }
        catch (CardException e) {
            throw new KeypleIOReaderException(this.getName() + ":" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new KeypleIOReaderException(this.getName() + ":" + e.getMessage());
        }
        return apduResponseData.getBytes();
    }

    protected boolean protocolFlagMatches(SeProtocol protocolFlag) throws KeypleReaderException {
        boolean result;
        if (protocolFlag != Protocol.ANY) {
            String atr;
            String selectionMask;
            if (!this.isPhysicalChannelOpen()) {
                this.openPhysicalChannel();
            }
            if ((selectionMask = (String)this.protocolsMap.get(protocolFlag)) == null) {
                throw new KeypleReaderException("Target selector mask not found!", null);
            }
            Pattern p = Pattern.compile(selectionMask);
            if (!p.matcher(atr = ByteArrayUtils.toHex((byte[])this.card.getATR().getBytes())).matches()) {
                if (this.logging) {
                    logger.trace("[{}] protocolFlagMatches => unmatching SE. PROTOCOLFLAG = {}", (Object)this.getName(), (Object)protocolFlag);
                }
                result = false;
            } else {
                if (this.logging) {
                    logger.trace("[{}] protocolFlagMatches => matching SE. PROTOCOLFLAG = {}", (Object)this.getName(), (Object)protocolFlag);
                }
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setParameter(String name, String value) throws IllegalArgumentException, KeypleBaseException {
        if (this.logging) {
            logger.trace("[{}] setParameter => PCSC: Set a parameter. NAME = {}, VALUE = {}", new Object[]{this.getName(), name, value});
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter shouldn't be null");
        }
        if (name.equals(SETTING_KEY_TRANSMISSION_MODE)) {
            if (value == null) {
                this.transmissionMode = null;
                return;
            }
            if (value.equals(SETTING_TRANSMISSION_MODE_CONTACTS)) {
                this.transmissionMode = TransmissionMode.CONTACTS;
                return;
            }
            if (!value.equals(SETTING_TRANSMISSION_MODE_CONTACTLESS)) throw new IllegalArgumentException("Bad tranmission mode " + name + " : " + value);
            this.transmissionMode = TransmissionMode.CONTACTLESS;
            return;
        }
        if (name.equals(SETTING_KEY_PROTOCOL)) {
            if (value == null || value.equals(SETTING_PROTOCOL_TX)) {
                this.parameterCardProtocol = "*";
                return;
            }
            if (value.equals(SETTING_PROTOCOL_T0)) {
                this.parameterCardProtocol = "T=0";
                return;
            }
            if (value.equals(SETTING_PROTOCOL_T1)) {
                this.parameterCardProtocol = PROTOCOL_T1;
                return;
            }
            if (!value.equals(SETTING_PROTOCOL_T_CL)) throw new IllegalArgumentException("Bad protocol " + name + " : " + value);
            this.parameterCardProtocol = PROTOCOL_T_CL;
            return;
        }
        if (name.equals(SETTING_KEY_MODE)) {
            if (value != null && !value.equals(SETTING_MODE_SHARED)) {
                if (!value.equals(SETTING_MODE_EXCLUSIVE)) throw new IllegalArgumentException("Parameter value not supported " + name + " : " + value);
                this.cardExclusiveMode = true;
                return;
            }
            if (this.cardExclusiveMode && this.card != null) {
                try {
                    this.card.endExclusive();
                }
                catch (CardException e) {
                    throw new KeypleReaderException("Couldn't disable exclusive mode", (Throwable)e);
                }
            }
            this.cardExclusiveMode = false;
            return;
        }
        if (name.equals(SETTING_KEY_THREAD_TIMEOUT)) {
            if (value == null) {
                this.threadWaitTimeout = 5000L;
                return;
            }
            long timeout = Long.parseLong(value);
            if (timeout <= 0L) {
                throw new IllegalArgumentException("Timeout has to be of at least 1ms " + name + value);
            }
            this.threadWaitTimeout = timeout;
            return;
        }
        if (!name.equals(SETTING_KEY_DISCONNECT)) {
            if (!name.equals(SETTING_KEY_LOGGING)) throw new IllegalArgumentException("This parameter is unknown !" + name + " : " + value);
            this.logging = Boolean.parseBoolean(value);
            return;
        }
        if (value == null || value.equals(SETTING_DISCONNECT_RESET)) {
            this.cardReset = true;
            return;
        }
        if (value.equals(SETTING_DISCONNECT_UNPOWER)) {
            this.cardReset = false;
            return;
        }
        if (value.equals(SETTING_DISCONNECT_EJECT)) throw new IllegalArgumentException("This disconnection parameter is not supported by this plugin" + name + " : " + value);
        if (!value.equals(SETTING_DISCONNECT_LEAVE)) throw new IllegalArgumentException("Parameters not supported : " + name + " : " + value);
        throw new IllegalArgumentException("This disconnection parameter is not supported by this plugin" + name + " : " + value);
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String protocol = this.parameterCardProtocol;
        if (protocol.equals("*")) {
            protocol = SETTING_PROTOCOL_TX;
        } else if (protocol.equals("T=0")) {
            protocol = SETTING_PROTOCOL_T0;
        } else if (protocol.equals(PROTOCOL_T1)) {
            protocol = SETTING_PROTOCOL_T1;
        } else {
            throw new IllegalStateException("Illegal protocol: " + protocol);
        }
        parameters.put(SETTING_KEY_PROTOCOL, protocol);
        if (!this.cardExclusiveMode) {
            parameters.put(SETTING_KEY_MODE, SETTING_MODE_SHARED);
        }
        if (this.threadWaitTimeout != 5000L) {
            parameters.put(SETTING_KEY_THREAD_TIMEOUT, Long.toString(this.threadWaitTimeout));
        }
        return parameters;
    }

    protected byte[] getATR() {
        return this.card.getATR().getBytes();
    }

    protected boolean isPhysicalChannelOpen() {
        return this.card != null;
    }

    protected void openPhysicalChannel() throws KeypleChannelStateException {
        try {
            if (this.card == null) {
                this.card = this.terminal.connect(this.parameterCardProtocol);
                if (this.cardExclusiveMode) {
                    this.card.beginExclusive();
                    if (this.logging) {
                        logger.trace("[{}] Opening of a physical SE channel in exclusive mode.", (Object)this.getName());
                    }
                } else if (this.logging) {
                    logger.trace("[{}] Opening of a physical SE channel in shared mode.", (Object)this.getName());
                }
            }
            this.channel = this.card.getBasicChannel();
        }
        catch (CardException e) {
            throw new KeypleChannelStateException("Error while opening Physical Channel", (Throwable)e);
        }
    }

    public TransmissionMode getTransmissionMode() {
        if (this.transmissionMode != null) {
            return this.transmissionMode;
        }
        if (this.parameterCardProtocol.contentEquals(PROTOCOL_T1) || this.parameterCardProtocol.contentEquals(PROTOCOL_T_CL)) {
            return TransmissionMode.CONTACTLESS;
        }
        return TransmissionMode.CONTACTS;
    }
}

