/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.valgrind.launch.Messages;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchConfigurationDelegate;
import org.eclipse.linuxtools.internal.valgrind.launch.ValgrindLaunchPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindUIPlugin;
import org.eclipse.linuxtools.internal.valgrind.ui.ValgrindViewPart;
import org.eclipse.linuxtools.profiling.launch.ConfigUtils;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteConnection;
import org.eclipse.linuxtools.profiling.launch.RemoteConnectionException;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.linuxtools.valgrind.core.IValgrindMessage;
import org.eclipse.linuxtools.valgrind.launch.IValgrindOutputDirectoryProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class ValgrindRemoteProxyLaunchDelegate
extends ValgrindLaunchConfigurationDelegate {
    private static final String VALGRIND_CMD = "valgrind";
    private ConfigUtils configUtils;
    private static final String VERSION_OPT = "--version";
    private static final String VERSION_PREFIX = "valgrind-";
    private static final char VERSION_DELIMITER = '-';
    private static final Version MIN_VER = ValgrindLaunchPlugin.VER_3_3_0;

    private String whichVersion(IProject project) {
        String string;
        String[] cmdArray = new String[]{VALGRIND_CMD, VERSION_OPT};
        Process p = RuntimeProcessFactory.getFactory().exec(cmdArray, project);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            string = stdout.readLine();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stdout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        stdout.close();
        return string;
    }

    private Version getValgrindVersion(IProject project) throws CoreException {
        String verString = this.whichVersion(project);
        if (verString == null || verString.isEmpty()) {
            throw new CoreException(Status.error((String)Messages.getString("ValgrindLaunchPlugin.Couldn't_determine_version")));
        }
        if ((verString = verString.replace(VERSION_PREFIX, "")).indexOf(45) > 0) {
            verString = verString.substring(0, verString.indexOf(45));
        }
        if (verString.isEmpty()) {
            throw new CoreException(Status.error((String)Messages.getString("ValgrindLaunchPlugin.Couldn't_determine_version")));
        }
        Version valgrindVersion = Version.parseVersion((String)verString);
        if (valgrindVersion.compareTo(MIN_VER) < 0) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.getString("ValgrindLaunchPlugin.Error_min_version"), (Object)valgrindVersion.toString(), (Object)MIN_VER.toString())));
        }
        return valgrindVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        this.process = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (String)Messages.getString("ValgrindRemoteLaunchDelegate.task_name"), (int)10);
        if (monitor.isCanceled()) {
            return;
        }
        this.config = config;
        this.launch = launch;
        try {
            IFileStore workingDir;
            ValgrindUIPlugin.getDefault().resetView();
            this.getPlugin().setCurrentLaunchConfiguration(null);
            this.getPlugin().setCurrentLaunch(null);
            this.configUtils = new ConfigUtils(config);
            IProject project = this.configUtils.getProject();
            ValgrindUIPlugin.getDefault().setProfiledProject(project);
            URI exeURI = new URI(this.configUtils.getExecutablePath());
            RemoteConnection exeRC = new RemoteConnection(exeURI);
            monitor.worked(1);
            String valgrindPathString = RuntimeProcessFactory.getFactory().whichCommand(VALGRIND_CMD, project);
            IPath valgrindFullPath = Path.fromOSString((String)valgrindPathString);
            boolean copyExecutable = this.configUtils.getCopyExecutable();
            if (copyExecutable) {
                URI copyExeURI = new URI(this.configUtils.getCopyFromExecutablePath());
                RemoteConnection copyExeRC = new RemoteConnection(copyExeURI);
                IRemoteFileProxy copyExeRFP = copyExeRC.getRmtFileProxy();
                IFileStore copyExeFS = copyExeRFP.getResource(copyExeURI.getPath());
                IRemoteFileProxy exeRFP = exeRC.getRmtFileProxy();
                IFileStore exeFS = exeRFP.getResource(exeURI.getPath());
                IFileInfo exeFI = exeFS.fetchInfo();
                if (exeFI.isDirectory()) {
                    IPath copyExePath = Path.fromOSString((String)copyExeURI.getPath());
                    IPath newExePath = Path.fromOSString((String)exeURI.getPath()).append(copyExePath.lastSegment());
                    exeURI = new URI(exeURI.getScheme(), exeURI.getAuthority(), newExePath.toString(), exeURI.getQuery(), exeURI.getFragment());
                    exeFS = exeRFP.getResource(exeURI.getPath());
                }
                copyExeFS.copy(exeFS, 6, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            }
            this.valgrindVersion = this.getValgrindVersion(project);
            IPath remoteBinFile = Path.fromOSString((String)exeURI.getPath());
            String configWorkingDir = this.configUtils.getWorkingDirectory();
            if (configWorkingDir == null) {
                IPath workingDirPath = remoteBinFile.removeLastSegments(1);
                IRemoteFileProxy workingDirRFP = exeRC.getRmtFileProxy();
                workingDir = workingDirRFP.getResource(workingDirPath.toOSString());
            } else {
                URI workingDirURI = new URI(this.configUtils.getWorkingDirectory());
                RemoteConnection workingDirRC = new RemoteConnection(workingDirURI);
                IRemoteFileProxy workingDirRFP = workingDirRC.getRmtFileProxy();
                workingDir = workingDirRFP.getResource(workingDirURI.getPath());
            }
            IPath remoteLogDir = Path.fromOSString((String)"/tmp/");
            this.outputPath = remoteLogDir.append("eclipse-valgrind-" + System.currentTimeMillis());
            exeRC.createFolder(this.outputPath, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            IValgrindOutputDirectoryProvider provider = this.getPlugin().getOutputDirectoryProvider();
            this.setOutputPath(config, provider.getOutputPath());
            IPath localOutputDir = null;
            try {
                localOutputDir = provider.getOutputPath();
                this.createDirectory(localOutputDir);
            }
            catch (IOException e2) {
                throw new CoreException(Status.error((String)e2.getMessage(), (Throwable)e2));
            }
            this.toolID = this.getTool(config);
            this.dynamicDelegate = this.getDynamicDelegate(this.toolID);
            String[] valgrindArgs = this.getValgrindArgumentsArray(config);
            String[] executableArgs = this.getProgramArgumentsArray(config);
            String[] allArgs = new String[executableArgs.length + valgrindArgs.length + 2];
            int idx = 0;
            allArgs[idx++] = VALGRIND_CMD;
            for (String valgrindArg : valgrindArgs) {
                allArgs[idx++] = valgrindArg;
            }
            allArgs[idx++] = remoteBinFile.toOSString();
            for (String executableArg : executableArgs) {
                allArgs[idx++] = executableArg;
            }
            Process p = RuntimeProcessFactory.getFactory().exec(allArgs, new String[0], workingDir, project);
            int state = p.waitFor();
            if (state != 0) {
                this.abort(Messages.getString("ValgrindLaunchConfigurationDelegate.Launch_exited_status") + " " + state + ". " + NLS.bind((String)Messages.getString("ValgrindRemoteProxyLaunchDelegate.see_reference"), (Object)"IRemoteCommandLauncher") + "\n", null, 150);
            }
            if (p.exitValue() != 0) {
                String line = null;
                StringBuilder valgrindOutSB = new StringBuilder();
                BufferedReader valgrindOut = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = valgrindOut.readLine()) != null) {
                    valgrindOutSB.append(line);
                }
                StringBuilder valgrindErrSB = new StringBuilder();
                BufferedReader valgrindErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = valgrindErr.readLine()) != null) {
                    valgrindErrSB.append(line);
                }
                this.abort(NLS.bind((String)"ValgrindRemoteProxyLaunchDelegate.Stdout", (Object)valgrindOutSB.toString()) + "\n" + NLS.bind((String)"ValgrindRemoteProxyLaunchDelegate.Stderr", (Object)valgrindErrSB.toString()), null, 150);
            }
            exeRC.download(this.outputPath, localOutputDir, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            exeRC.delete(this.outputPath, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)1));
            this.getPlugin().setCurrentLaunchConfiguration(config);
            this.getPlugin().setCurrentLaunch(launch);
            IValgrindMessage[] messages = this.parseLogs(localOutputDir);
            this.launchStr = this.createLaunchStr(valgrindFullPath);
            ValgrindUIPlugin.getDefault().createView(this.launchStr, this.toolID);
            ValgrindViewPart view = ValgrindUIPlugin.getDefault().getView();
            view.setMessages(messages);
            monitor.worked(1);
            this.dynamicDelegate.handleLaunch(config, launch, localOutputDir, (IProgressMonitor)monitor.newChild(2));
            this.dynamicDelegate.initializeView(view.getDynamicView(), this.launchStr, (IProgressMonitor)monitor.newChild(1));
            ValgrindUIPlugin.getDefault().refreshView();
            ValgrindUIPlugin.getDefault().showView();
            monitor.worked(1);
        }
        catch (IOException | InterruptedException | URISyntaxException | RemoteConnectionException e) {
            this.abort(e.getLocalizedMessage(), null, 150);
        }
        finally {
            monitor.done();
            m.done();
        }
    }

    private String createLaunchStr(IPath valgrindPath) throws CoreException {
        IProject project = this.configUtils.getProject();
        URI projectURI = project.getLocationURI();
        String host = projectURI.getHost();
        if (host == null) {
            host = projectURI.getAuthority();
        }
        Object location = host == null ? "remote host" : projectURI.getScheme() + "://" + host;
        return this.config.getName() + " [" + this.getPlugin().getToolName(this.toolID) + "] " + valgrindPath.toString() + " on " + (String)location;
    }

    @Override
    protected String getPluginID() {
        return "org.eclipse.linuxtools.valgrind.launch";
    }
}

