/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IRegistryAccount;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;
import org.eclipse.linuxtools.internal.docker.core.UnixSocketConnectionSettings;
import org.mandas.docker.client.DefaultDockerClient;
import org.mandas.docker.client.DockerCertificates;
import org.mandas.docker.client.DockerCertificatesStore;
import org.mandas.docker.client.DockerClient;
import org.mandas.docker.client.auth.FixedRegistryAuthSupplier;
import org.mandas.docker.client.auth.RegistryAuthSupplier;
import org.mandas.docker.client.builder.jersey.JerseyDockerClientBuilder;
import org.mandas.docker.client.exceptions.DockerCertificateException;
import org.mandas.docker.client.messages.RegistryAuth;
import org.mandas.docker.client.messages.RegistryConfigs;

public class DockerClientFactory {
    public DockerClient getClient(IDockerConnectionSettings connectionSettings) throws DockerCertificateException {
        return this.getClient(connectionSettings, null);
    }

    public DockerClient getClient(IDockerConnectionSettings connectionSettings, IRegistryAccount registryAccount) throws DockerCertificateException {
        JerseyDockerClientBuilder builder = new JerseyDockerClientBuilder();
        if (connectionSettings.getType() == IDockerConnectionSettings.BindingType.UNIX_SOCKET_CONNECTION) {
            UnixSocketConnectionSettings unixSocketConnectionSettings = (UnixSocketConnectionSettings)connectionSettings;
            if (unixSocketConnectionSettings.hasPath()) {
                builder.uri(unixSocketConnectionSettings.getPath());
            }
        } else {
            TCPConnectionSettings tcpConnectionSettings = (TCPConnectionSettings)connectionSettings;
            if (tcpConnectionSettings.hasHost()) {
                builder.uri(URI.create(tcpConnectionSettings.getHost()));
                if (tcpConnectionSettings.getPathToCertificates() != null && !tcpConnectionSettings.getPathToCertificates().isEmpty()) {
                    builder.dockerCertificates((DockerCertificatesStore)new DockerCertificates(new File(tcpConnectionSettings.getPathToCertificates()).toPath()));
                }
            }
        }
        if (builder.uri() == null) {
            return null;
        }
        if (registryAccount != null) {
            RegistryAuth registryAuth = this.buildAuthentication(registryAccount);
            RegistryConfigs configs = RegistryConfigs.create(Collections.singletonMap(Objects.toString(registryAuth.serverAddress(), ""), registryAuth));
            builder.registryAuthSupplier((RegistryAuthSupplier)new FixedRegistryAuthSupplier(registryAuth, configs));
        }
        String clientBuilderProperty = "jakarta.ws.rs.client.ClientBuilder";
        String originalClientBuilder = System.setProperty("jakarta.ws.rs.client.ClientBuilder", "org.glassfish.jersey.client.JerseyClientBuilder");
        String runtimeDelegateProperty = "jakarta.ws.rs.ext.RuntimeDelegate";
        String originalRuntimeDelegate = System.setProperty("jakarta.ws.rs.ext.RuntimeDelegate", "org.glassfish.jersey.internal.RuntimeDelegateImpl");
        DefaultDockerClient dockerClient = builder.build();
        if (originalClientBuilder == null) {
            System.clearProperty("jakarta.ws.rs.client.ClientBuilder");
        } else {
            System.setProperty("jakarta.ws.rs.client.ClientBuilder", originalClientBuilder);
        }
        if (originalRuntimeDelegate == null) {
            System.clearProperty("jakarta.ws.rs.ext.RuntimeDelegate");
        } else {
            System.setProperty("jakarta.ws.rs.ext.RuntimeDelegate", originalRuntimeDelegate);
        }
        return dockerClient;
    }

    private RegistryAuth buildAuthentication(IRegistryAccount info) {
        if (info.getUsername() != null && !info.getUsername().isEmpty()) {
            RegistryAuth authAccount = RegistryAuth.builder().serverAddress(info.getServerAddress()).username(info.getUsername()).email(info.getEmail()).password(info.getPassword() != null ? new String(info.getPassword()) : null).build();
            return authAccount;
        }
        return null;
    }
}

