/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableEndpointConfig;

@JsonDeserialize(builder=ImmutableEndpointConfig.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface EndpointConfig {
    @JsonProperty(value="IPAMConfig")
    @Nullable
    public EndpointIpamConfig ipamConfig();

    @JsonProperty(value="Links")
    @Nullable
    public List<String> links();

    @JsonProperty(value="Aliases")
    @Nullable
    public List<String> aliases();

    @JsonProperty(value="Gateway")
    @Nullable
    public String gateway();

    @JsonProperty(value="IPAddress")
    @Nullable
    public String ipAddress();

    @JsonProperty(value="IPPrefixLen")
    @Nullable
    public Integer ipPrefixLen();

    @JsonProperty(value="IPv6Gateway")
    @Nullable
    public String ipv6Gateway();

    @JsonProperty(value="GlobalIPv6Address")
    @Nullable
    public String globalIPv6Address();

    @JsonProperty(value="GlobalIPv6PrefixLen")
    @Nullable
    public Integer globalIPv6PrefixLen();

    @JsonProperty(value="MacAddress")
    @Nullable
    public String macAddress();

    public static Builder builder() {
        return ImmutableEndpointConfig.builder();
    }

    @JsonDeserialize(builder=ImmutableEndpointConfig.EndpointIpamConfig.Builder.class)
    @Value.Immutable
    public static interface EndpointIpamConfig {
        @JsonProperty(value="IPv4Address")
        @Nullable
        public String ipv4Address();

        @JsonProperty(value="IPv6Address")
        @Nullable
        public String ipv6Address();

        @JsonProperty(value="LinkLocalIPs")
        @Nullable
        public List<String> linkLocalIPs();

        public static Builder builder() {
            return ImmutableEndpointConfig.EndpointIpamConfig.builder();
        }

        public static interface Builder {
            public Builder ipv4Address(String var1);

            public Builder ipv6Address(String var1);

            public Builder linkLocalIPs(Iterable<String> var1);

            public EndpointIpamConfig build();
        }
    }

    public static interface Builder {
        public Builder ipamConfig(EndpointIpamConfig var1);

        public Builder links(Iterable<String> var1);

        public Builder aliases(Iterable<String> var1);

        public Builder gateway(String var1);

        public Builder ipAddress(String var1);

        public Builder ipPrefixLen(Integer var1);

        public Builder ipv6Gateway(String var1);

        public Builder globalIPv6Address(String var1);

        public Builder globalIPv6PrefixLen(Integer var1);

        public Builder macAddress(String var1);

        public EndpointConfig build();
    }
}

