package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link ProgressDetail}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProgressDetail.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableProgressDetail implements ProgressDetail {
  private final @Nullable Long current;
  private final @Nullable Long start;
  private final @Nullable Long total;

  private ImmutableProgressDetail(
      @Nullable Long current,
      @Nullable Long start,
      @Nullable Long total) {
    this.current = current;
    this.start = start;
    this.total = total;
  }

  /**
   * @return The value of the {@code current} attribute
   */
  @JsonProperty("current")
  @Override
  public @Nullable Long current() {
    return current;
  }

  /**
   * @return The value of the {@code start} attribute
   */
  @JsonProperty("start")
  @Override
  public @Nullable Long start() {
    return start;
  }

  /**
   * @return The value of the {@code total} attribute
   */
  @JsonProperty("total")
  @Override
  public @Nullable Long total() {
    return total;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProgressDetail#current() current} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for current (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgressDetail withCurrent(@Nullable Long value) {
    if (Objects.equals(this.current, value)) return this;
    return new ImmutableProgressDetail(value, this.start, this.total);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProgressDetail#start() start} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for start (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgressDetail withStart(@Nullable Long value) {
    if (Objects.equals(this.start, value)) return this;
    return new ImmutableProgressDetail(this.current, value, this.total);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProgressDetail#total() total} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for total (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProgressDetail withTotal(@Nullable Long value) {
    if (Objects.equals(this.total, value)) return this;
    return new ImmutableProgressDetail(this.current, this.start, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProgressDetail} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProgressDetail
        && equalTo(0, (ImmutableProgressDetail) another);
  }

  private boolean equalTo(int synthetic, ImmutableProgressDetail another) {
    return Objects.equals(current, another.current)
        && Objects.equals(start, another.start)
        && Objects.equals(total, another.total);
  }

  /**
   * Computes a hash code from attributes: {@code current}, {@code start}, {@code total}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(current);
    h += (h << 5) + Objects.hashCode(start);
    h += (h << 5) + Objects.hashCode(total);
    return h;
  }

  /**
   * Prints the immutable value {@code ProgressDetail} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProgressDetail{"
        + "current=" + current
        + ", start=" + start
        + ", total=" + total
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProgressDetail} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProgressDetail instance
   */
  public static ImmutableProgressDetail copyOf(ProgressDetail instance) {
    if (instance instanceof ImmutableProgressDetail) {
      return (ImmutableProgressDetail) instance;
    }
    return ImmutableProgressDetail.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProgressDetail ImmutableProgressDetail}.
   * <pre>
   * ImmutableProgressDetail.builder()
   *    .current(Long | null) // nullable {@link ProgressDetail#current() current}
   *    .start(Long | null) // nullable {@link ProgressDetail#start() start}
   *    .total(Long | null) // nullable {@link ProgressDetail#total() total}
   *    .build();
   * </pre>
   * @return A new ImmutableProgressDetail builder
   */
  public static ImmutableProgressDetail.Builder builder() {
    return new ImmutableProgressDetail.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProgressDetail ImmutableProgressDetail}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private Long current;
    private Long start;
    private Long total;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProgressDetail} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProgressDetail instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Long currentValue = instance.current();
      if (currentValue != null) {
        current(currentValue);
      }
      @Nullable Long startValue = instance.start();
      if (startValue != null) {
        start(startValue);
      }
      @Nullable Long totalValue = instance.total();
      if (totalValue != null) {
        total(totalValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProgressDetail#current() current} attribute.
     * @param current The value for current (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("current")
    public final Builder current(@Nullable Long current) {
      this.current = current;
      return this;
    }

    /**
     * Initializes the value for the {@link ProgressDetail#start() start} attribute.
     * @param start The value for start (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("start")
    public final Builder start(@Nullable Long start) {
      this.start = start;
      return this;
    }

    /**
     * Initializes the value for the {@link ProgressDetail#total() total} attribute.
     * @param total The value for total (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total")
    public final Builder total(@Nullable Long total) {
      this.total = total;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProgressDetail ImmutableProgressDetail}.
     * @return An immutable instance of ProgressDetail
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProgressDetail build() {
      return new ImmutableProgressDetail(current, start, total);
    }
  }
}
