
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link DispatcherConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDispatcherConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableDispatcherConfig
    implements DispatcherConfig {
  private final @Nullable Long heartbeatPeriod;

  private ImmutableDispatcherConfig(@Nullable Long heartbeatPeriod) {
    this.heartbeatPeriod = heartbeatPeriod;
  }

  /**
   * @return The value of the {@code heartbeatPeriod} attribute
   */
  @JsonProperty("HeartbeatPeriod")
  @Override
  public @Nullable Long heartbeatPeriod() {
    return heartbeatPeriod;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DispatcherConfig#heartbeatPeriod() heartbeatPeriod} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for heartbeatPeriod (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableDispatcherConfig withHeartbeatPeriod(@Nullable Long value) {
    if (Objects.equals(this.heartbeatPeriod, value)) return this;
    return new ImmutableDispatcherConfig(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDispatcherConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDispatcherConfig
        && equalsByValue((ImmutableDispatcherConfig) another);
  }

  private boolean equalsByValue(ImmutableDispatcherConfig another) {
    return Objects.equals(heartbeatPeriod, another.heartbeatPeriod);
  }

  /**
   * Computes a hash code from attributes: {@code heartbeatPeriod}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(heartbeatPeriod);
    return h;
  }

  /**
   * Prints the immutable value {@code DispatcherConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DispatcherConfig{"
        + "heartbeatPeriod=" + heartbeatPeriod
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DispatcherConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DispatcherConfig instance
   */
  public static ImmutableDispatcherConfig copyOf(DispatcherConfig instance) {
    if (instance instanceof ImmutableDispatcherConfig) {
      return (ImmutableDispatcherConfig) instance;
    }
    return ImmutableDispatcherConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDispatcherConfig ImmutableDispatcherConfig}.
   * <pre>
   * ImmutableDispatcherConfig.builder()
   *    .heartbeatPeriod(Long | null) // nullable {@link DispatcherConfig#heartbeatPeriod() heartbeatPeriod}
   *    .build();
   * </pre>
   * @return A new ImmutableDispatcherConfig builder
   */
  public static ImmutableDispatcherConfig.Builder builder() {
    return new ImmutableDispatcherConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDispatcherConfig ImmutableDispatcherConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements DispatcherConfig.Builder {
    private Long heartbeatPeriod;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DispatcherConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DispatcherConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Long heartbeatPeriodValue = instance.heartbeatPeriod();
      if (heartbeatPeriodValue != null) {
        heartbeatPeriod(heartbeatPeriodValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DispatcherConfig#heartbeatPeriod() heartbeatPeriod} attribute.
     * @param heartbeatPeriod The value for heartbeatPeriod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("HeartbeatPeriod")
    public final Builder heartbeatPeriod(@Nullable Long heartbeatPeriod) {
      this.heartbeatPeriod = heartbeatPeriod;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDispatcherConfig ImmutableDispatcherConfig}.
     * @return An immutable instance of DispatcherConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDispatcherConfig build() {
      return new ImmutableDispatcherConfig(heartbeatPeriod);
    }
  }
}
