/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import org.apache.poi.ss.usermodel.Row;
import org.eclipse.mdht.cda.xml.ui.handlers.GenerateCDADataHandler;

public class SheetHeaderUtil {
    static boolean hideColumns = false;

    static String replaceSpace(String input) {
        String t = input.replaceAll(" ", "_");
        return t;
    }

    static int createAllergyHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(SheetHeaderUtil.replaceSpace("Allergy ID")));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Status"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Onset Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("No Known Flag"));
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Allergy");
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Substance") : SheetHeaderUtil.addCodeHeader(row2, offset, "Substance");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Reaction");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Severity");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Criticality");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createDemographicsHeader(Row row1, Row row2, int offset, int relatedPersonCount) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Name"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Address"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("City"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("State"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Postal"));
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Race");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Ethnicity");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Gender");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Marital Status");
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Langauge");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Telephone"));
        int i = 0;
        while (i < relatedPersonCount) {
            offset = SheetHeaderUtil.addRelatedPersonHeader(row2, offset, "Related_Person_" + (i + 1));
            ++i;
        }
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Name"));
        return offset;
    }

    static int createDocumentMedadataHeadder(Row row2, int offset) {
        return SheetHeaderUtil.createDocumentMedadataHeadder(row2, offset, true);
    }

    static int createDocumentMedadataHeadder(Row row2, int offset, boolean fileName) {
        if (fileName) {
            row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Name"));
            row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Document ID"));
        }
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("CDA Specification"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("CDA Document Type"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Template Id"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("CDA Document Code"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("CDA Document System"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Software"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Document Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("PCP Name"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("PCP Address"));
        return offset;
    }

    static int createEncounterHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Encounter");
        offset = SheetHeaderUtil.createProblemObservationHeader2(row1, row2, offset);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Encounter Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Encounter Author"));
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    private static int createProblemObservationHeader2(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Problem");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Problem Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Problem Author"));
        return offset;
    }

    static int createEncounterIDHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Encounter ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Encounter Match"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        return offset;
    }

    static int createPatientHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Record"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Name"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Document ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Patient ID"));
        if (!GenerateCDADataHandler.omitDOB) {
            row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Complete ID"));
            row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Patient Name"));
            if (!"Documents".equals(row2.getSheet().getSheetName())) {
                row2.getSheet().setColumnHidden(offset - 1, hideColumns);
            }
            row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("DOB"));
        }
        if (!GenerateCDADataHandler.omitDOD) {
            row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("DOD"));
        }
        offset = SheetHeaderUtil.createDocumentMedadataHeadder(row2, offset, false);
        return offset;
    }

    static int createPatientHeader2(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Recipient Name"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Recipient Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Order Id"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Name"));
        return offset;
    }

    static int createProblemHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Status"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Problem");
        offset = SheetHeaderUtil.createProblemObservationHeader(row1, row2, offset);
        return offset;
    }

    static int createProblemObservationHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Problem") : SheetHeaderUtil.addCodeHeader(row2, offset, "Problem");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Problem Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Problem Author"));
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createProcedureHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Effective Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Start Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("End Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Procedure") : SheetHeaderUtil.addCodeHeader(row2, offset, "Procedure");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Performer"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Section Title"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Location"));
        return offset;
    }

    static int createResultsHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Panel ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Panel") : SheetHeaderUtil.addCodeHeader(row2, offset, "Panel");
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Specimen") : SheetHeaderUtil.addCodeHeader(row2, offset, "Specimen");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Status"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Test") : SheetHeaderUtil.addCodeHeader(row2, offset, "Test");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Result"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Range"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createObservationHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Observation") : SheetHeaderUtil.addCodeHeader(row2, offset, "Observation");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Value"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createObservationHeaderWithClinicalNotes(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Observation");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Value"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createObservationHeaderWithAuthor(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Observation") : SheetHeaderUtil.addCodeHeader(row2, offset, "Observation");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Value"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createAdvanceDirectivesHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Advance Directive");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Value"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int createSubstanceAdministrationHeader(Row row1, Row row2, int offset, String type) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, type) : SheetHeaderUtil.addCodeHeader(row2, offset, type);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Status"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Quantity"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Administration Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Administration Start Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Administration End Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Lot Number"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Route Code");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Prescription"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    static int addCodeHeader(Row row1, int offset, String prefix) {
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Text"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Display Name"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Code"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Code System"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Code System Name"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Location"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        return offset;
    }

    static int addRelatedPersonHeader(Row row1, int offset, String prefix) {
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + "_Name"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + "_Address"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + "_City"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + "_State"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + "_Postal"));
        offset = SheetHeaderUtil.addCodeHeader(row1, offset, String.valueOf(prefix) + "_Code");
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + "_Telephone"));
        return offset;
    }

    static int addExtendedCodeHeader(Row row1, int offset, String prefix) {
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Text"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Display Name"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Code"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Code System"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Code System Name"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Location"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 1 Text"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 1 Display Name"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 1 Code"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 1 Code System"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 1 Code System Name"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 1 Location"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 2 Text"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 2 Display Name"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 2 Code"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 2 Code System"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 2 Code System Name"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 2 Location"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 3 Text"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 3 Display Name"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 3 Code"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 3 Code System"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 3 Code System Name"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(String.valueOf(prefix) + " Translation 3 Location"));
        row1.getSheet().setColumnHidden(offset - 1, hideColumns);
        return offset;
    }

    static int addSectionHeader(Row row1, int offset) {
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Section Title"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Location"));
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Narrative"));
        return offset;
    }

    static int addHeader(Row row1, int offset, String header) {
        row1.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace(header));
        return offset;
    }

    public static int createCarePlanHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Panel ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Panel");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Vital Sign ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Vital Sign");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Result"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Range"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    public static int createClinicalStatmentHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Code");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Performer"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Section Title"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Location"));
        return offset;
    }

    public static int createFamilyHistoryHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organizer ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Description");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Observation ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Value");
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    public static int createGoalsSectionHeader(Row row1, Row row2, int offset) {
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Description");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Observation ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Value");
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    public static int createVitalSignsHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Panel ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Panel") : SheetHeaderUtil.addCodeHeader(row2, offset, "Panel");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Vital Sign ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Status"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = GenerateCDADataHandler.exportCDTranslations ? SheetHeaderUtil.addExtendedCodeHeader(row2, offset, "Vital Sign") : SheetHeaderUtil.addCodeHeader(row2, offset, "Vital Sign");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Result"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Range"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Clinical Notes"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    public static int createPlanOfCareActivityObservationHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Observation");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Value"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Range"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }

    public static int createInstructionsHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        row2.getSheet().setColumnHidden(offset - 1, hideColumns);
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Code");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Performer"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Section Title"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Location"));
        return offset;
    }

    public static int createNarrativeHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Narrative"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Section Title"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("File Location"));
        return offset;
    }

    public static int createPayersHeader(Row row1, Row row2, int offset) {
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("ID"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Date"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Location"));
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Policy Activity");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Author"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Payer Name"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Payer Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Guarantor Name"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Guarantor Organization"));
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Coverage Name"));
        offset = SheetHeaderUtil.addCodeHeader(row2, offset, "Coverage Relationship");
        row2.createCell(offset++).setCellValue(SheetHeaderUtil.replaceSpace("Holder Name"));
        offset = SheetHeaderUtil.addSectionHeader(row2, offset);
        return offset;
    }
}

