/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListIndexAffecting;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListTargetAdding;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDOMoveFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDOMoveFeatureDelta,
IListIndexAffecting {
    private int oldPosition;
    private int newPosition;

    public CDOMoveFeatureDeltaImpl(EStructuralFeature feature, int newPosition, int oldPosition) {
        super(feature);
        this.newPosition = newPosition;
        this.oldPosition = oldPosition;
    }

    public CDOMoveFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.newPosition = in.readInt();
        this.oldPosition = in.readInt();
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeInt(this.newPosition);
        out.writeInt(this.oldPosition);
    }

    public int getNewPosition() {
        return this.newPosition;
    }

    public int getOldPosition() {
        return this.oldPosition;
    }

    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.MOVE;
    }

    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).getList(this.getFeature()).move(this.newPosition, this.oldPosition);
    }

    public void affectIndices(IListTargetAdding[] source, int[] indices) {
        block9: {
            block8: {
                if (this.oldPosition >= this.newPosition) break block8;
                int i = 1;
                while (i <= indices[0]) {
                    if (this.oldPosition < indices[i] && indices[i] <= this.newPosition) {
                        int n = i;
                        indices[n] = indices[n] - 1;
                    } else if (indices[i] == this.oldPosition) {
                        indices[i] = this.newPosition;
                    }
                    ++i;
                }
                break block9;
            }
            if (this.newPosition >= this.oldPosition) break block9;
            int i = 1;
            while (i <= indices[0]) {
                if (this.newPosition <= indices[i] && indices[i] < this.oldPosition) {
                    int n = i;
                    indices[n] = indices[n] + 1;
                } else if (indices[i] == this.oldPosition) {
                    indices[i] = this.newPosition;
                }
                ++i;
            }
        }
    }

    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    public void adjustReferences(CDOReferenceAdjuster adjuster) {
    }
}

