/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.server;

import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.server.LongIDStore;
import org.eclipse.emf.cdo.spi.server.Store;
import org.eclipse.emf.cdo.spi.server.StoreAccessor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public abstract class LongIDStoreAccessor
extends StoreAccessor {
    protected LongIDStoreAccessor(Store store, ISession session) {
        super(store, session);
    }

    protected LongIDStoreAccessor(Store store, ITransaction transaction) {
        super(store, transaction);
    }

    protected void addIDMappings(IStoreAccessor.CommitContext context, OMMonitor monitor) {
        try {
            LongIDStore longIDStore = (LongIDStore)this.getStore();
            InternalCDORevision[] newObjects = context.getNewObjects();
            monitor.begin((double)newObjects.length);
            InternalCDORevision[] internalCDORevisionArray = newObjects;
            int n = newObjects.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDORevision revision = internalCDORevisionArray[n2];
                CDOIDTemp oldID = (CDOIDTemp)revision.getID();
                CDOID newID = longIDStore.getNextCDOID();
                if (CDOIDUtil.isNull((CDOID)newID) || newID.isTemporary()) {
                    throw new IllegalStateException("newID=" + newID);
                }
                context.addIDMapping(oldID, newID);
                monitor.worked();
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }
}

