/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo;

import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EStoreEObjectImpl;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.internal.cdo.CDOStateMachine;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.session.CDORevisionManagerImpl;
import org.eclipse.emf.internal.cdo.util.FSMUtil;
import org.eclipse.emf.spi.cdo.CDOElementProxy;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CDOStore
implements InternalEObject.EStore {
    private final ContextTracer TRACER = new ContextTracer(OM.DEBUG_STORE, CDOStore.class);
    private InternalCDOView view;

    public CDOStore(InternalCDOView view) {
        this.view = view;
    }

    public InternalCDOView getView() {
        return this.view;
    }

    public void setContainer(InternalEObject eObject, CDOResource newResource, InternalEObject newEContainer, int newContainerFeatureID) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("setContainer({0}, {1}, {2}, {3})", new Object[]{cdoObject, newResource, newEContainer, newContainerFeatureID});
        }
        CDOID newContainerID = newEContainer == null ? CDOID.NULL : cdoObject.cdoView().convertObjectToID(newEContainer, true);
        CDOID newResourceID = newResource == null ? CDOID.NULL : newResource.cdoID();
        CDOContainerFeatureDeltaImpl delta = new CDOContainerFeatureDeltaImpl(newResourceID, (Object)newContainerID, newContainerFeatureID);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.setResourceID(newResourceID);
        revision.setContainerID((Object)newContainerID);
        revision.setContainingFeatureID(newContainerFeatureID);
    }

    public InternalEObject getContainer(InternalEObject eObject) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("getContainer({0})", new Object[]{cdoObject});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return (InternalEObject)cdoObject.cdoView().convertIDToObject(revision.getContainerID());
    }

    public int getContainingFeatureID(InternalEObject eObject) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("getContainingFeatureID({0})", new Object[]{cdoObject});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.getContainingFeatureID();
    }

    public InternalEObject getResource(InternalEObject eObject) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("getResource({0})", new Object[]{cdoObject});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return (InternalEObject)cdoObject.cdoView().convertIDToObject(revision.getResourceID());
    }

    @Deprecated
    public EStructuralFeature getContainingFeature(InternalEObject eObject) {
        throw new UnsupportedOperationException("Use getContainingFeatureID() instead");
    }

    public Object get(InternalEObject eObject, EStructuralFeature feature, int index) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("get({0}, {1}, {2})", new Object[]{cdoObject, feature, index});
        }
        this.view.getFeatureAnalyzer().preTraverseFeature(cdoObject, feature, index);
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        Object value = revision.basicGet(feature, index);
        value = this.convertToEMF((EObject)eObject, revision, feature, index, value);
        this.view.getFeatureAnalyzer().postTraverseFeature(cdoObject, feature, index, value);
        return value;
    }

    @Deprecated
    public boolean isSet(InternalEObject eObject, EStructuralFeature feature) {
        throw new ImplementationError();
    }

    public int size(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("size({0}, {1})", new Object[]{cdoObject, feature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.size(feature);
    }

    public boolean isEmpty(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("isEmpty({0}, {1})", new Object[]{cdoObject, feature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.isEmpty(feature);
    }

    public boolean contains(InternalEObject eObject, EStructuralFeature feature, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("contains({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
        }
        if (feature instanceof EReference) {
            value = cdoObject.cdoView().convertObjectToID(value, true);
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.contains(feature, value);
    }

    public int indexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("indexOf({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
        }
        if (feature instanceof EReference) {
            value = cdoObject.cdoView().convertObjectToID(value, true);
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.indexOf(feature, value);
    }

    public int lastIndexOf(InternalEObject eObject, EStructuralFeature feature, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("lastIndexOf({0}, {1}, {2})", new Object[]{cdoObject, feature, value});
        }
        if (feature instanceof EReference) {
            value = cdoObject.cdoView().convertObjectToID(value, true);
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.lastIndexOf(feature, value);
    }

    public int hashCode(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("hashCode({0}, {1})", new Object[]{cdoObject, feature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        return revision.hashCode(feature);
    }

    public Object[] toArray(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("toArray({0}, {1})", new Object[]{cdoObject, feature});
        }
        InternalCDORevision revision = CDOStore.getRevisionForReading(cdoObject);
        Object[] result = revision.toArray(feature);
        if (feature instanceof EReference) {
            int i = 0;
            while (i < result.length) {
                result[i] = this.resolveProxy(revision, feature, i, result[i]);
                result[i] = cdoObject.cdoView().convertIDToObject(result[i]);
                ++i;
            }
        }
        return result;
    }

    public <T> T[] toArray(InternalEObject eObject, EStructuralFeature feature, T[] a) {
        Object[] array = this.toArray(eObject, feature);
        int size = array.length;
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        System.arraycopy(array, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public Object set(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
        Object oldValue;
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("set({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, index, value});
        }
        value = this.convertToCDO(feature, value);
        CDOSetFeatureDeltaImpl delta = new CDOSetFeatureDeltaImpl(feature, index, value);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        if (feature instanceof EReference) {
            oldValue = revision.basicGet(feature, index);
            oldValue = this.resolveProxy(revision, feature, index, oldValue);
            value = cdoObject.cdoView().convertObjectToID(value, true);
        }
        oldValue = revision.basicSet(feature, index, value);
        oldValue = this.convertToEMF((EObject)eObject, revision, feature, index, oldValue);
        return oldValue;
    }

    public Object convertToEMF(EObject eObject, InternalCDORevision revision, EStructuralFeature feature, int index, Object value) {
        if (value != null) {
            if (value == InternalCDORevision.NIL) {
                return EStoreEObjectImpl.NIL;
            }
            if (feature.isMany() && index != -1 && (value = this.resolveProxy(revision, feature, index, value)) instanceof CDOID) {
                CDOID id = (CDOID)value;
                CDOList list = revision.getList(feature);
                CDORevisionManagerImpl revisionManager = (CDORevisionManagerImpl)this.view.getSession().getRevisionManager();
                CDORevisionPrefetchingPolicy policy = this.view.options().getRevisionPrefetchingPolicy();
                Collection<CDOID> listOfIDs = policy.loadAhead(revisionManager, eObject, feature, list, index, id);
                if (!listOfIDs.isEmpty()) {
                    revisionManager.getRevisions(listOfIDs, this.view.getSession().options().getCollectionLoadingPolicy().getInitialChunkSize());
                }
            }
            if (feature instanceof EReference) {
                value = this.view.convertIDToObject(value);
            } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature innerFeature = entry.getEStructuralFeature();
                Object innerValue = entry.getValue();
                Object convertedValue = this.view.convertIDToObject(innerValue);
                if (convertedValue != innerValue) {
                    value = FeatureMapUtil.createEntry((EStructuralFeature)innerFeature, (Object)convertedValue);
                }
            } else {
                CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
                if (type != null) {
                    value = type.convertToEMF(feature.getEType(), value);
                }
            }
        }
        return value;
    }

    public Object convertToCDO(EStructuralFeature feature, Object value) {
        if (value != null) {
            if (value == EStoreEObjectImpl.NIL) {
                value = InternalCDORevision.NIL;
            } else if (feature instanceof EReference) {
                value = this.view.convertObjectToID(value, true);
            } else if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                FeatureMap.Entry entry = (FeatureMap.Entry)value;
                EStructuralFeature innerFeature = entry.getEStructuralFeature();
                Object innerValue = entry.getValue();
                Object convertedValue = this.view.convertObjectToID(innerValue);
                if (convertedValue != innerValue) {
                    value = CDORevisionUtil.createFeatureMapEntry((EStructuralFeature)innerFeature, (Object)convertedValue);
                }
            } else {
                CDOType type = CDOModelUtil.getType((EClassifier)feature.getEType());
                if (type != null) {
                    value = type.convertToCDO(feature.getEType(), value);
                }
            }
        }
        return value;
    }

    public void unset(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("unset({0}, {1})", new Object[]{cdoObject, feature});
        }
        CDOUnsetFeatureDeltaImpl delta = new CDOUnsetFeatureDeltaImpl(feature);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.set(feature, 0, null);
    }

    public void add(InternalEObject eObject, EStructuralFeature feature, int index, Object value) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("add({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, index, value});
        }
        value = this.convertToCDO(feature, value);
        CDOAddFeatureDeltaImpl delta = new CDOAddFeatureDeltaImpl(feature, index, value);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.add(feature, index, value);
    }

    public Object remove(InternalEObject eObject, EStructuralFeature feature, int index) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("remove({0}, {1}, {2})", new Object[]{cdoObject, feature, index});
        }
        CDORemoveFeatureDeltaImpl delta = new CDORemoveFeatureDeltaImpl(feature, index);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        Object result = revision.remove(feature, index);
        result = this.convertToEMF((EObject)eObject, revision, feature, index, result);
        return result;
    }

    public void clear(InternalEObject eObject, EStructuralFeature feature) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("clear({0}, {1})", new Object[]{cdoObject, feature});
        }
        CDOClearFeatureDeltaImpl delta = new CDOClearFeatureDeltaImpl(feature);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        revision.clear(feature);
    }

    public Object move(InternalEObject eObject, EStructuralFeature feature, int target, int source) {
        InternalCDOObject cdoObject = this.getCDOObject(eObject);
        if (this.TRACER.isEnabled()) {
            this.TRACER.format("move({0}, {1}, {2}, {3})", new Object[]{cdoObject, feature, target, source});
        }
        CDOMoveFeatureDeltaImpl delta = new CDOMoveFeatureDeltaImpl(feature, target, source);
        InternalCDORevision revision = CDOStore.getRevisionForWriting(cdoObject, (CDOFeatureDelta)delta);
        Object result = revision.move(feature, target, source);
        result = this.convertToEMF((EObject)eObject, revision, feature, -1, result);
        return result;
    }

    public EObject create(EClass eClass) {
        throw new UnsupportedOperationException("Use the generated factory to create objects");
    }

    public String toString() {
        return MessageFormat.format("CDOStore[{0}]", this.view);
    }

    private InternalCDOObject getCDOObject(Object object) {
        return FSMUtil.adapt(object, this.view);
    }

    public Object resolveProxy(InternalCDORevision revision, EStructuralFeature feature, int index, Object value) {
        if (value instanceof CDOElementProxy) {
            value = ((CDOElementProxy)value).resolve(this.getView().getSession().getRevisionManager(), (CDORevision)revision, feature, index);
        }
        return value;
    }

    private static InternalCDORevision getRevisionForReading(InternalCDOObject cdoObject) {
        ReentrantLock viewLock = cdoObject.cdoView().getStateLock();
        viewLock.lock();
        try {
            CDOStateMachine.INSTANCE.read(cdoObject);
            InternalCDORevision internalCDORevision = CDOStore.getRevision(cdoObject);
            return internalCDORevision;
        }
        finally {
            viewLock.unlock();
        }
    }

    private static InternalCDORevision getRevisionForWriting(InternalCDOObject cdoObject, CDOFeatureDelta delta) {
        CDOStateMachine.INSTANCE.write(cdoObject, delta);
        return CDOStore.getRevision(cdoObject);
    }

    private static InternalCDORevision getRevision(InternalCDOObject cdoObject) {
        InternalCDORevision revision = cdoObject.cdoRevision();
        if (revision == null) {
            throw new IllegalStateException("revision == null");
        }
        return revision;
    }
}

