/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.epatch.applier;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.epatch.AssignmentValue;
import org.eclipse.emf.compare.epatch.CreatedObject;
import org.eclipse.emf.compare.epatch.ListAssignment;
import org.eclipse.emf.compare.epatch.NamedObject;
import org.eclipse.emf.compare.epatch.NamedResource;
import org.eclipse.emf.compare.epatch.ObjectRef;
import org.eclipse.emf.compare.epatch.SingleAssignment;
import org.eclipse.emf.compare.epatch.applier.ApplyStrategy;
import org.eclipse.emf.compare.epatch.util.EpatchUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface EpatchApplyStrategy {
    public List<CreatedObject> getAllAddedObjects(NamedObject var1);

    public List<CreatedObject> getAllRemovedObjects(NamedObject var1);

    public String getInputFragment(ObjectRef var1);

    public NamedResource getInputResource(ObjectRef var1);

    public CreatedObject getInputRoot(NamedResource var1);

    public String getInputURI(NamedResource var1);

    public EList<AssignmentValue> getInputValues(ListAssignment var1);

    public CreatedObject getOutputRoot(NamedResource var1);

    public String getOutputURI(NamedResource var1);

    public AssignmentValue getOutputValue(SingleAssignment var1);

    public EList<AssignmentValue> getOutputValues(ListAssignment var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EpatchLeftToRightStrategy
    implements EpatchApplyStrategy {
        protected EpatchLeftToRightStrategy() {
        }

        @Override
        public List<CreatedObject> getAllAddedObjects(NamedObject obj) {
            return EpatchUtil.getAllRightValues(obj);
        }

        @Override
        public List<CreatedObject> getAllRemovedObjects(NamedObject obj) {
            return EpatchUtil.getAllLeftValues(obj);
        }

        @Override
        public String getInputFragment(ObjectRef obj) {
            return obj.getLeftFrag();
        }

        @Override
        public NamedResource getInputResource(ObjectRef obj) {
            return obj.getLeftRes();
        }

        @Override
        public CreatedObject getInputRoot(NamedResource res) {
            return res.getLeftRoot();
        }

        @Override
        public String getInputURI(NamedResource res) {
            return res.getLeftUri();
        }

        @Override
        public EList<AssignmentValue> getInputValues(ListAssignment si) {
            return si.getLeftValues();
        }

        @Override
        public CreatedObject getOutputRoot(NamedResource res) {
            return res.getRightRoot();
        }

        @Override
        public String getOutputURI(NamedResource res) {
            return res.getRightUri();
        }

        @Override
        public AssignmentValue getOutputValue(SingleAssignment si) {
            return si.getRightValue();
        }

        @Override
        public EList<AssignmentValue> getOutputValues(ListAssignment si) {
            return si.getRightValues();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EpatchRightToLeftStrategy
    implements EpatchApplyStrategy {
        protected EpatchRightToLeftStrategy() {
        }

        @Override
        public List<CreatedObject> getAllAddedObjects(NamedObject obj) {
            return EpatchUtil.getAllLeftValues(obj);
        }

        @Override
        public List<CreatedObject> getAllRemovedObjects(NamedObject obj) {
            return EpatchUtil.getAllRightValues(obj);
        }

        @Override
        public String getInputFragment(ObjectRef obj) {
            return obj.getRightFrag() != null && obj.getRightRes() != null ? obj.getRightFrag() : obj.getLeftFrag();
        }

        @Override
        public NamedResource getInputResource(ObjectRef obj) {
            return obj.getRightFrag() != null && obj.getRightRes() != null ? obj.getRightRes() : obj.getLeftRes();
        }

        @Override
        public CreatedObject getInputRoot(NamedResource res) {
            return res.getRightRoot();
        }

        @Override
        public String getInputURI(NamedResource res) {
            return res.getRightUri();
        }

        @Override
        public EList<AssignmentValue> getInputValues(ListAssignment si) {
            return si.getRightValues();
        }

        @Override
        public CreatedObject getOutputRoot(NamedResource res) {
            return res.getLeftRoot();
        }

        @Override
        public String getOutputURI(NamedResource res) {
            return res.getLeftUri();
        }

        @Override
        public AssignmentValue getOutputValue(SingleAssignment si) {
            return si.getLeftValue();
        }

        @Override
        public EList<AssignmentValue> getOutputValues(ListAssignment si) {
            return si.getLeftValues();
        }
    }

    public static class Util {
        private static final EpatchApplyStrategy LEFT_TO_RIGHT = new EpatchLeftToRightStrategy();
        private static final EpatchApplyStrategy RIGHT_TO_LEFT = new EpatchRightToLeftStrategy();

        public static final EpatchApplyStrategy get(ApplyStrategy strategy) {
            switch (strategy) {
                case LEFT_TO_RIGHT: {
                    return LEFT_TO_RIGHT;
                }
                case RIGHT_TO_LEFT: {
                    return RIGHT_TO_LEFT;
                }
            }
            throw new RuntimeException();
        }
    }
}

