/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.client.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.protocol.CDOResListener;
import org.eclipse.emf.cdo.client.protocol.DeleteResourcesRequest;
import org.eclipse.emf.cdo.client.protocol.QueryAllResourcesRequest;
import org.eclipse.emf.cdo.client.protocol.ResourcesChangedIndication;
import org.eclipse.emf.cdo.core.protocol.AbstractCDOResProtocol;
import org.eclipse.emf.cdo.core.protocol.ResourceChangeInfo;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Indication;
import org.eclipse.net4j.core.Request;
import org.eclipse.net4j.util.ImplementationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientCDOResProtocolImpl
extends AbstractCDOResProtocol {
    private List<CDOResListener> listeners = new ArrayList<CDOResListener>();

    public int getType() {
        return 2;
    }

    public Indication createIndication(short signalId) {
        switch (signalId) {
            case 6: {
                return new ResourcesChangedIndication();
            }
        }
        throw new ImplementationError("Invalid cdores signalId: " + signalId);
    }

    public void addListener(CDOResListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CDOResListener listener) {
        this.listeners.remove(listener);
    }

    public void resourcesChanged(Channel channel, List<ResourceChangeInfo> infos) {
        for (CDOResListener listener : this.listeners) {
            listener.notifyResourcesChanged(channel, infos);
        }
    }

    public static List<ResourceInfo> queryAllResources(Channel channel) {
        ClientCDOResProtocolImpl.assertValidChannel((Channel)channel);
        QueryAllResourcesRequest signal = new QueryAllResourcesRequest();
        return (List)channel.transmit((Request)signal);
    }

    public static boolean deleteResources(Channel channel, Set<Integer> rids) {
        ClientCDOResProtocolImpl.assertValidChannel((Channel)channel);
        DeleteResourcesRequest signal = new DeleteResourcesRequest(rids);
        return (Boolean)channel.transmit((Request)signal);
    }

    protected void deactivate() throws Exception {
        this.listeners = null;
        super.deactivate();
    }
}

