/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.client.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import org.eclipse.emf.cdo.client.ResourceInfo;
import org.eclipse.emf.cdo.client.impl.ResourceInfoImpl;
import org.eclipse.emf.cdo.client.protocol.CDOResListener;
import org.eclipse.emf.cdo.client.protocol.ClientCDOResProtocolImpl;
import org.eclipse.emf.cdo.core.protocol.ResourceChangeInfo;
import org.eclipse.emf.cdo.examples.client.ResourceCache;
import org.eclipse.net4j.core.Channel;
import org.eclipse.net4j.core.Connector;
import org.eclipse.net4j.util.thread.DeadlockDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCacheImpl
implements ResourceCache,
CDOResListener {
    private ClientCDOResProtocolImpl protocol;
    private Connector connector;
    private Channel channel;
    private Object channelLock = new Object();
    private List<ResourceInfo> allResources = new ArrayList<ResourceInfo>();
    private List<ResourceCache.Listener> listeners = new ArrayList<ResourceCache.Listener>();

    public ResourceCacheImpl(ClientCDOResProtocolImpl protocol, Connector connector) {
        this.protocol = protocol;
        this.connector = connector;
        protocol.addListener((CDOResListener)this);
        this.init();
    }

    private void init() {
        Thread thread = Executors.defaultThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ResourceCacheImpl.this.channelLock;
                synchronized (object) {
                    ResourceCacheImpl.this.channel = ResourceCacheImpl.this.connector.addChannel("cdores");
                    ResourceCacheImpl.this.channelLock.notifyAll();
                }
                List resources = ClientCDOResProtocolImpl.queryAllResources((Channel)ResourceCacheImpl.this.channel);
                if (resources != null && !resources.isEmpty()) {
                    List list = ResourceCacheImpl.this.allResources;
                    synchronized (list) {
                        for (ResourceInfo resourceInfo : resources) {
                            ResourceCacheImpl.this.allResources.add(resourceInfo);
                        }
                    }
                    ResourceCacheImpl.this.notifyListeners();
                }
            }
        });
        thread.start();
    }

    @Override
    public void addListener(ResourceCache.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ResourceCache.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<ResourceInfo> getAllResources() {
        return this.allResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel getChannel() {
        Object object = this.channelLock;
        synchronized (object) {
            while (this.channel == null) {
                DeadlockDetector.wait((Object)this.channelLock);
            }
        }
        return this.channel;
    }

    @Override
    public void dispose() {
        this.protocol.removeListener((CDOResListener)this);
        this.protocol = null;
        if (this.channel != null) {
            try {
                try {
                    this.channel.stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            finally {
                this.channel = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResourcesChanged(Channel channel, List<ResourceChangeInfo> changes) {
        if (channel == this.channel) {
            boolean modified = false;
            List<ResourceInfo> list = this.allResources;
            synchronized (list) {
                for (ResourceChangeInfo change : changes) {
                    ResourceInfoImpl resourceInfo = new ResourceInfoImpl(change.getPath(), change.getRID(), true);
                    switch (change.getChangeKind()) {
                        case 1: {
                            if (this.allResources.contains(resourceInfo)) break;
                            this.allResources.add((ResourceInfo)resourceInfo);
                            modified = true;
                            break;
                        }
                        case 2: {
                            if (!this.allResources.remove(resourceInfo)) break;
                            modified = true;
                        }
                    }
                }
            }
            if (modified) {
                this.notifyListeners();
            }
        }
    }

    private void notifyListeners() {
        for (ResourceCache.Listener listener : this.listeners) {
            listener.notifyResourcesChanged(this);
        }
    }
}

