/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.ui.internal.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.cdo.examples.ui.ResourceFactoryHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class CDOImportWizardPage
extends WizardPage {
    private static final String SETTING_SOURCE_URI = "CDOImportWizardPage.SOURCE_URI";
    private static final String SETTING_RESOURCE_FACTORY = "CDOImportWizardPage.RESOURCE_FACTORY";
    private static final String SETTING_DESTINATION_PATH = "CDOImportWizardPage.DESTINATION_PATH";
    private IStructuredSelection selection;
    private Text sourceURIField;
    private Combo resourceFactoryField;
    private Button browseWorkspaceButton;
    private Button browseFileSystemButton;
    private Text destinationPathField;

    public CDOImportWizardPage(IStructuredSelection selection) {
        super("CDOImportWizardPage");
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        try {
            Composite control = new Composite(parent, 0);
            control.setLayout((Layout)new GridLayout(1, false));
            control.setLayoutData((Object)new GridData(272));
            Group sourceGroup = this.createGroup(control, "Source");
            Label sourceURILabel = new Label((Composite)sourceGroup, 0);
            sourceURILabel.setText("URI:");
            Composite grid = this.createGrid((Composite)sourceGroup, 3);
            this.sourceURIField = new Text(grid, 2048);
            this.sourceURIField.setLayoutData((Object)new GridData(768));
            this.sourceURIField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CDOImportWizardPage.this.dialogChanged();
                }
            });
            this.browseWorkspaceButton = new Button(grid, 8);
            this.browseWorkspaceButton.setText("Workspace...");
            this.browseWorkspaceButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    CDOImportWizardPage.this.browseWorkspace();
                }
            });
            this.browseFileSystemButton = new Button(grid, 8);
            this.browseFileSystemButton.setText("File System...");
            this.browseFileSystemButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    CDOImportWizardPage.this.browseFileSystem();
                }
            });
            Label resourceFactoryLabel = new Label((Composite)sourceGroup, 0);
            resourceFactoryLabel.setText("Factory:");
            this.resourceFactoryField = new Combo((Composite)sourceGroup, 2052);
            this.resourceFactoryField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CDOImportWizardPage.this.dialogChanged();
                }
            });
            this.resourceFactoryField.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    CDOImportWizardPage.this.dialogChanged();
                }
            });
            Group destinationGroup = this.createGroup(control, "Destination");
            Label pathLabel = new Label((Composite)destinationGroup, 0);
            pathLabel.setText("Path:");
            this.destinationPathField = new Text((Composite)destinationGroup, 2048);
            this.destinationPathField.setLayoutData((Object)new GridData(768));
            this.destinationPathField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CDOImportWizardPage.this.dialogChanged();
                }
            });
            this.initValues();
            this.setControl((Control)control);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void browseWorkspace() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)root, 1);
        dialog.setBlockOnOpen(true);
        dialog.setAllowUserToToggleDerived(true);
        dialog.setTitle("Import CDO Resource");
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length != 0 && result[0] instanceof IFile) {
            String fullPath = ((IFile)result[0]).getFullPath().toString();
            URI uri = URI.createPlatformResourceURI((String)fullPath);
            this.sourceURIField.setText(uri.toString());
        }
    }

    protected void browseFileSystem() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText("Import CDO Resource");
        String fileName = dialog.open();
        if (fileName != null) {
            String fullPath = new File(fileName).getAbsolutePath();
            URI uri = URI.createFileURI((String)fullPath);
            this.sourceURIField.setText(uri.toString());
        }
    }

    protected Group createGroup(Composite parent, String title) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        group.setText(title);
        return group;
    }

    protected Composite createGrid(Composite parent, int numColumns) {
        GridData gd = new GridData(768);
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Composite grid = new Composite(parent, 0);
        grid.setLayoutData((Object)gd);
        grid.setLayout((Layout)layout);
        return grid;
    }

    protected void initValues() {
        IDialogSettings settings;
        Object firstElement;
        ArrayList<String> extensions = new ArrayList<String>(ResourceFactoryHelper.getExtensions());
        Collections.sort(extensions);
        for (String ext : extensions) {
            this.resourceFactoryField.add(ext);
        }
        if (this.selection != null && (firstElement = this.selection.getFirstElement()) instanceof IFile) {
            IFile file = (IFile)firstElement;
            this.sourceURIField.setText("platform:/resource" + file.getFullPath().toString());
        }
        if ((settings = this.getDialogSettings()) != null) {
            String ext;
            if (this.getSourceURI().length() == 0) {
                String uri = settings.get(SETTING_SOURCE_URI);
                this.sourceURIField.setText(uri == null ? "" : uri);
            }
            this.resourceFactoryField.setText((ext = settings.get(SETTING_RESOURCE_FACTORY)) == null ? "" : ext);
            String path = settings.get(SETTING_DESTINATION_PATH);
            this.destinationPathField.setText(path == null ? "" : path);
        } else {
            this.resourceFactoryField.setText("xmi");
        }
        this.sourceURIField.selectAll();
    }

    public void saveValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String uri = this.getSourceURI();
            settings.put(SETTING_SOURCE_URI, uri);
            String ext = this.getResourceFactoryExtension();
            settings.put(SETTING_RESOURCE_FACTORY, ext);
            String path = this.getDestinationPath();
            settings.put(SETTING_DESTINATION_PATH, path);
        }
    }

    protected void dialogChanged() {
        this.setMessage(null);
        this.setErrorMessage(null);
        String uri = this.getSourceURI();
        if (uri.length() == 0) {
            this.setMessage("Enter the URI of the file to be imported.");
            return;
        }
        String ext = this.getResourceFactoryExtension();
        if (ext.length() == 0) {
            this.setMessage("Select a resource factory to use for import.");
            return;
        }
        if (ResourceFactoryHelper.getResourceFactory(ext) == null) {
            this.setErrorMessage("Invalid resource factory");
            this.resourceFactoryField.setFocus();
            return;
        }
        if (this.getDestinationPath().length() == 0) {
            this.setMessage("Enter the destinationy path.");
            return;
        }
    }

    public String getResourceFactoryExtension() {
        return this.resourceFactoryField.getText().trim();
    }

    public String getSourceURI() {
        return this.sourceURIField.getText().trim();
    }

    public String getDestinationPath() {
        return this.destinationPathField.getText().trim();
    }
}

