/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.adapter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.adapter.ManagerAspectData;
import org.eclipse.net4j.examples.mvc.util.AbstractAspectDataMap;
import org.eclipse.net4j.examples.mvc.util.AmbiguousFactoriesException;
import org.eclipse.net4j.examples.mvc.util.MissingFactoryException;
import org.eclipse.net4j.examples.mvc.util.Pair;
import org.eclipse.net4j.util.BeanHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdapterManager<TARGET>
extends AbstractAspectDataMap<ManagerAspectData<TARGET>, TARGET>
implements IAdapter.Manager<TARGET> {
    @Override
    public Set<IAdapter.Factory<TARGET>> getAdapterFactories(Class aspect) {
        ManagerAspectData data = (ManagerAspectData)this.getAspectData(aspect);
        return data.getAdapterFactories();
    }

    @Override
    public Map<TARGET, IAdapter<TARGET>> getAdapters(Class aspect) {
        ManagerAspectData data = (ManagerAspectData)this.getAspectData(aspect);
        return data.getAdapters();
    }

    @Override
    public void addAdapterFactory(IAdapter.Factory<TARGET> adapterFactory) {
        Class[] classArray = adapterFactory.getAspects();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class aspect = classArray[n];
            ManagerAspectData data = (ManagerAspectData)this.ensureAspectData(aspect);
            data.getAdapterFactories().add(adapterFactory);
            ++n;
        }
    }

    @Override
    public void removeAdapterFactory(IAdapter.Factory<TARGET> adapterFactory) {
        Class[] classArray = adapterFactory.getAspects();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class aspect = classArray[n];
            this.getAdapterFactories(aspect).remove(adapterFactory);
            ++n;
        }
    }

    @Override
    public IAdapter<TARGET> adapt(Class aspect, TARGET target) {
        Map<TARGET, IAdapter<TARGET>> adapters = this.getAdapters(aspect);
        IAdapter<TARGET> adapter = adapters.get(target);
        if (adapter == null) {
            adapter = this.createAdapter(aspect, target);
            Class[] classArray = adapter.getAspects();
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class a = classArray[n];
                this.getAdapters(a).put(target, adapter);
                ++n;
            }
        }
        return adapter;
    }

    @Override
    public void removeAdapter(TARGET target) {
        Class[] classArray = this.getAspects();
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            Class a = classArray[n];
            this.getAdapters(a).remove(target);
            ++n;
        }
    }

    protected IAdapter<TARGET> createAdapter(Class aspect, TARGET target) throws AmbiguousFactoriesException, MissingFactoryException {
        IAdapter.Factory<TARGET> factory = this.getFactory(aspect, target.getClass());
        IAdapter<TARGET> adapter = factory.createAdapter();
        adapter.setTarget(target);
        return adapter;
    }

    protected IAdapter.Factory<TARGET> getFactory(Class aspect, Class targetClass) {
        Set<IAdapter.Factory<TARGET>> allFactories = this.getAdapterFactories(aspect);
        ArrayList<Pair<Class, IAdapter.Factory<TARGET>>> possibleFactories = new ArrayList<Pair<Class, IAdapter.Factory<TARGET>>>();
        for (IAdapter.Factory<TARGET> factory : allFactories) {
            Class[] adaptableClasses = factory.getAdaptableClasses();
            int i = 0;
            while (i < adaptableClasses.length) {
                Class adaptableClass = adaptableClasses[i];
                if (adaptableClass.isAssignableFrom(targetClass)) {
                    possibleFactories.add(new Pair<Class, IAdapter.Factory<TARGET>>(adaptableClass, factory));
                }
                ++i;
            }
        }
        if (possibleFactories.size() == 0) {
            throw new MissingFactoryException(aspect, targetClass);
        }
        if (possibleFactories.size() == 1) {
            return (IAdapter.Factory)((Pair)possibleFactories.iterator().next()).getSecond();
        }
        return this.resolveAmbiguousFactories(possibleFactories);
    }

    protected IAdapter.Factory<TARGET> resolveAmbiguousFactories(List<Pair<Class, IAdapter.Factory<TARGET>>> possibleFactories) {
        Class[] array = new Class[possibleFactories.size()];
        int i = 0;
        for (Pair<Class, IAdapter.Factory<TARGET>> pair : possibleFactories) {
            array[i++] = pair.getFirst();
        }
        try {
            Class result = BeanHelper.mostSpecificClass((Class[])array);
            for (Pair<Class, IAdapter.Factory<TARGET>> pair : possibleFactories) {
                if (pair.getFirst() != result) continue;
                return pair.getSecond();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    @Override
    protected ManagerAspectData<TARGET> createData() {
        return new ManagerAspectData();
    }
}

