/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.binding;

import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IBinding;
import org.eclipse.net4j.examples.mvc.IController;
import org.eclipse.net4j.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBinding<TARGET>
implements IBinding<TARGET> {
    private IController<TARGET> controller;
    private String targetName;
    private IAdapter<TARGET> adapter;

    public AbstractBinding(IController<TARGET> controller, String targetName) {
        this.controller = controller;
        this.targetName = targetName;
        controller.addBinding(this);
    }

    @Override
    public IController<TARGET> getController() {
        return this.controller;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public TARGET getTarget() {
        return this.adapter == null ? null : (TARGET)this.adapter.getTarget();
    }

    @Override
    public TARGET setTarget(TARGET target) {
        TARGET oldTarget;
        TARGET TARGET = oldTarget = this.adapter == null ? null : (TARGET)this.adapter.getTarget();
        if (target == oldTarget) {
            return target;
        }
        if (oldTarget != null) {
            this.adapter.removeBinding(this);
        }
        if (target != null) {
            this.adapter = this.controller.adapt(this.getAspect(), target);
            this.adapter.addBinding(this);
        }
        return oldTarget;
    }

    @Override
    public IAdapter<TARGET> getAdapter() {
        return this.adapter;
    }

    @Override
    public Object[] getMetaDataKeys() {
        return this.adapter.getMetaDataKeys();
    }

    @Override
    public Object getMetaData(Object key) {
        return this.adapter.getMetaData(key);
    }

    public String toString() {
        return String.valueOf(StringHelper.getSimpleClassName(this.getClass())) + "(aspect: " + StringHelper.getSimpleClassName((Class)this.getAspect()) + ", adapter: " + this.adapter + ")";
    }
}

