/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.internal.xpand.build.EcoreModelResourceVisitor;
import org.eclipse.gmf.internal.xpand.build.MetaModelSource;

class WorkspaceModelRegistry
implements MetaModelSource {
    private final Map<String, Descriptor> pathToDescriptor = new TreeMap<String, Descriptor>();
    private final Map<String, Descriptor> uriToDescriptor = new TreeMap<String, Descriptor>();
    private final ResourceSet resourceSet = new ResourceSetImpl();

    public WorkspaceModelRegistry() {
        this.resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
    }

    public EPackage find(String nsURI) {
        Descriptor d = this.uriToDescriptor.get(nsURI);
        return d == null ? null : (EPackage)d.resource.getContents().get(0);
    }

    public void build(IProject project, IProgressMonitor monitor) throws CoreException {
        EcoreModelResourceVisitor visitor = new EcoreModelResourceVisitor(monitor);
        project.accept((IResourceVisitor)visitor);
        this.handleCollectedData(visitor);
    }

    public void build(IProject project, IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        EcoreModelResourceVisitor visitor = new EcoreModelResourceVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.handleCollectedData(visitor);
    }

    private void handleCollectedData(EcoreModelResourceVisitor visitor) {
        Descriptor d2;
        Descriptor d;
        for (IFile f : visitor.getRemovedModelFiles()) {
            String workspacePath = this.getKeyPath(f);
            d = this.pathToDescriptor.remove(workspacePath);
            if (d != null) {
                d2 = this.uriToDescriptor.remove(d.nsURI);
                assert (d2 == d);
            }
            this.delist(d);
        }
        HashSet<IFile> filesToAdd = new HashSet<IFile>(visitor.getNewModelFiles());
        for (IFile f : visitor.getChangedModelFiles()) {
            d = this.pathToDescriptor.remove(this.getKeyPath(f));
            if (d != null) {
                d2 = this.uriToDescriptor.remove(d.nsURI);
                assert (d2 == d);
                this.delist(d);
            }
            filesToAdd.add(f);
        }
        for (IFile f : filesToAdd) {
            try {
                Resource r = this.attemptLoad(f);
                if (r == null || !this.hasSuitableContent(r)) continue;
                Descriptor d3 = this.createDescriptor(f, r);
                assert (d3 != null);
                this.pathToDescriptor.put(d3.workspacePath, d3);
                this.uriToDescriptor.put(d3.nsURI, d3);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Resource attemptLoad(IFile file) throws IOException {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
        Resource res = this.getResourceSet(file).getResource(uri, true);
        if (res == null) {
            throw new FileNotFoundException("Can't load model from " + file.getFullPath());
        }
        return res;
    }

    private ResourceSet getResourceSet(IFile file) {
        return this.resourceSet;
    }

    private boolean hasSuitableContent(Resource r) {
        assert (r != null);
        return r.getContents().get(0) instanceof EPackage;
    }

    private Descriptor createDescriptor(IFile f, Resource res) {
        String path = this.getKeyPath(f);
        EPackage p = (EPackage)res.getContents().get(0);
        String nsURI = p.getNsURI();
        if (nsURI == null) {
            throw new IllegalArgumentException("Invalid model file (missed nsURI) " + path);
        }
        return new Descriptor(path, nsURI, res);
    }

    private void delist(Descriptor d) {
        d.resource.unload();
        d.resource.getResourceSet().getResources().remove((Object)d.resource);
    }

    private String getKeyPath(IFile f) {
        return f.getFullPath().toString();
    }

    private static class Descriptor {
        final String workspacePath;
        final String nsURI;
        final Resource resource;

        public Descriptor(String workspacePath, String nsURI, Resource res) {
            assert (workspacePath != null && nsURI != null && res != null);
            this.workspacePath = workspacePath;
            this.nsURI = nsURI;
            this.resource = res;
        }
    }
}

