/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.providers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphElementTypes;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateEdgeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewForKindOperation;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.TitleStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class GMFGraphViewProvider
extends AbstractProvider
implements IViewProvider {
    public final boolean provides(IOperation operation) {
        if (operation instanceof CreateViewForKindOperation) {
            return this.provides((CreateViewForKindOperation)operation);
        }
        assert (operation instanceof CreateViewOperation);
        if (operation instanceof CreateDiagramViewOperation) {
            return this.provides((CreateDiagramViewOperation)operation);
        }
        if (operation instanceof CreateEdgeViewOperation) {
            return this.provides((CreateEdgeViewOperation)operation);
        }
        if (operation instanceof CreateNodeViewOperation) {
            return this.provides((CreateNodeViewOperation)operation);
        }
        return false;
    }

    protected boolean provides(CreateViewForKindOperation op) {
        return true;
    }

    protected boolean provides(CreateDiagramViewOperation op) {
        return "GMFGraph".equals(op.getSemanticHint()) && GMFGraphVisualIDRegistry.getDiagramVisualID(this.getSemanticElement(op.getSemanticAdapter())) != -1;
    }

    protected boolean provides(CreateNodeViewOperation op) {
        int visualID;
        if (op.getContainerView() == null) {
            return false;
        }
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        if (op.getSemanticHint() == null) {
            if (elementType != null || domainElement == null) {
                return false;
            }
            visualID = GMFGraphVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement);
        } else {
            visualID = GMFGraphVisualIDRegistry.getVisualID(op.getSemanticHint());
            if (elementType != null) {
                if (!GMFGraphElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
                    return false;
                }
                String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
                if (!op.getSemanticHint().equals(elementTypeHint)) {
                    return false;
                }
                if (domainElement != null && visualID != GMFGraphVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) {
                    return false;
                }
            } else {
                if (!"GMFGraph".equals(GMFGraphVisualIDRegistry.getModelID(op.getContainerView()))) {
                    return false;
                }
                switch (visualID) {
                    case 2005: 
                    case 2006: 
                    case 2007: 
                    case 2008: 
                    case 2009: 
                    case 3009: 
                    case 3010: 
                    case 3011: 
                    case 3012: 
                    case 3013: 
                    case 3014: 
                    case 3015: 
                    case 3016: 
                    case 3017: 
                    case 3018: 
                    case 3019: 
                    case 3020: 
                    case 3021: 
                    case 3022: 
                    case 3023: 
                    case 3024: 
                    case 3025: 
                    case 3026: 
                    case 3027: 
                    case 3028: {
                        if (domainElement != null && visualID == GMFGraphVisualIDRegistry.getNodeVisualID(op.getContainerView(), domainElement)) break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
        }
        return 2005 == visualID || 2006 == visualID || 2007 == visualID || 2008 == visualID || 2009 == visualID || 3009 == visualID || 3010 == visualID || 3011 == visualID || 3012 == visualID || 3013 == visualID || 3014 == visualID || 3022 == visualID || 3023 == visualID || 3026 == visualID || 3015 == visualID || 3016 == visualID || 3017 == visualID || 3024 == visualID || 3027 == visualID || 3018 == visualID || 3019 == visualID || 3020 == visualID || 3021 == visualID || 3025 == visualID || 3028 == visualID;
    }

    protected boolean provides(CreateEdgeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (!GMFGraphElementTypes.isKnownElementType(elementType) || !(elementType instanceof IHintedType)) {
            return false;
        }
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        if (elementTypeHint == null || op.getSemanticHint() != null && !elementTypeHint.equals(op.getSemanticHint())) {
            return false;
        }
        int visualID = GMFGraphVisualIDRegistry.getVisualID(elementTypeHint);
        EObject domainElement = this.getSemanticElement(op.getSemanticAdapter());
        return domainElement == null || visualID == GMFGraphVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    public Diagram createDiagram(IAdaptable semanticAdapter, String diagramKind, PreferencesHint preferencesHint) {
        Diagram diagram = NotationFactory.eINSTANCE.createDiagram();
        diagram.getStyles().add((Object)NotationFactory.eINSTANCE.createDiagramStyle());
        diagram.setType("GMFGraph");
        diagram.setElement(this.getSemanticElement(semanticAdapter));
        diagram.setMeasurementUnit(MeasurementUnit.PIXEL_LITERAL);
        return diagram;
    }

    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        int visualID = semanticHint == null ? GMFGraphVisualIDRegistry.getNodeVisualID(containerView, domainElement) : GMFGraphVisualIDRegistry.getVisualID(semanticHint);
        switch (visualID) {
            case 2005: {
                return this.createCompartment_2005(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2006: {
                return this.createNode_2006(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2007: {
                return this.createConnection_2007(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2008: {
                return this.createFigureGallery_2008(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 2009: {
                return this.createDiagramLabel_2009(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3009: {
                return this.createFigureDescriptor_3009(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3010: {
                return this.createRectangle_3010(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3011: {
                return this.createRectangle_3011(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3012: {
                return this.createEllipse_3012(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3013: {
                return this.createRoundedRectangle_3013(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3014: {
                return this.createPolyline_3014(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3022: {
                return this.createPoint_3022(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3023: {
                return this.createPolygon_3023(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3026: {
                return this.createLabel_3026(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3015: {
                return this.createEllipse_3015(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3016: {
                return this.createRoundedRectangle_3016(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3017: {
                return this.createPolyline_3017(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3024: {
                return this.createPolygon_3024(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3027: {
                return this.createLabel_3027(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3018: {
                return this.createRectangle_3018(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3019: {
                return this.createEllipse_3019(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3020: {
                return this.createRoundedRectangle_3020(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3021: {
                return this.createPolyline_3021(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3025: {
                return this.createPolygon_3025(domainElement, containerView, index, persisted, preferencesHint);
            }
            case 3028: {
                return this.createLabel_3028(domainElement, containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Edge createEdge(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        String elementTypeHint = ((IHintedType)elementType).getSemanticHint();
        switch (GMFGraphVisualIDRegistry.getVisualID(elementTypeHint)) {
            case 4002: {
                return this.createChildAccess_4002(this.getSemanticElement(semanticAdapter), containerView, index, persisted, preferencesHint);
            }
            case 4003: {
                return this.createCompartmentAccessor_4003(containerView, index, persisted, preferencesHint);
            }
            case 4004: {
                return this.createDiagramLabelAccessor_4004(containerView, index, persisted, preferencesHint);
            }
            case 4006: {
                return this.createNodeContentPane_4006(containerView, index, persisted, preferencesHint);
            }
            case 4005: {
                return this.createDiagramElementFigure_4005(containerView, index, persisted, preferencesHint);
            }
        }
        return null;
    }

    public Node createCompartment_2005(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(GMFGraphVisualIDRegistry.getType(2005));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5005));
        this.createCompartment((View)node, GMFGraphVisualIDRegistry.getType(7005), true, true, true, true);
        return node;
    }

    public Node createNode_2006(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(GMFGraphVisualIDRegistry.getType(2006));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5006));
        this.createCompartment((View)node, GMFGraphVisualIDRegistry.getType(7006), true, true, true, true);
        return node;
    }

    public Node createConnection_2007(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(GMFGraphVisualIDRegistry.getType(2007));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5007));
        this.createCompartment((View)node, GMFGraphVisualIDRegistry.getType(7007), true, true, true, true);
        return node;
    }

    public Node createFigureGallery_2008(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(GMFGraphVisualIDRegistry.getType(2008));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5009));
        this.createCompartment((View)node, GMFGraphVisualIDRegistry.getType(7008), true, true, false, false);
        return node;
    }

    public Node createDiagramLabel_2009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(GMFGraphVisualIDRegistry.getType(2009));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        this.stampShortcut(containerView, (Node)node);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5013));
        this.createCompartment((View)node, GMFGraphVisualIDRegistry.getType(7009), true, true, true, true);
        return node;
    }

    public Node createFigureDescriptor_3009(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
        node.setType(GMFGraphVisualIDRegistry.getType(3009));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle nodeFontStyle = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (nodeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            nodeFontStyle.setFontName(fontData.getName());
            nodeFontStyle.setFontHeight(fontData.getHeight());
            nodeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            nodeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            nodeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fillColor");
        ViewUtil.setStructuralFeatureValue((View)node, (EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_FillColor(), (Object)FigureUtilities.RGBToInteger((RGB)fillRGB));
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5008));
        return node;
    }

    public Node createRectangle_3010(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3010));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createRectangle_3011(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3011));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createEllipse_3012(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3012));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createRoundedRectangle_3013(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3013));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPolyline_3014(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3014));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPoint_3022(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3022));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPolygon_3023(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3023));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createLabel_3026(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3026));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5010));
        return node;
    }

    public Node createEllipse_3015(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3015));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createRoundedRectangle_3016(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3016));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPolyline_3017(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3017));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPolygon_3024(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3024));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createLabel_3027(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3027));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5011));
        return node;
    }

    public Node createRectangle_3018(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3018));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createEllipse_3019(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3019));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createRoundedRectangle_3020(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3020));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPolyline_3021(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3021));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createPolygon_3025(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3025));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        return node;
    }

    public Node createLabel_3028(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = NotationFactory.eINSTANCE.createNode();
        node.getStyles().add((Object)NotationFactory.eINSTANCE.createDescriptionStyle());
        node.setType(GMFGraphVisualIDRegistry.getType(3028));
        ViewUtil.insertChildView((View)containerView, (View)node, (int)index, (boolean)persisted);
        node.setElement(domainElement);
        IPreferenceStore cfr_ignored_0 = (IPreferenceStore)preferencesHint.getPreferenceStore();
        this.createLabel((View)node, GMFGraphVisualIDRegistry.getType(5012));
        return node;
    }

    public Edge createChildAccess_4002(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(GMFGraphVisualIDRegistry.getType(4002));
        edge.setElement(domainElement);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        return edge;
    }

    public Edge createCompartmentAccessor_4003(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(GMFGraphVisualIDRegistry.getType(4003));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        return edge;
    }

    public Edge createDiagramLabelAccessor_4004(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(GMFGraphVisualIDRegistry.getType(4004));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        return edge;
    }

    public Edge createNodeContentPane_4006(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(GMFGraphVisualIDRegistry.getType(4006));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        return edge;
    }

    public Edge createDiagramElementFigure_4005(View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Connector edge = NotationFactory.eINSTANCE.createConnector();
        edge.getStyles().add((Object)NotationFactory.eINSTANCE.createFontStyle());
        RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
        ArrayList<RelativeBendpoint> points = new ArrayList<RelativeBendpoint>(2);
        points.add(new RelativeBendpoint());
        points.add(new RelativeBendpoint());
        bendpoints.setPoints(points);
        edge.setBendpoints((Bendpoints)bendpoints);
        ViewUtil.insertChildView((View)containerView, (View)edge, (int)index, (boolean)persisted);
        edge.setType(GMFGraphVisualIDRegistry.getType(4005));
        edge.setElement(null);
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.lineColor");
        ViewUtil.setStructuralFeatureValue((View)edge, (EStructuralFeature)NotationPackage.eINSTANCE.getLineStyle_LineColor(), (Object)FigureUtilities.RGBToInteger((RGB)lineRGB));
        FontStyle edgeFontStyle = (FontStyle)edge.getStyle(NotationPackage.Literals.FONT_STYLE);
        if (edgeFontStyle != null) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)prefStore, (String)"Appearance.defaultFont");
            edgeFontStyle.setFontName(fontData.getName());
            edgeFontStyle.setFontHeight(fontData.getHeight());
            edgeFontStyle.setBold((fontData.getStyle() & 1) != 0);
            edgeFontStyle.setItalic((fontData.getStyle() & 2) != 0);
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"Appearance.fontColor");
            edgeFontStyle.setFontColor(FigureUtilities.RGBToInteger((RGB)fontRGB).intValue());
        }
        return edge;
    }

    private void stampShortcut(View containerView, Node target) {
        if (!"GMFGraph".equals(GMFGraphVisualIDRegistry.getModelID(containerView))) {
            EAnnotation shortcutAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            shortcutAnnotation.setSource("Shortcut");
            shortcutAnnotation.getDetails().put((Object)"modelID", (Object)"GMFGraph");
            target.getEAnnotations().add((Object)shortcutAnnotation);
        }
    }

    private Node createLabel(View owner, String hint) {
        DecorationNode rv = NotationFactory.eINSTANCE.createDecorationNode();
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    private Node createCompartment(View owner, String hint, boolean canCollapse, boolean hasTitle, boolean canSort, boolean canFilter) {
        Object rv = canCollapse ? NotationFactory.eINSTANCE.createBasicCompartment() : NotationFactory.eINSTANCE.createDecorationNode();
        if (hasTitle) {
            TitleStyle ts = NotationFactory.eINSTANCE.createTitleStyle();
            ts.setShowTitle(true);
            rv.getStyles().add((Object)ts);
        }
        if (canSort) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createSortingStyle());
        }
        if (canFilter) {
            rv.getStyles().add((Object)NotationFactory.eINSTANCE.createFilteringStyle());
        }
        rv.setType(hint);
        ViewUtil.insertChildView((View)owner, (View)rv, (int)-1, (boolean)true);
        return rv;
    }

    private EObject getSemanticElement(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        EObject eObject = (EObject)semanticAdapter.getAdapter(EObject.class);
        if (eObject != null) {
            return EMFCoreUtil.resolve((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)eObject), (EObject)eObject);
        }
        return null;
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }
}

