/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import org.eclipse.jet.compiler.BodyElements;
import org.eclipse.jet.compiler.JET2AST;
import org.eclipse.jet.compiler.JET2ASTVisitor;
import org.eclipse.jet.compiler.JET2CompilationUnit;
import org.eclipse.jet.compiler.XMLBodyElement;

public abstract class JET2ASTElement {
    private final int start;
    private final int end;
    private final JET2AST ast;
    private final int line;
    private JET2ASTElement parent = null;
    private final int column;

    public final JET2ASTElement getParent() {
        return this.parent;
    }

    final void setParent(JET2ASTElement parent) {
        this.parent = parent;
    }

    JET2ASTElement(JET2AST ast, int line, int column, int start, int end) {
        this.ast = ast;
        this.column = column;
        this.line = line;
        this.start = start;
        this.end = end;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public abstract void accept(JET2ASTVisitor var1);

    JET2AST getAst() {
        return this.ast;
    }

    public final int getLine() {
        return this.line;
    }

    private BodyElements getBodyElements(JET2ASTElement element) {
        BodyElements bodyElements = null;
        if (this.parent instanceof JET2CompilationUnit) {
            bodyElements = ((JET2CompilationUnit)this.parent).getInternalBodyElements();
        } else if (this.parent instanceof XMLBodyElement) {
            bodyElements = ((XMLBodyElement)this.parent).getInternalBodyElements();
        }
        return bodyElements;
    }

    public JET2ASTElement getNextElement() {
        JET2ASTElement next = null;
        if (this.parent != null) {
            BodyElements bodyElements = this.getBodyElements(this.parent);
            next = bodyElements != null ? bodyElements.elementAfter(this) : this.parent.getNextElement();
        }
        return next;
    }

    public JET2ASTElement getPrevElement() {
        JET2ASTElement prev = null;
        if (this.parent != null) {
            BodyElements bodyElements = this.getBodyElements(this.parent);
            prev = bodyElements != null ? bodyElements.elementBefore(this) : this.parent.getPrevElement();
        }
        return prev;
    }

    public final int getColumn() {
        return this.column;
    }

    public abstract boolean removeLineWhenOtherwiseEmpty();
}

