/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.exceptions.MissingRequiredAttributeException;
import org.eclipse.jet.taglib.AbstractIteratingTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.transform.TransformContextExtender;

public class StringTokensTag
extends AbstractIteratingTag {
    private String _string = null;
    private String _delimitedBy = null;
    private String _name = null;
    private String _delimiter = null;
    private String _reverse = null;
    private String _tokenLength = null;
    private Object tokenNode = null;
    private StringToken[] tokens = null;
    private int index = 0;

    public boolean doEvalLoopCondition(TagInfo tagInfo, JET2Context context) throws JET2TagException {
        boolean doAnotherIteration = false;
        boolean bl = doAnotherIteration = this.index < this.tokens.length;
        if (!doAnotherIteration) {
            return false;
        }
        context.setVariable(this._name, this.tokenNode);
        XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);
        xpathContext.setAttribute(this.tokenNode, "value", this.tokens[this.index].getToken());
        xpathContext.setAttribute(this.tokenNode, "delimiter", this.tokens[this.index].getDelimiter());
        xpathContext.setAttribute(this.tokenNode, "first", String.valueOf(this.tokens[this.index].isFirst()));
        xpathContext.setAttribute(this.tokenNode, "last", String.valueOf(this.tokens[this.index].isLast()));
        xpathContext.setAttribute(this.tokenNode, "index", String.valueOf(this.index));
        ++this.index;
        return doAnotherIteration;
    }

    public void doInitializeLoop(TagInfo tagInfo, JET2Context context) throws JET2TagException {
        XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);
        this._string = this.getAttribute("string");
        if (this._string == null) {
            throw new MissingRequiredAttributeException("string");
        }
        this._delimitedBy = this.getAttribute("delimitedBy");
        this._name = this.getAttribute("name");
        if (this._name == null) {
            throw new MissingRequiredAttributeException("name");
        }
        this._delimiter = this.getAttribute("delimiter");
        this._reverse = this.getAttribute("reverse");
        this._tokenLength = this.getAttribute("tokenLength");
        try {
            Object modelRoot = TransformContextExtender.loadModelFromString("<token/>", null, "xml");
            this.tokenNode = xpathContext.resolveSingle(modelRoot, "/token");
            boolean reverse = false;
            if ("true".equalsIgnoreCase(this._reverse)) {
                reverse = true;
            }
            if ("yes".equalsIgnoreCase(this._reverse)) {
                reverse = true;
            }
            int tokenLength = -1;
            try {
                tokenLength = Integer.parseInt(this._tokenLength);
            }
            catch (Throwable throwable) {}
            this.tokens = this.tokenize(this._string, this._delimitedBy, tokenLength, reverse);
            this.setDelimiter(this._delimiter);
        }
        catch (Exception e) {
            throw new JET2TagException(e);
        }
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        super.doAfterBody(td, context, out);
        context.removeVariable(this._name);
    }

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        super.doBeforeBody(td, context, out);
    }

    private StringToken[] tokenize(String string, String delimiters, int tokenLength, boolean reverse) {
        StringToken token;
        Vector<StringToken> v = new Vector<StringToken>();
        if (tokenLength > 0) {
            int i = 0;
            while (i < string.length()) {
                token = new StringToken();
                token.setToken(string.substring(i, i + tokenLength));
                token.setDelimiter("");
                token.setFirst(false);
                token.setLast(false);
                v.addElement(token);
                i += tokenLength;
            }
        } else if (delimiters.length() == 0) {
            StringTokenizer st = new StringTokenizer(string);
            while (st.hasMoreTokens()) {
                token = new StringToken();
                token.setToken(st.nextToken());
                token.setDelimiter("");
                token.setFirst(false);
                token.setLast(false);
                v.addElement(token);
            }
        } else {
            StringTokenizer st = new StringTokenizer(string, delimiters, true);
            String tok = "";
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                if (val.length() == 1 && delimiters.indexOf(val) > -1) {
                    StringToken token2 = new StringToken();
                    token2.setToken(tok);
                    token2.setDelimiter(val);
                    token2.setFirst(false);
                    token2.setLast(false);
                    v.addElement(token2);
                    tok = "";
                    continue;
                }
                tok = val;
            }
            if (tok.length() > 0) {
                StringToken token3 = new StringToken();
                token3.setToken(tok);
                token3.setDelimiter("");
                token3.setFirst(false);
                token3.setLast(false);
                v.addElement(token3);
            }
        }
        Object[] result = new StringToken[v.size()];
        v.copyInto(result);
        if (reverse) {
            StringToken[] backward = new StringToken[result.length];
            int i = 0;
            while (i < result.length) {
                backward[i] = result[result.length - 1 - i];
                ++i;
            }
            result = backward;
        }
        if (result.length > 0) {
            ((StringToken)result[0]).setFirst(true);
            ((StringToken)result[result.length - 1]).setLast(true);
        }
        return result;
    }

    private class StringToken {
        private String token;
        private String delimiter;
        private boolean first;
        private boolean last;

        public boolean isFirst() {
            return this.first;
        }

        public boolean isLast() {
            return this.last;
        }

        public String getToken() {
            return this.token;
        }

        public void setFirst(boolean first) {
            this.first = first;
        }

        public void setLast(boolean last) {
            this.last = last;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }
    }
}

