/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.java;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.codegen.jmerge.JControlModel;
import org.eclipse.emf.codegen.jmerge.JMerger;
import org.eclipse.emf.codegen.jmerge.PropertyMerger;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractEmptyTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.TagUtil;
import org.eclipse.jet.transform.TransformContextExtender;
import org.eclipse.jface.text.Position;

public class MergeTag
extends AbstractEmptyTag {
    private final String EMF_CODEGEN_RULES_URL = "platform:/plugin/org.eclipse.emf.codegen.ecore/templates/emf-merge.xml";
    private static final String JMERGE_POSITION_CATEGORY;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.taglib.java.MergeTag");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JMERGE_POSITION_CATEGORY = clazz.getName();
    }

    public void doAction(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        String rulesContext;
        String rules = this.getAttribute("rules");
        if (rules == null) {
            rules = "platform:/plugin/org.eclipse.emf.codegen.ecore/templates/emf-merge.xml";
        }
        if ((rulesContext = this.getAttribute("rulesContext")) == null) {
            rulesContext = "transform";
        }
        URL baseURL = TransformContextExtender.getInstance(context).getBaseURL(rulesContext);
        if (rules.startsWith("/")) {
            rules = rules.substring(1);
        }
        try {
            URL rulesURL = new URL(baseURL, rules);
            out.getDocument().addPositionCategory(JMERGE_POSITION_CATEGORY);
            out.addPosition(JMERGE_POSITION_CATEGORY, new MergePosition(rulesURL, out.getDocument().getLength()));
            out.addEventListener(JMERGE_POSITION_CATEGORY, new JMergeProcessor());
        }
        catch (MalformedURLException malformedURLException) {
            String msg = JET2Messages.MergeTag_CouldNotCreateURL;
            throw new JET2TagException(MessageFormat.format(msg, baseURL.toExternalForm(), rules));
        }
    }

    public static class MergePosition
    extends Position {
        private final URL rulesURL;

        public MergePosition(URL rulesURL, int offset) {
            super(offset);
            this.rulesURL = rulesURL;
        }

        public final URL getRulesURL() {
            return this.rulesURL;
        }
    }

    public static class JMergeProcessor
    implements IWriterListener {
        public void finalizeContent(JET2Writer writer, Object file) throws JET2TagException {
            if (file instanceof IFile) {
                IFile iFile = (IFile)file;
                if (!iFile.exists()) {
                    return;
                }
                if ("java".equals(iFile.getFileExtension())) {
                    this.jmerge(writer, iFile);
                } else if ("properties".equals(iFile.getFileExtension())) {
                    this.propmerge(writer, iFile);
                }
            }
        }

        private void propmerge(JET2Writer writer, IFile file) throws JET2TagException {
            PropertyMerger merger = new PropertyMerger();
            try {
                String targetPropertiesString = TagUtil.getContents(file.getLocation());
                merger.setSourceProperties(writer.getDocument().get());
                merger.setTargetProperties(targetPropertiesString);
                merger.merge();
                writer.getDocument().set(merger.getTargetProperties());
            }
            catch (CoreException coreException) {
                String msg = JET2Messages.MergeTag_CouldNotRead;
                throw new JET2TagException(MessageFormat.format(msg, file.getFullPath()));
            }
        }

        private void jmerge(JET2Writer writer, IFile iFile) throws JET2TagException {
            Position[] positions = writer.getPositions(JMERGE_POSITION_CATEGORY);
            try {
                String targetCUSource = TagUtil.getContents(iFile.getLocation());
                DOMFactory domFactory = new DOMFactory();
                IDOMCompilationUnit sourceCU = domFactory.createCompilationUnit(writer.toString(), iFile.getName());
                IDOMCompilationUnit targetCU = domFactory.createCompilationUnit(targetCUSource, iFile.getName());
                JControlModel controlModel = new JControlModel(((MergePosition)positions[0]).getRulesURL().toExternalForm());
                JMerger merger = new JMerger(controlModel, sourceCU, targetCU);
                merger.merge();
                writer.getDocument().set(targetCU.getContents());
            }
            catch (CoreException coreException) {
                String msg = JET2Messages.MergeTag_CouldNotRead;
                throw new JET2TagException(MessageFormat.format(msg, iFile.getFullPath()));
            }
        }

        public void postCommitContent(JET2Writer writer, Object file) {
        }
    }
}

