/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoopExpOperations {
    protected LoopExpOperations() {
    }

    public static <C, PM> boolean checkSourceCollection(LoopExp<C, PM> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object sourceType;
        boolean result = true;
        String message = null;
        OCLExpression source = loopExp.getSource();
        if (source != null && !((sourceType = source.getType()) instanceof CollectionType)) {
            result = false;
            message = OCLMessages.bind(OCLMessages.IteratorSource_ERROR_, loopExp.toString());
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 17, message, new Object[]{loopExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkLoopVariableInit(LoopExp<C, PM> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        String message = null;
        for (Variable loopiter : loopExp.getIterator()) {
            if (loopiter.getInitExpression() == null) continue;
            result = false;
            message = OCLMessages.bind(OCLMessages.IterateExpLoopVarInit_ERROR_, loopExp.toString());
            break;
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 18, message, new Object[]{loopExp}));
        }
        return result;
    }

    public static <C, PM> boolean checkLoopVariableType(LoopExp<C, PM> loopExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        CollectionType ct;
        Object elementType;
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(loopExp, context);
        if (env != null && loopExp.getSource() != null && loopExp.getSource().getType() instanceof CollectionType && (elementType = (ct = (CollectionType)loopExp.getSource().getType()).getElementType()) != null) {
            for (Variable loopiter : loopExp.getIterator()) {
                if (loopiter.getType() == null || TypeUtil.exactTypeMatch(env, loopiter.getType(), elementType)) continue;
                result = false;
                message = OCLMessages.bind(OCLMessages.TypeConformanceIteratorExpLoopVar_ERROR_, loopExp.toString());
                break;
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 19, message, new Object[]{loopExp}));
        }
        return result;
    }
}

