/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.examples.rdf;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.eodm.rdf.resource.RDFXMLResourceFactoryImpl;
import org.eclipse.eodm.rdfs.Ontology;
import org.eclipse.eodm.rdfs.RDFProperty;
import org.eclipse.eodm.rdfs.RDFSClass;
import org.eclipse.eodm.rdfs.RDFSLiteral;
import org.eclipse.eodm.rdfs.RDFSResource;
import org.eclipse.eodm.rdfs.RDFStatement;
import org.eclipse.eodm.rdfs.reasoner.InconsistentOntologyException;
import org.eclipse.eodm.rdfs.reasoner.RDFSReasoner;
import org.eclipse.eodm.rdfs.reasoner.RDFSReasonerException;
import org.eclipse.eodm.rdfs.reasoner.impl.RDFSReasonerFactoryImpl;

public class RDFSReasonerExample {
    protected static Ontology ontology = null;
    protected static RDFSReasoner reasoner = new RDFSReasonerFactoryImpl().createRDFSReasoner();

    public static void main(String[] args) {
        try {
            ontology = RDFSReasonerExample.loadOntology("testcase/test.rdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reasoner.initialize(ontology);
        }
        catch (InconsistentOntologyException e) {
            System.out.println(e.getMessage());
            return;
        }
        catch (RDFSReasonerException e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println("unknown exception" + e.getMessage());
            return;
        }
        RDFSReasonerExample.testWithReasonerInferface();
        RDFSReasonerExample.testWithModelInferface();
    }

    protected static void testWithModelInferface() {
        StringBuffer buffer = new StringBuffer();
        ontology.bindReasoner(reasoner);
        RDFSClass A = (RDFSClass)ontology.getContainedResource(null, "A");
        buffer.append("All descendant classes of A are: ");
        Iterator iter = A.getSubClass(true).iterator();
        while (iter.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFSClass E = (RDFSClass)ontology.getContainedResource(null, "E");
        buffer.delete(0, buffer.length());
        buffer.append("All super classes of E are: ");
        Iterator iter2 = E.getRDFSSubClassOf(true).iterator();
        while (iter2.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter2.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFProperty P4 = (RDFProperty)ontology.getContainedResource(null, "P4");
        buffer.delete(0, buffer.length());
        buffer.append("All sub properties of P4 are: ");
        Iterator iter3 = P4.getSubProperty(true).iterator();
        while (iter3.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter3.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFSClass G = (RDFSClass)ontology.getContainedResource(null, "G");
        buffer.delete(0, buffer.length());
        buffer.append("All instances of G are: ");
        Iterator iter4 = G.getInstance(true).iterator();
        while (iter4.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter4.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFProperty P1 = (RDFProperty)ontology.getContainedResource(null, "P1");
        buffer.delete(0, buffer.length());
        buffer.append("All triples of Property P1 are ");
        Iterator iter5 = P1.getPredicateStatement(true).iterator();
        while (iter5.hasNext()) {
            RDFStatement smt = (RDFStatement)iter5.next();
            buffer.append("<");
            buffer.append(RDFSReasonerExample.getResourceName(smt.getRDFSubject()));
            buffer.append("> <");
            buffer.append(RDFSReasonerExample.getResourceName(P1));
            buffer.append("> <");
            buffer.append(RDFSReasonerExample.getResourceName(smt.getRDFObject()));
            buffer.append(">\n  ");
        }
        System.out.println(buffer);
    }

    protected static void testWithReasonerInferface() {
        StringBuffer buffer = new StringBuffer();
        RDFSClass A = (RDFSClass)ontology.getContainedResource(null, "A");
        buffer.append("All descendant classes of A are: ");
        Iterator iter = reasoner.getDescendantClasses(A).iterator();
        while (iter.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFSClass E = (RDFSClass)ontology.getContainedResource(null, "E");
        buffer.delete(0, buffer.length());
        buffer.append("All super classes of E are: ");
        Iterator iter2 = reasoner.getAncestorClasses(E).iterator();
        while (iter2.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter2.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFProperty P4 = (RDFProperty)ontology.getContainedResource(null, "P4");
        buffer.delete(0, buffer.length());
        buffer.append("All sub properties of P4 are: ");
        Iterator iter3 = reasoner.getDescendantProperties(P4).iterator();
        while (iter3.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter3.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFSClass G = (RDFSClass)ontology.getContainedResource(null, "G");
        buffer.delete(0, buffer.length());
        buffer.append("All instances of G are: ");
        Iterator iter4 = reasoner.getInferredInstances(G).iterator();
        while (iter4.hasNext()) {
            buffer.append(RDFSReasonerExample.getResourceName(iter4.next()));
            buffer.append(" ");
        }
        System.out.println(buffer);
        RDFProperty P1 = (RDFProperty)ontology.getContainedResource(null, "P1");
        buffer.delete(0, buffer.length());
        buffer.append("All triples of Property P1 are ");
        Iterator iter5 = reasoner.getInferredStatements(P1).iterator();
        while (iter5.hasNext()) {
            RDFStatement smt = (RDFStatement)iter5.next();
            buffer.append("<");
            buffer.append(RDFSReasonerExample.getResourceName(smt.getRDFSubject()));
            buffer.append("> <");
            buffer.append(RDFSReasonerExample.getResourceName(P1));
            buffer.append("> <");
            buffer.append(RDFSReasonerExample.getResourceName(smt.getRDFObject()));
            buffer.append(">\n  ");
        }
        System.out.println(buffer);
    }

    private static String getResourceName(Object obj) {
        if (obj instanceof RDFSLiteral) {
            return ((RDFSLiteral)obj).getLexicalForm();
        }
        if (obj instanceof RDFSResource) {
            return ((RDFSResource)obj).getURI();
        }
        return "";
    }

    private static Ontology loadOntology(String fileName) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File(fileName).getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(Collections.EMPTY_MAP);
        return (Ontology)resource.getContents().get(0);
    }
}

