/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: HasValueRestriction.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.owl.owlbase;

import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Has Value Restriction</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasIndividualValue <em>hasIndividualValue</em>}</li>
 *   <li>{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasLiteralValue <em>hasLiteralValue</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getHasValueRestriction()
 * @model
 * @generated
 */
public interface HasValueRestriction extends OWLRestriction {
	/**
	 * Returns the value of the '<em><b>hasIndividualValue</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Has Individual Value</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>hasIndividualValue</em>' reference.
	 * @see #setHasIndividualValue(Individual)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getHasValueRestriction_HasIndividualValue()
	 * @model required="true"
	 * @generated
	 */
	Individual getHasIndividualValue();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasIndividualValue <em>hasIndividualValue</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>hasIndividualValue</em>' reference.
	 * @see #getHasIndividualValue()
	 * @generated
	 */
	void setHasIndividualValue(Individual value);

	/**
	 * Returns the value of the '<em><b>hasLiteralValue</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Has Literal Value</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>hasLiteralValue</em>' reference.
	 * @see #setHasLiteralValue(RDFSLiteral)
	 * @see org.eclipse.eodm.owl.owlbase.util.OWLBasePackage#getHasValueRestriction_HasLiteralValue()
	 * @model required="true"
	 * @generated
	 */
	RDFSLiteral getHasLiteralValue();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.owl.owlbase.HasValueRestriction#getHasLiteralValue <em>hasLiteralValue</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>hasLiteralValue</em>' reference.
	 * @see #getHasLiteralValue()
	 * @generated
	 */
	void setHasLiteralValue(RDFSLiteral value);

} // HasValueRestriction
