/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.mappings.CallinImplementorDyn;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class SerializationGenerator {
    private static final char[] RESTORE_ROLE = "restoreRole".toCharArray();
    private static final char[] RESTORE = "restore".toCharArray();
    private static final char[] IS_ASSIGNABLE_FROM = "isAssignableFrom".toCharArray();
    private static final char[] PUT = "put".toCharArray();
    private static final char[] ROLE_ARG_NAME = "role".toCharArray();
    private static final char[] CLASS_ARG_NAME = "clazz".toCharArray();
    private static final char[] CASTED_ROLE = "castedRole".toCharArray();

    public static void generateRestoreMethods(TypeDeclaration teamType, AstGenerator gen) {
        boolean superIsTeam = teamType.binding.superclass.isTeam();
        MethodDeclaration restore = gen.method(teamType.compilationResult, 4, gen.singleTypeReference(TypeConstants.VOID), RESTORE, null, new Statement[]{superIsTeam ? gen.messageSend(gen.superReference(), RESTORE, null) : gen.emptyStatement(), gen.messageSend(gen.thisReference(), IOTConstants.OT_INIT_CACHES, null)});
        if (superIsTeam) {
            restore.annotations = new Annotation[]{gen.markerAnnotation(TypeConstants.JAVA_LANG_OVERRIDE)};
        }
        AstEdit.addMethod(teamType, restore);
        MethodDeclaration restoreRole = gen.method(teamType.compilationResult, 4, TypeBinding.VOID, RESTORE_ROLE, new Argument[]{gen.argument(CLASS_ARG_NAME, gen.parameterizedQualifiedTypeReference(TypeConstants.JAVA_LANG_CLASS, new TypeReference[]{gen.wildcard(0)})), gen.argument(ROLE_ARG_NAME, gen.qualifiedTypeReference(TypeConstants.JAVA_LANG_OBJECT))});
        if (superIsTeam) {
            restoreRole.annotations = new Annotation[]{gen.markerAnnotation(TypeConstants.JAVA_LANG_OVERRIDE)};
        }
        AstEdit.addMethod(teamType, restoreRole);
    }

    public static void fillRestoreRole(TypeDeclaration teamType, FieldDeclaration[] caches) {
        AbstractMethodDeclaration restoreMethod = TypeAnalyzer.findMethodDecl(teamType, RESTORE_ROLE, 2);
        if (restoreMethod == null) {
            return;
        }
        boolean superIsTeam = teamType.binding.superclass.isTeam();
        AstGenerator gen = new AstGenerator(restoreMethod);
        Statement[] statements = new Statement[caches.length + (superIsTeam ? 1 : 0)];
        int i = 0;
        while (i < caches.length) {
            TypeReference cacheTypeRef = caches[i].type;
            if (!cacheTypeRef.resolvedType.isParameterizedType() || ((ParameterizedTypeBinding)cacheTypeRef.resolvedType).arguments.length != 2) {
                if (teamType.scope.environment().globalOptions.complianceLevel < 0x310000L) {
                    restoreMethod.statements = new Statement[]{gen.emptyStatement()};
                    restoreMethod.tagAsHavingErrors();
                    return;
                }
                throw new InternalCompilerError("Unexpected resolved cache type " + cacheTypeRef.resolvedType);
            }
            ParameterizedTypeBinding oldBinding = (ParameterizedTypeBinding)cacheTypeRef.resolvedType;
            ReferenceBinding roleBinding = (ReferenceBinding)oldBinding.arguments[1];
            cacheTypeRef = gen.getCacheTypeReference(teamType.scope, roleBinding.roleModel);
            statements[i] = gen.ifStatement(gen.messageSend(gen.classLiteralAccess(gen.typeReference(roleBinding)), IS_ASSIGNABLE_FROM, new Expression[]{gen.singleNameReference(CLASS_ARG_NAME)}), gen.block(new Statement[]{gen.localVariable(CASTED_ROLE, roleBinding, (Expression)gen.castExpression(gen.singleNameReference(ROLE_ARG_NAME), gen.typeReference(roleBinding), 2)), gen.localVariable(IOTConstants.BASE, gen.baseclassReference(roleBinding.baseclass(), true), (Expression)gen.messageSend(gen.singleNameReference(CASTED_ROLE), IOTConstants._OT_GETBASE, null)), gen.messageSend(gen.singleNameReference(caches[i].name), PUT, new Expression[]{gen.baseNameReference(IOTConstants.BASE), gen.singleNameReference(CASTED_ROLE)}), CallinImplementorDyn.DYNAMIC_WEAVING ? gen.messageSend(gen.castExpression(gen.singleNameReference(IOTConstants.BASE), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE), 2), IOTConstants.ADD_REMOVE_ROLE, new Expression[]{gen.singleNameReference(CASTED_ROLE), gen.booleanLiteral(true)}) : gen.messageSend(gen.castExpression(gen.singleNameReference(IOTConstants.BASE), gen.qualifiedTypeReference(IOTConstants.ORG_OBJECTTEAMS_IBOUNDBASE), 2), IOTConstants.ADD_ROLE, new Expression[]{gen.singleNameReference(CASTED_ROLE)}), gen.returnStatement(null)}));
            ++i;
        }
        if (superIsTeam) {
            statements[caches.length] = gen.messageSend(gen.superReference(), RESTORE_ROLE, new Expression[]{gen.singleNameReference(CLASS_ARG_NAME), gen.singleNameReference(ROLE_ARG_NAME)});
        }
        restoreMethod.setStatements(statements);
        if (StateMemento.hasMethodResolveStarted(teamType.binding)) {
            restoreMethod.resolve(teamType.scope);
        }
    }

    public static boolean isSerializationMethod(MethodBinding method) {
        int nParams = method.parameters.length;
        if (CharOperation.equals(method.selector, RESTORE)) {
            return nParams == 0;
        }
        if (CharOperation.equals(method.selector, RESTORE_ROLE)) {
            return nParams == 2;
        }
        return false;
    }
}

