/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.predicates.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.predicates.BuilderPredicate;
import org.eclipse.oomph.predicates.PredicatesPackage;
import org.eclipse.oomph.predicates.provider.Messages;
import org.eclipse.oomph.predicates.provider.PredicateItemProvider;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderPredicateItemProvider
extends PredicateItemProvider {
    private static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public BuilderPredicateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBuilderPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBuilderPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BuilderPredicate_builder_feature"), this.getString("_UI_BuilderPredicate_builder_description"), (EStructuralFeature)PredicatesPackage.Literals.BUILDER_PREDICATE__BUILDER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                ArrayList<String> result = new ArrayList<String>();
                IProject[] iProjectArray = WORKSPACE_ROOT.getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    try {
                        ICommand[] iCommandArray = project.getDescription().getBuildSpec();
                        int n3 = iCommandArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICommand command = iCommandArray[n4];
                            String name = command.getBuilderName();
                            if (!result.contains(name)) {
                                result.add(name);
                            }
                            ++n4;
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++n2;
                }
                Collections.sort(result);
                return result;
            }
        });
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/BuilderPredicate"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        String label = ((BuilderPredicate)object).getBuilder();
        return label == null || label.length() == 0 ? this.getString("_UI_BuilderPredicate_type") : NLS.bind((String)Messages.BuilderPredicateItemProvider_HasBuild_label, (Object)label);
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(BuilderPredicate.class)) {
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

