/*
 * Copyright (c) 2014, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.oomph.setup;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Project Container</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.oomph.setup.ProjectContainer#getProjects <em>Projects</em>}</li>
 * </ul>
 *
 * @see org.eclipse.oomph.setup.SetupPackage#getProjectContainer()
 * @model interface="true" abstract="true"
 * @generated
 */
public interface ProjectContainer extends Scope
{
  /**
   * Returns the value of the '<em><b>Projects</b></em>' containment reference list.
   * The list contents are of type {@link org.eclipse.oomph.setup.Project}.
   * It is bidirectional and its opposite is '{@link org.eclipse.oomph.setup.Project#getProjectContainer <em>Project Container</em>}'.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Projects</em>' containment reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Projects</em>' containment reference list.
   * @see org.eclipse.oomph.setup.SetupPackage#getProjectContainer_Projects()
   * @see org.eclipse.oomph.setup.Project#getProjectContainer
   * @model opposite="projectContainer" containment="true" resolveProxies="true" keys="name"
   *        extendedMetaData="name='project'"
   * @generated
   */
  EList<Project> getProjects();

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @model kind="operation"
   * @generated
   */
  ProjectContainer getProjectContainer();

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @model kind="operation"
   * @generated
   */
  ProjectCatalog getProjectCatalog();

} // ProjectContainer
