/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui.internal.pde;

import jakarta.inject.Inject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.oomph.ui.ToolButton;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.ui.internal.pde.Messages;
import org.eclipse.oomph.ui.internal.pde.Target;
import org.eclipse.oomph.ui.internal.pde.TargetElement;
import org.eclipse.oomph.ui.internal.pde.TargetManager;
import org.eclipse.oomph.ui.internal.pde.TargetSnapshot;
import org.eclipse.oomph.ui.internal.pde.UIPDEPlugin;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;

public class TargetMonitor
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.eclipse.oomph.ui.pde.TargetMonitor";
    private static final IPersistentPreferenceStore PREFERENCES = (IPersistentPreferenceStore)UIPDEPlugin.INSTANCE.getPreferenceStore();
    private static final String PREF_LINK_WITH_EDITOR = "link.with.editor";
    private static final String PREF_AUTO_SNAPSHOT = "auto.snapshot";
    private static final String PREF_AUTO_FOCUS = "auto.focus";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private static final Object NO_DELTA = new Object();
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String SPACE = "   ";
    private static final String EMPTY = "";
    @Inject
    IWorkbench workbench;
    @Inject
    IEventBroker broker;
    private Color redColor;
    private Color greenColor;
    private Color grayColor;
    private Font boldFont;
    private SharedLabelProvider sharedLabelProvider;
    private TableCombo targetsCombo;
    private TreeViewer snapshotsViewer;
    private Label changesLabel;
    private Label removalsLabel;
    private Label additionsLabel;
    private TreeViewer deltaViewer;
    private final Map<TargetSnapshot, Object> deltas = new WeakHashMap<TargetSnapshot, Object>();
    private final TakeSnapshotAction takeSnapshotAction = new TakeSnapshotAction();
    private final DeleteSelectedSnapshotsAction deleteSelectedSnapshotsAction = new DeleteSelectedSnapshotsAction();
    private final DeleteOldSnapshotsAction deleteOldSnapshotsAction = new DeleteOldSnapshotsAction();
    private boolean linkWithEditor;
    private boolean autoFocus;
    private final TargetManager targetManager = new TargetManager();
    private final TargetManager.Listener targetManagerListener = events -> UIUtil.asyncExec(() -> this.handleTargetManagerEvents(events));
    private final IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            if (TargetMonitor.this.linkWithEditor) {
                IWorkbenchPart part = partRef.getPart(false);
                TargetMonitor.this.monitorTarget(part);
            }
        }
    };
    private boolean settingTargetSelection;

    public void createPartControl(Composite parent) {
        Display display = parent.getDisplay();
        this.redColor = display.getSystemColor(3);
        this.greenColor = display.getSystemColor(6);
        this.grayColor = display.getSystemColor(15);
        this.boldFont = UIPDEPlugin.getBoldFont((Font)parent.getFont());
        this.sharedLabelProvider = new SharedLabelProvider();
        SashForm sashForm = new SashForm(parent, 66048);
        TargetMonitor.createArea((Composite)sashForm, this::createUpperHeader, this::createUpperBody);
        TargetMonitor.createArea((Composite)sashForm, this::createLowerHeader, this::createLowerBody);
        sashForm.setWeights(new int[]{3, 1});
        this.hookActionBars();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.deleteSelectedSnapshotsAction.updateEnablement();
        this.deleteOldSnapshotsAction.updateEnablement();
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().getPage().addPartListener(this.partListener);
        this.setDeltaViewerInput(null);
        this.targetManager.addListener(this.targetManagerListener);
    }

    public void dispose() {
        this.targetManager.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
    }

    public void setFocus() {
        this.snapshotsViewer.getControl().setFocus();
    }

    public ISelection getSelection() {
        if (this.snapshotsViewer.getControl().isFocusControl()) {
            return this.snapshotsViewer.getSelection();
        }
        if (this.deltaViewer.getControl().isFocusControl()) {
            return this.deltaViewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.snapshotsViewer.getControl().isFocusControl()) {
            this.snapshotsViewer.setSelection(selection);
        } else if (this.deltaViewer.getControl().isFocusControl()) {
            this.deltaViewer.setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.snapshotsViewer.addSelectionChangedListener(listener);
        this.deltaViewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.snapshotsViewer.removeSelectionChangedListener(listener);
        this.deltaViewer.removeSelectionChangedListener(listener);
    }

    private void bringEditorToTop(Target target) {
        ITargetHandle targetHandle = target.getHandle();
        if (targetHandle != null) {
            IWorkbenchPage page = this.getSite().getPage();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetHandle editorHandle;
                IEditorReference reference = iEditorReferenceArray[n2];
                IEditorPart editor = reference.getEditor(false);
                if (editor != null && targetHandle.equals(editorHandle = (ITargetHandle)editor.getAdapter(ITargetHandle.class))) {
                    page.bringToTop((IWorkbenchPart)editor);
                }
                ++n2;
            }
        }
    }

    private Target getSelectedTarget() {
        int selection = this.targetsCombo.getSelectionIndex();
        if (selection == -1) {
            return null;
        }
        TableItem item = this.targetsCombo.getTable().getItem(selection);
        return (Target)item.getData();
    }

    private void setSelectedTarget(Target target) {
        int i = 0;
        TableItem[] tableItemArray = this.targetsCombo.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (ObjectUtil.equals((Object)item.getData(), (Object)target)) {
                this.targetsCombo.select(i);
                return;
            }
            ++i;
            ++n2;
        }
    }

    private void handleTargetManagerEvents(List<TargetManager.Event> events) {
        boolean refreshTargets = false;
        boolean refreshSnapshots = false;
        block6: for (TargetManager.Event event : events) {
            Target target = event.getTarget();
            TargetSnapshot snapshot = event.getSnapshot();
            switch (event.getKind()) {
                case TargetAdded: 
                case TargetRemoved: 
                case TargetNameChanged: 
                case ActiveTargetChanged: {
                    refreshTargets = true;
                    break;
                }
                case MonitoredTargetChanged: {
                    refreshTargets = true;
                    UIUtil.asyncExec(() -> {
                        try {
                            this.settingTargetSelection = true;
                            this.setSelectedTarget(target);
                        }
                        finally {
                            this.settingTargetSelection = false;
                        }
                        this.snapshotsViewer.setInput((Object)target);
                        if (target != null && this.autoFocus) {
                            this.focusOn(target.getCurrentSnapshot());
                        }
                    });
                    break;
                }
                case TargetSnapshotAdded: 
                case TargetSnapshotRemoved: {
                    refreshTargets = true;
                    refreshSnapshots = true;
                    break;
                }
                case TargetSnapshotResolutionFinished: {
                    refreshSnapshots = true;
                    if (snapshot.getState() == TargetSnapshot.State.Resolving || !this.autoFocus) continue block6;
                    this.focusOn(snapshot);
                }
            }
        }
        if (refreshTargets) {
            this.refreshTargetsCombo();
        }
        if (refreshSnapshots) {
            this.snapshotsViewer.refresh();
        }
    }

    private void refreshTargetsCombo() {
        Target monitoredTarget = this.targetManager.getMonitoredTarget();
        int selection = -1;
        Table table = this.targetsCombo.getTable();
        table.removeAll();
        Target[] targets = this.targetManager.getTargets();
        int i = 0;
        while (i < targets.length) {
            Target target = targets[i];
            TableItem item = new TableItem(table, 0);
            item.setData((Object)target);
            item.setImage(0, UIPDEPlugin.INSTANCE.getSWTImage(target.isDefault() ? "target-default.png" : "target.png"));
            Object label = target.getName();
            if (target.isActive()) {
                label = (String)label + " (" + Messages.TargetMonitor_Active + ")";
                item.setFont(0, this.boldFont);
            }
            item.setText(0, Objects.requireNonNullElse(label, EMPTY));
            item.setText(1, Objects.requireNonNullElse(target.getLocation(), EMPTY));
            int snapshots = target.getSnapshots().length;
            if (snapshots > 0) {
                item.setText(2, NLS.bind((String)(snapshots == 1 ? Messages.TargetMonitor_OneSnapshot : Messages.TargetMonitor_Snapshots), (Object)snapshots));
            }
            if (target == monitoredTarget) {
                selection = i;
            }
            ++i;
        }
        if (selection != -1) {
            this.targetsCombo.select(selection);
        }
        this.takeSnapshotAction.updateEnablement();
    }

    private void targetSelectionChanged() {
        Target target;
        this.takeSnapshotAction.updateEnablement();
        if (!this.settingTargetSelection && (target = this.getSelectedTarget()) != null && target.monitor() && this.linkWithEditor) {
            this.bringEditorToTop(target);
        }
    }

    private void snapshotSelectionChanged() {
        this.deleteSelectedSnapshotsAction.updateEnablement();
        this.deleteOldSnapshotsAction.updateEnablement();
        ITreeSelection selection = this.snapshotsViewer.getStructuredSelection();
        int size = selection.size();
        if (size == 1) {
            Object object = selection.getFirstElement();
            TargetSnapshot snapshot = this.getSnapshot(object);
            if (snapshot != null) {
                TargetSnapshot.Delta delta = this.getDelta(snapshot);
                this.setDeltaViewerInput(delta);
                return;
            }
        } else if (size == 2) {
            Object[] objects = selection.toArray();
            TargetSnapshot snapshot = this.getSnapshot(objects[0]);
            TargetSnapshot previous = this.getSnapshot(objects[1]);
            if (snapshot != null && previous != null && snapshot != previous) {
                if (snapshot.getNumber() < previous.getNumber()) {
                    TargetSnapshot tmp = snapshot;
                    snapshot = previous;
                    previous = tmp;
                }
                TargetSnapshot.Delta delta = snapshot.createDelta(previous);
                this.setDeltaViewerInput(delta);
                return;
            }
        }
        this.setDeltaViewerInput(null);
    }

    private void focusOn(TargetSnapshot snapshot) {
        if (snapshot != null) {
            UIUtil.asyncExec((Control)this.snapshotsViewer.getControl(), () -> {
                this.snapshotsViewer.collapseAll();
                this.snapshotsViewer.expandToLevel((Object)snapshot, -1);
                ITreeSelection oldSelection = this.snapshotsViewer.getStructuredSelection();
                StructuredSelection newSelection = new StructuredSelection((Object)snapshot);
                if (!Objects.equals(newSelection, oldSelection)) {
                    this.snapshotsViewer.setSelection((ISelection)newSelection);
                }
            });
        }
    }

    private void monitorTarget(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorPart editor = (IEditorPart)part;
            ITargetHandle handle = (ITargetHandle)editor.getAdapter(ITargetHandle.class);
            if (handle != null) {
                Target target = this.targetManager.getTarget(handle);
                if (target != null) {
                    target.monitor();
                    return;
                }
            } else {
                IFile file = (IFile)editor.getEditorInput().getAdapter(IFile.class);
                if (file != null) {
                    Target[] targetArray = this.targetManager.getTargets();
                    int n = targetArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Target target = targetArray[n2];
                        if (file.equals((Object)target.getWorkspaceFile())) {
                            target.monitor();
                            return;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    private TargetSnapshot.Delta getDelta(TargetSnapshot snapshot) {
        Object result = this.deltas.computeIfAbsent(snapshot, k -> {
            TargetSnapshot.Delta delta = snapshot.createDelta();
            return delta == null ? NO_DELTA : delta;
        });
        return result == NO_DELTA ? null : (TargetSnapshot.Delta)result;
    }

    private void setDeltaViewerInput(TargetSnapshot.Delta delta) {
        TargetSnapshot.Delta oldDelta = (TargetSnapshot.Delta)this.deltaViewer.getInput();
        if (oldDelta != delta) {
            if (delta != null) {
                this.changesLabel.setText(delta.getChanges().length + "   (" + NLS.bind((String)Messages.TargetMonitor_SnapshotN, (Object)delta.getPrevious().getNumber()) + " \u2192 " + NLS.bind((String)Messages.TargetMonitor_SnapshotN, (Object)delta.getSnapshot().getNumber()) + ")");
                int removals = delta.getRemovedElements().size();
                this.removalsLabel.setText((String)(removals == 0 ? EMPTY : "-" + removals));
                int additions = delta.getAddedElements().size();
                this.additionsLabel.setText((String)(additions == 0 ? EMPTY : "+" + additions));
            } else {
                this.changesLabel.setText("0   (" + Messages.TargetMonitor_NoDelta + ")");
                this.removalsLabel.setText(EMPTY);
                this.additionsLabel.setText(EMPTY);
            }
            this.deltaViewer.setInput((Object)delta);
        }
    }

    private TargetSnapshot getSnapshot(Object object) {
        while (object != null) {
            if (object instanceof TargetSnapshot) {
                return (TargetSnapshot)object;
            }
            SnapshotsContentProvider contentProvider = (SnapshotsContentProvider)this.snapshotsViewer.getContentProvider();
            object = contentProvider.getParent(object);
        }
        return null;
    }

    private void hookActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TargetMonitor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.snapshotsViewer.getControl());
        this.snapshotsViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.snapshotsViewer);
    }

    private void hookDoubleClickAction() {
        this.snapshotsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
            }
        });
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.takeSnapshotAction);
        manager.add((IAction)this.deleteOldSnapshotsAction);
        manager.add((IAction)new Action(Messages.TargetMonitor_CollapseAll, UIPDEPlugin.INSTANCE.getImageDescriptor("collapse-all")){

            public void run() {
                TargetMonitor.this.snapshotsViewer.collapseAll();
            }
        });
        manager.add((IAction)new LinkWithEditorAction());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)new AutoSnapshotAction());
        manager.add((IAction)new AutoFocusAction());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager manager) {
        TargetSnapshot snapshot;
        Object object;
        ITreeSelection selection = this.snapshotsViewer.getStructuredSelection();
        int size = selection.size();
        if (size == 1 && (object = selection.getFirstElement()) instanceof TargetSnapshot && (snapshot = (TargetSnapshot)object).getXML() != null) {
            manager.add((IAction)new Action(Messages.TargetMonitor_Restore, UIPDEPlugin.INSTANCE.getImageDescriptor("restore.png")){

                public void run() {
                    snapshot.restore();
                }
            });
        }
        if (this.deleteSelectedSnapshotsAction.isEnabled()) {
            manager.add((IAction)this.deleteSelectedSnapshotsAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void createUpperHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        header.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        Label label = new Label(header, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(Messages.TargetMonitor_MonitoredTarget + ":");
        this.targetsCombo = new TableCombo(header, 2056);
        this.targetsCombo.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.targetsCombo.defineColumns(3);
        this.targetsCombo.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMonitor.this.targetSelectionChanged();
            }
        });
        this.refreshTargetsCombo();
        ToolButton button = new ToolButton(header, 8, UIPDEPlugin.INSTANCE.getSWTImage("preferences.png"), false);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        button.setToolTipText(Messages.TargetMonitor_Preferences);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getSite().getShell(), (String)"org.eclipse.pde.ui.TargetPlatformPreferencePage", null, null);
            dialog.open();
        }));
    }

    private void createUpperBody(final Composite parent) {
        this.snapshotsViewer = new TreeViewer(parent, 770);
        this.snapshotsViewer.setUseHashlookup(true);
        this.snapshotsViewer.setContentProvider((IContentProvider)new SnapshotsContentProvider());
        this.snapshotsViewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProvider(this.sharedLabelProvider));
        this.snapshotsViewer.setInput((Object)this.targetManager.getMonitoredTarget());
        this.snapshotsViewer.addSelectionChangedListener(event -> this.snapshotSelectionChanged());
        this.snapshotsViewer.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                UIUtil.asyncExec((Control)parent, () -> TargetMonitor.this.snapshotsViewer.expandToLevel(event.getElement(), -1));
            }

            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.snapshotsViewer);
    }

    private void createLowerHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        header.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(5).create());
        Label label = new Label(header, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label.setText(Messages.TargetMonitor_Changes + ":");
        this.changesLabel = new Label(header, 0);
        this.changesLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.removalsLabel = new Label(header, 0);
        this.removalsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().hint(36, -1).create());
        this.removalsLabel.setForeground(this.redColor);
        this.additionsLabel = new Label(header, 0);
        this.additionsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().hint(36, -1).create());
        this.additionsLabel.setForeground(this.greenColor);
    }

    private void createLowerBody(Composite parent) {
        this.deltaViewer = new TreeViewer(parent, 770);
        this.deltaViewer.setUseHashlookup(true);
        this.deltaViewer.setContentProvider((IContentProvider)new DeltaContentProvider());
        this.deltaViewer.setLabelProvider((IBaseLabelProvider)new DelegatingLabelProvider(this.sharedLabelProvider));
        this.deltaViewer.setInput(null);
    }

    private static Composite createArea(Composite parent, Consumer<Composite> headerCreator, Consumer<Composite> bodyCreator) {
        boolean firstArea = parent.getChildren().length == 0;
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        if (!firstArea) {
            TargetMonitor.createSeparator(area);
        }
        Composite header = new Composite(area, 0);
        header.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        header.setLayout((Layout)new FillLayout());
        header.setBackground(header.getDisplay().getSystemColor(22));
        headerCreator.accept(header);
        TargetMonitor.createSeparator(area);
        Composite body = new Composite(area, 0);
        body.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        body.setLayout((Layout)new FillLayout());
        bodyCreator.accept(body);
        return area;
    }

    private static void createSeparator(Composite parent) {
        GridData gridData = new GridData(768);
        gridData.heightHint = 1;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)gridData);
    }

    private final class AutoFocusAction
    extends ToggleAction {
        public AutoFocusAction() {
            super(Messages.TargetMonitor_AutoFocus, TargetMonitor.PREF_AUTO_FOCUS, null);
        }

        @Override
        protected void toggled(boolean checked) {
            Target target;
            TargetMonitor.this.autoFocus = checked;
            if (TargetMonitor.this.autoFocus && (target = TargetMonitor.this.getSelectedTarget()) != null) {
                TargetMonitor.this.focusOn(target.getCurrentSnapshot());
            }
        }
    }

    private final class AutoSnapshotAction
    extends ToggleAction {
        public AutoSnapshotAction() {
            super(Messages.TargetMonitor_AutoSnapshots, TargetMonitor.PREF_AUTO_SNAPSHOT, null);
        }

        @Override
        protected void toggled(boolean checked) {
            TargetMonitor.this.targetManager.setAutoSnapshot(checked);
        }
    }

    private final class DelegatingLabelProvider
    extends DelegatingStyledCellLabelProvider
    implements ILabelProvider {
        public DelegatingLabelProvider(SharedLabelProvider delegate) {
            super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)delegate);
        }

        public SharedLabelProvider getStyledStringProvider() {
            return (SharedLabelProvider)super.getStyledStringProvider();
        }

        public String getText(Object obj) {
            return this.getStyledStringProvider().getText(obj);
        }
    }

    private final class DeleteOldSnapshotsAction
    extends Action {
        public DeleteOldSnapshotsAction() {
            super(Messages.TargetMonitor_DeleteOldSnapshots, UIPDEPlugin.INSTANCE.getImageDescriptor("delete-old.png"));
            this.setEnabled(false);
        }

        public void updateEnablement() {
            Target target = TargetMonitor.this.getSelectedTarget();
            this.setEnabled(target != null && target.getSnapshots().length > 1);
        }

        public void run() {
            Target target = TargetMonitor.this.getSelectedTarget();
            List<TargetSnapshot> oldSnapshots = target.getOldSnapshots();
            target.deleteSnapshots(oldSnapshots);
            TargetMonitor.this.deltas.clear();
        }
    }

    private final class DeleteSelectedSnapshotsAction
    extends Action {
        private final List<TargetSnapshot> snapshots;

        public DeleteSelectedSnapshotsAction() {
            super(Messages.TargetMonitor_DeleteSnapshots, UIPDEPlugin.INSTANCE.getImageDescriptor("delete.png"));
            this.snapshots = new ArrayList<TargetSnapshot>();
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void updateEnablement() {
            block6: {
                try {
                    this.snapshots.clear();
                    selection = TargetMonitor.this.snapshotsViewer.getStructuredSelection();
                    if (selection == null || selection.isEmpty()) break block6;
                    var3_2 = selection.iterator();
                    ** GOTO lbl-1000
                }
                catch (Throwable var4_4) {
                    this.setEnabled(this.snapshots.isEmpty() == false);
                    throw var4_4;
                }
lbl10:
                // 2 sources

                while (true) {
                    this.setEnabled(v0);
                    return;
                }
lbl-1000:
                // 2 sources

                {
                    ** while (var3_2.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    block7: {
                        object = var3_2.next();
                        if (object instanceof TargetSnapshot) {
                            this.snapshots.add((TargetSnapshot)object);
                            continue;
                        }
                        this.snapshots.clear();
                        if (!this.snapshots.isEmpty()) break block7;
                        v0 = false;
                        ** GOTO lbl10
                    }
                    v0 = true;
                    ** continue;
lbl26:
                    // 1 sources

                    ** GOTO lbl10
                }
            }
            this.setEnabled(this.snapshots.isEmpty() == false);
        }

        public void run() {
            if (!this.snapshots.isEmpty()) {
                Target target = this.snapshots.get(0).getTarget();
                target.deleteSnapshots(this.snapshots);
                TargetMonitor.this.deltas.clear();
            }
        }
    }

    private final class DeltaContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object obj) {
            return this.getChildren(obj);
        }

        public Object[] getChildren(Object obj) {
            if (obj instanceof TargetSnapshot.Delta) {
                return ((TargetSnapshot.Delta)obj).getChanges();
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object obj) {
            if (obj instanceof TargetSnapshot.Delta.Change) {
                return ((TargetSnapshot.Delta.Change)obj).getDelta();
            }
            return null;
        }

        public boolean hasChildren(Object obj) {
            return obj instanceof TargetSnapshot.Delta;
        }
    }

    private final class LinkWithEditorAction
    extends ToggleAction {
        public LinkWithEditorAction() {
            super(Messages.TargetMonitor_LinkWithEditor, TargetMonitor.PREF_LINK_WITH_EDITOR, "link-editor");
        }

        @Override
        protected void toggled(boolean checked) {
            TargetMonitor.this.linkWithEditor = checked;
            if (TargetMonitor.this.linkWithEditor) {
                UIUtil.asyncExec(() -> {
                    IEditorPart editor = TargetMonitor.this.getSite().getPage().getActiveEditor();
                    if (editor != null) {
                        TargetMonitor.this.monitorTarget((IWorkbenchPart)editor);
                    }
                });
            }
        }
    }

    private final class SharedLabelProvider
    implements ILabelProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider,
    IColorProvider,
    IToolTipProvider {
        private final Image snapshotImage = UIPDEPlugin.INSTANCE.getSWTImage("snapshot.png");
        private final Image featureImage = UIPDEPlugin.INSTANCE.getSWTImage("feature.png");
        private final Image bundleImage = UIPDEPlugin.INSTANCE.getSWTImage("bundle.png");
        private final Image fragmentImage = UIPDEPlugin.INSTANCE.getSWTImage("fragment.png");
        private final Image sourceBundleImage = UIPDEPlugin.INSTANCE.getSWTImage("source-bundle.png");
        private final Image sourceFragmentImage = UIPDEPlugin.INSTANCE.getSWTImage("source-fragment.png");
        private final StyledString.Styler redStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = ((SharedLabelProvider)SharedLabelProvider.this).TargetMonitor.this.redColor;
            }
        };
        private final StyledString.Styler greenStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = ((SharedLabelProvider)SharedLabelProvider.this).TargetMonitor.this.greenColor;
            }
        };

        public String getText(Object obj) {
            return this.getStyledText(obj).getString();
        }

        public StyledString getStyledText(Object obj) {
            if (obj instanceof TargetSnapshot) {
                TargetSnapshot snapshot = (TargetSnapshot)obj;
                StyledString str = new StyledString(NLS.bind((String)Messages.TargetMonitor_SnapshotN, (Object)snapshot.getNumber()));
                final TargetSnapshot.State state = snapshot.getState();
                if (state == TargetSnapshot.State.Resolved) {
                    int elements = snapshot.getElements().length;
                    str.append(TargetMonitor.SPACE + NLS.bind((String)(elements == 1 ? Messages.TargetMonitor_OneElement : Messages.TargetMonitor_Elements), (Object)elements), StyledString.COUNTER_STYLER);
                    TargetSnapshot.Delta delta = TargetMonitor.this.getDelta(snapshot);
                    if (delta != null) {
                        int additions;
                        int removals = delta.getRemovedElements().size();
                        if (removals != 0) {
                            str.append("   -" + removals, this.redStyler);
                        }
                        if ((additions = delta.getAddedElements().size()) != 0) {
                            str.append("   +" + additions, this.greenStyler);
                        }
                    }
                } else {
                    str.append(TargetMonitor.SPACE + state.name(), new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.foreground = state == TargetSnapshot.State.Resolving ? ((SharedLabelProvider)SharedLabelProvider.this).TargetMonitor.this.grayColor : ((SharedLabelProvider)SharedLabelProvider.this).TargetMonitor.this.redColor;
                        }
                    });
                }
                return str;
            }
            if (obj instanceof TargetElement) {
                TargetElement element = (TargetElement)obj;
                return new StyledString(element.getName() + TargetMonitor.SPACE).append(element.getVersion().toString(), StyledString.DECORATIONS_STYLER);
            }
            if (obj instanceof IStatus) {
                IStatus status = (IStatus)obj;
                return new StyledString(status.getMessage());
            }
            if (obj instanceof TargetSnapshot.Delta.Change) {
                TargetSnapshot.Delta.Change change = (TargetSnapshot.Delta.Change)obj;
                return this.getStyledText(change.getElement());
            }
            return new StyledString(obj.toString());
        }

        public Image getImage(Object obj) {
            if (obj instanceof TargetSnapshot) {
                return this.snapshotImage;
            }
            if (obj instanceof TargetElement) {
                TargetElement element = (TargetElement)obj;
                switch (element.getType()) {
                    case Feature: {
                        return this.featureImage;
                    }
                    case Bundle: {
                        return element.isSource() ? this.sourceBundleImage : this.bundleImage;
                    }
                    case Fragment: {
                        return element.isSource() ? this.sourceFragmentImage : this.fragmentImage;
                    }
                }
            }
            if (obj instanceof IStatus) {
                IStatus status = (IStatus)obj;
                return UIUtil.getStatusImage((int)status.getSeverity());
            }
            if (obj instanceof TargetSnapshot.Delta.Change) {
                TargetSnapshot.Delta.Change change = (TargetSnapshot.Delta.Change)obj;
                return this.getImage(change.getElement());
            }
            return null;
        }

        public Color getForeground(Object obj) {
            if (obj instanceof TargetSnapshot) {
                TargetSnapshot.State state = ((TargetSnapshot)obj).getState();
                return state == TargetSnapshot.State.Resolving || state == TargetSnapshot.State.Canceled ? TargetMonitor.this.grayColor : null;
            }
            if (obj instanceof TargetSnapshot.Delta.Change) {
                TargetSnapshot.Delta.Change change = (TargetSnapshot.Delta.Change)obj;
                return change.getKind() == TargetSnapshot.Delta.Change.Kind.Removal ? TargetMonitor.this.redColor : TargetMonitor.this.greenColor;
            }
            return null;
        }

        public Color getBackground(Object obj) {
            return null;
        }

        public String getToolTipText(Object obj) {
            if (obj instanceof TargetSnapshot) {
                TargetSnapshot snapshot = (TargetSnapshot)obj;
                Object tooTip = DATE_FORMAT.format(new Date(snapshot.getTimeStamp()));
                String xml = snapshot.getXML();
                if (xml != null) {
                    tooTip = (String)tooTip + "\n\n" + xml;
                }
                return tooTip;
            }
            if (obj instanceof TargetElement) {
                TargetElement element = (TargetElement)obj;
                return element.getLocation();
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private final class SnapshotsContentProvider
    implements ITreeContentProvider {
        private final Map<IStatus, Object> statusParents = new WeakHashMap<IStatus, Object>();

        public Object[] getElements(Object obj) {
            return this.getChildren(obj);
        }

        public boolean hasChildren(Object obj) {
            return this.getChildren(obj).length != 0;
        }

        public Object[] getChildren(Object obj) {
            if (obj instanceof Target) {
                return ((Target)obj).getSnapshots();
            }
            if (obj instanceof TargetSnapshot) {
                TargetSnapshot snapshot = (TargetSnapshot)obj;
                switch (snapshot.getState()) {
                    case Resolved: {
                        return snapshot.getElements();
                    }
                    case Error: {
                        IStatus child = snapshot.getResolutionStatus();
                        this.statusParents.put(child, obj);
                        return new Object[]{child};
                    }
                }
            }
            if (obj instanceof IStatus) {
                Object[] children;
                Object[] objectArray = children = ((IStatus)obj).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    this.statusParents.put((IStatus)child, obj);
                    ++n2;
                }
                return children;
            }
            return NO_CHILDREN;
        }

        public Object getParent(Object obj) {
            if (obj instanceof IStatus) {
                return this.statusParents.get(obj);
            }
            if (obj instanceof TargetElement) {
                return ((TargetElement)obj).getSnapshot();
            }
            if (obj instanceof TargetSnapshot) {
                return ((TargetSnapshot)obj).getTarget();
            }
            return null;
        }
    }

    private final class TakeSnapshotAction
    extends Action {
        public TakeSnapshotAction() {
            super(Messages.TargetMonitor_TakeSnapshot, UIPDEPlugin.INSTANCE.getImageDescriptor("add.png"));
        }

        public void updateEnablement() {
            this.setEnabled(TargetMonitor.this.getSelectedTarget() != null);
        }

        public void run() {
            Target target = TargetMonitor.this.getSelectedTarget();
            if (target != null) {
                target.takeSnapshot();
            }
        }
    }

    private static abstract class ToggleAction
    extends Action {
        private final String preferenceKey;
        private boolean checked;

        public ToggleAction(String text, String preferenceKey, String imageKey) {
            super(text, 2);
            this.preferenceKey = preferenceKey;
            if (imageKey != null) {
                this.setImageDescriptor(UIPDEPlugin.INSTANCE.getImageDescriptor(imageKey));
            }
            this.checked = PREFERENCES.getBoolean(preferenceKey);
            this.setChecked(this.checked);
            this.toggled(this.checked);
        }

        public final void run() {
            this.checked = !this.checked;
            PREFERENCES.setValue(this.preferenceKey, this.checked);
            this.toggled(this.checked);
        }

        protected abstract void toggled(boolean var1);
    }
}

