/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.ui;

import java.util.ResourceBundle;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.FindAndReplaceTarget;
import org.eclipse.oomph.internal.ui.IRevertablePart;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.texteditor.FindReplaceAction;

public class OomphEditingDomainActionBarContributor
extends EditingDomainActionBarContributor {
    protected FindAction findAction;
    protected CollapseAllAction collapseAllAction;
    private RevertAction revertAction;

    public OomphEditingDomainActionBarContributor() {
    }

    public OomphEditingDomainActionBarContributor(int style) {
        super(style);
    }

    public void init(IActionBars actionBars) {
        this.findAction = this.createFindAction();
        if (this.findAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findAction);
        }
        this.collapseAllAction = this.createCollapseAllAction();
        this.revertAction = this.createRevertAction();
        if (this.revertAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revertAction);
        }
        super.init(actionBars);
    }

    protected FindAction createFindAction() {
        return new FindAction();
    }

    private CollapseAllAction createCollapseAllAction() {
        return new CollapseAllAction();
    }

    private RevertAction createRevertAction() {
        return new RevertAction();
    }

    protected DeleteAction createDeleteAction() {
        DeleteAction deleteAction = super.createDeleteAction();
        deleteAction.setId("delete");
        return deleteAction;
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        super.contributeToToolBar(toolBarManager);
        if (this.collapseAllAction != null) {
            toolBarManager.add((IAction)this.collapseAllAction);
        }
    }

    public void shareGlobalActions(IPage page, IActionBars actionBars) {
        super.shareGlobalActions(page, actionBars);
        if (this.findAction != null) {
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.findAction);
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.findAction != null) {
            this.findAction.setActiveWorkbenchPart(null);
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.setActiveWorkbenchPart(null);
        }
        if (this.revertAction != null) {
            this.revertAction.setActiveWorkbenchPart(null);
        }
    }

    public void activate() {
        super.activate();
        if (this.findAction != null) {
            this.findAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.collapseAllAction != null) {
            this.collapseAllAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
        if (this.revertAction != null) {
            this.revertAction.setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        menuManager.insertAfter("delete", (IContributionItem)new ActionContributionItem((IAction)this.findAction));
        menuManager.insertAfter("delete", (IContributionItem)new Separator());
    }

    public static final class CollapseAllAction
    extends Action {
        private IViewerProvider viewerProvider;

        public CollapseAllAction() {
            super("Collapse All", 1);
            this.setImageDescriptor(UIPlugin.INSTANCE.getImageDescriptor("collapse-all"));
            this.setToolTipText("Collapse all expanded elements");
        }

        public void run() {
            Viewer viewer = this.viewerProvider.getViewer();
            if (viewer instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)viewer;
                treeViewer.collapseAll();
            }
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof IViewerProvider) {
                this.viewerProvider = (IViewerProvider)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.viewerProvider = null;
            }
        }
    }

    public static class FindAction
    extends Action {
        private IWorkbenchPart workbenchPart;

        public FindAction() {
            super("Find/Replace...", UIPlugin.INSTANCE.getImageDescriptor("search"));
        }

        public void run() {
            IFindReplaceTarget adapter = (IFindReplaceTarget)this.workbenchPart.getAdapter(IFindReplaceTarget.class);
            if (adapter instanceof FindAndReplaceTarget) {
                FindAndReplaceTarget findAndReplaceTarget = (FindAndReplaceTarget)adapter;
                findAndReplaceTarget.initialize(this.workbenchPart);
            }
            new FindReplaceAction(null, null, this.workbenchPart){

                protected void initialize(ResourceBundle bundle, String prefix) {
                }
            }.run();
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            this.workbenchPart = workbenchPart;
            if (workbenchPart != null) {
                this.setEnabled(workbenchPart.getAdapter(IFindReplaceTarget.class) != null);
            }
        }
    }

    private static final class RevertAction
    extends Action {
        private IRevertablePart revertableEditor;

        private RevertAction() {
        }

        public void run() {
            this.revertableEditor.doRevert();
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof IRevertablePart) {
                this.revertableEditor = (IRevertablePart)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.revertableEditor = null;
            }
        }
    }
}

