/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectUtil {
    private ObjectUtil() {
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static <TYPE> TYPE adapt(Object object, Class<TYPE> type) {
        if (object == null) {
            return null;
        }
        Object adapter = null;
        if (type.isInstance(object)) {
            adapter = object;
        } else {
            try {
                adapter = AdaptableHelper.adapt(object, type);
                if (adapter == null) {
                    adapter = AdapterManagerHelper.adapt(object, type);
                }
            }
            catch (Throwable throwable) {}
        }
        return type.cast(adapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdaptableHelper {
        private AdaptableHelper() {
        }

        public static Object adapt(Object object, Class<?> type) {
            if (object instanceof IAdaptable) {
                return ((IAdaptable)object).getAdapter(type);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdapterManagerHelper {
        private static IAdapterManager adapterManager = Platform.getAdapterManager();

        private AdapterManagerHelper() {
        }

        public static Object adapt(Object object, Class<?> type) {
            if (adapterManager != null) {
                return adapterManager.getAdapter(object, type);
            }
            return null;
        }
    }
}

