/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.EclipseUIPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResourceImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.setup.SetupPrompter;
import org.eclipse.oomph.internal.ui.TaskItemDecorator;
import org.eclipse.oomph.jreinfo.ui.JREInfoUIPlugin;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.VariableType;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.ResourceMirror;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.p2.provider.SetupP2EditPlugin;
import org.eclipse.oomph.setup.p2.util.P2TaskUISevices;
import org.eclipse.oomph.setup.provider.SetupEditPlugin;
import org.eclipse.oomph.setup.ui.Messages;
import org.eclipse.oomph.setup.ui.P2TaskUIServicesPrompter;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.synchronizer.SynchronizerManager;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.UserCallback;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.intro.IIntroManager;
import org.osgi.framework.BundleContext;

public final class SetupUIPlugin
extends OomphUIPlugin {
    public static final SetupUIPlugin INSTANCE = new SetupUIPlugin();
    public static final String PLUGIN_ID = INSTANCE.getSymbolicName();
    public static final String PREF_HEADLESS = "headless.startup";
    public static final String PREF_SKIP_STARTUP_TASKS = "skip.startup.tasks";
    public static final String PREF_P2_STARTUP_TASKS = "p2.startup.tasks";
    public static final String PREF_ENABLE_PREFERENCE_RECORDER = "enable.preference.recorder";
    public static final String PREF_PREFERENCE_RECORDER_TARGET = "preference.recorder.target";
    public static final String PREF_INITIALIZED_PREFERENCE_PAGES = "initialized.preference.pages";
    public static final String PREF_IGNORED_PREFERENCE_PAGES = "ingored.preference.pages";
    public static final boolean QUESTIONNAIRE_SKIP = PropertiesUtil.isProperty((String)"oomph.setup.questionnaire.skip");
    private static final String RESTARTING_FILE_NAME = "restarting";
    private static final String ANNOTATION_SOURCE_INITIAL = "initial";
    private static final String ANNOTATION_DETAILS_KEY_OFFLINE = "offline";
    private static final String ANNOTATION_DETAILS_KEY_MIRRORS = "mirrors";
    private static final boolean SETUP_SKIP = PropertiesUtil.isProperty((String)"oomph.setup.skip");
    private static Implementation plugin;

    public SetupUIPlugin() {
        super(new ResourceLocator[]{JREInfoUIPlugin.INSTANCE, SetupEditPlugin.INSTANCE, SetupCorePlugin.INSTANCE, SetupP2EditPlugin.INSTANCE, P2UIPlugin.INSTANCE});
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static void initialStart(File ws, boolean offline, boolean mirrors) {
        Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
        annotation.setSource(ANNOTATION_SOURCE_INITIAL);
        annotation.getDetails().put((Object)ANNOTATION_DETAILS_KEY_OFFLINE, (Object)Boolean.toString(offline));
        annotation.getDetails().put((Object)ANNOTATION_DETAILS_KEY_MIRRORS, (Object)Boolean.toString(mirrors));
        File file = new File(ws, ".metadata/.plugins/" + INSTANCE.getSymbolicName() + "/restarting");
        SetupUIPlugin.saveRestartFile(file, annotation);
    }

    public static void restart(Trigger trigger, EList<SetupTask> setupTasks) {
        if (!setupTasks.isEmpty()) {
            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
            annotation.setSource(trigger.toString());
            annotation.getReferences().addAll(setupTasks);
            SetupUIPlugin.saveRestartFile(SetupUIPlugin.getRestartingFile(), annotation);
        }
        PlatformUI.getWorkbench().restart();
    }

    private static void saveRestartFile(File file, Annotation annotation) {
        try {
            Resource resource = SetupCoreUtil.createResourceSet().createResource(URI.createFileURI((String)file.toString()));
            resource.getContents().add((Object)annotation);
            resource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isSkipStartupTasks() {
        return plugin.getPreferenceStore().getBoolean(PREF_SKIP_STARTUP_TASKS);
    }

    private static File getRestartingFile() {
        return new File(INSTANCE.getStateLocation().toString(), RESTARTING_FILE_NAME);
    }

    static void performStartup() {
        if (!PropertiesUtil.isProperty((String)PREF_HEADLESS) && !SetupUtil.SETUP_ARCHIVER_APPLICATION) {
            final boolean synchronizerAvailable = SynchronizerManager.Availability.AVAILABLE;
            SetupTaskPerformer.RULE_VARIABLE_ADAPTER.toString();
            RecorderManager.INSTANCE.toString();
            final Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!SetupUtil.INSTALLER_APPLICATION) {
                        SetupUIPlugin.initJDTTemplateVariables();
                        SetupPropertyTester.setStarting(true);
                        final IWorkbench workbench = PlatformUI.getWorkbench();
                        IExtensionTracker extensionTracker = workbench.getExtensionTracker();
                        if (extensionTracker == null || workbench.getWorkbenchWindowCount() == 0) {
                            display.timerExec(1000, (Runnable)this);
                        } else {
                            if (!synchronizerAvailable || !SynchronizerManager.ENABLED) {
                                PreferenceManager preferenceManager = workbench.getPreferenceManager();
                                preferenceManager.remove("/org.eclipse.oomph.ui.preferences.OomphPreferencePage/org.eclipse.oomph.setup.SetupPreferencePage/org.eclipse.oomph.setup.SynchronizerPreferencePage");
                            }
                            if (SetupTaskPerformer.REMOTE_DEBUG) {
                                MessageDialog.openInformation((Shell)UIUtil.getShell(), (String)Messages.SetupUIPlugin_remoteDebugPauseDialog_title, (String)Messages.SetupUIPlugin_remoteDebugPauseDialog_message);
                            }
                            if ("macosx".equals(Platform.getOS())) {
                                new TaskItemDecorator();
                            }
                            RecorderManager.Lifecycle.start(display);
                            SetupUIPlugin.plugin.stopRecorder = true;
                            if (!(SETUP_SKIP || SetupUIPlugin.isSkipStartupTasks() && !SetupUIPlugin.getRestartingFile().exists())) {
                                new Job(Messages.SetupUIPlugin_setupCheckJob_name){

                                    protected IStatus run(IProgressMonitor monitor) {
                                        try {
                                            SetupUIPlugin.performStartup(workbench, monitor);
                                            IStatus iStatus = Status.OK_STATUS;
                                            return iStatus;
                                        }
                                        finally {
                                            SetupPropertyTester.setStarting(false);
                                        }
                                    }
                                }.schedule();
                            } else {
                                Job mirrorJob = new Job(Messages.SetupUIPlugin_initSetupModelsJob_name){

                                    protected IStatus run(IProgressMonitor monitor) {
                                        try {
                                            monitor.beginTask(Messages.SetupUIPlugin_initSetupModelsJob_taskName, 10);
                                            ResourceSet resourceSet = SetupCoreUtil.createResourceSet();
                                            resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                                            SetupUIPlugin.mirror(resourceSet, monitor, 10);
                                            SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
                                            SetupUIPlugin.handleBrandingNotificationURI(resourceSet);
                                            IStatus iStatus = Status.OK_STATUS;
                                            return iStatus;
                                        }
                                        finally {
                                            SetupPropertyTester.setStarting(false);
                                        }
                                    }
                                };
                                mirrorJob.schedule();
                            }
                        }
                    }
                }
            });
        }
    }

    private static void handleBrandingNotificationURI(ResourceSet resourceSet) {
        Index index;
        ProductCatalog productCatalog;
        ProductVersion productVersion;
        Product product;
        EObject selfProductVersion = resourceSet.getEObject(URI.createURI((String)"catalog:/self-product-catalog.setup#//@products[name='product']/@versions[name='version']"), false);
        if (selfProductVersion instanceof ProductVersion && (product = (productVersion = (ProductVersion)selfProductVersion).getProduct()) != null && (productCatalog = product.getProductCatalog()) != null && (index = productCatalog.getIndex()) != null) {
            String notificationURI = BaseUtil.getAnnotation((ModelElement)index, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"notificationURI");
            if (notificationURI != null) {
                String productLabel = product.getLabel();
                String productVersionLabel = productVersion.getLabel();
                if (productLabel != null && productLabel.startsWith("Eclipse") && productVersionLabel != null) {
                    SetupUIPlugin.handleBrandingNotificationURI(notificationURI, productLabel, productVersionLabel);
                }
            }
            try {
                SetupUIPlugin.handleProblemAnnotations(productVersion);
            }
            catch (Exception ex) {
                INSTANCE.log(ex, 2);
            }
            try {
                SetupUIPlugin.handleNotificationAnnotations(productVersion);
            }
            catch (Exception ex) {
                INSTANCE.log(ex, 2);
            }
        }
    }

    private static void handleBrandingNotificationURI(String notificationURI, String scope, String version) {
        if ("true".equals(PropertiesUtil.getProperty((String)"org.eclipse.oomph.setup.donate", (String)Boolean.toString(!Platform.inDevelopmentMode())))) {
            try {
                Version versionValue = Version.create((String)version);
                if (versionValue.compareTo((Object)Version.create((String)"4.16")) >= 0) {
                    String resolvedURI = notificationURI.toString().replace("${scope.version}", URI.encodeQuery((String)StringUtil.safe((String)version), (boolean)false)).replace("${scope}", URI.encodeQuery((String)StringUtil.safe((String)scope), (boolean)false).replace("+", "%2B"));
                    SetupPropertyTester.setDonating(resolvedURI);
                    if (SetupUIPlugin.rememberBrandingNotificationURI(notificationURI)) {
                        UIUtil.asyncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                                Command donateCommand = commandService.getCommand("org.eclipse.oomph.setup.donate");
                                if (donateCommand != null && donateCommand.isEnabled()) {
                                    try {
                                        donateCommand.executeWithChecks(handlerService.createExecutionEvent(donateCommand, null));
                                    }
                                    catch (Exception ex) {
                                        INSTANCE.log(ex, 2);
                                    }
                                }
                            }
                        });
                    }
                }
            }
            catch (Exception ex) {
                INSTANCE.log(ex, 2);
            }
        }
    }

    private static boolean rememberBrandingNotificationURI(String notificationURI) {
        boolean added;
        File file = new File(SetupContext.GLOBAL_SETUPS_LOCATION_URI.toFileString(), "brandingNotificationURIs.txt");
        LinkedHashSet<String> brandingNotificationURIs = new LinkedHashSet<String>();
        try {
            if (file.isFile()) {
                brandingNotificationURIs.addAll(IOUtil.readLines((File)file, (String)"UTF-8"));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (added = brandingNotificationURIs.add(notificationURI)) {
            try {
                IOUtil.writeLines((File)file, (String)"UTF-8", new ArrayList(brandingNotificationURIs));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return added;
    }

    private static List<Annotation> getAllAnnotations(ProductVersion productVersion, String source) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        annotations.addAll(SetupUIPlugin.getAnnotations((ModelElement)productVersion, source));
        Product product = productVersion.getProduct();
        annotations.addAll(SetupUIPlugin.getAnnotations((ModelElement)product, source));
        ProductCatalog productCatalog = product.getProductCatalog();
        annotations.addAll(SetupUIPlugin.getAnnotations((ModelElement)productCatalog, source));
        Index index = productCatalog.getIndex();
        annotations.addAll(SetupUIPlugin.getAnnotations((ModelElement)index, source));
        return annotations;
    }

    private static List<Annotation> getAnnotations(ModelElement modelElement, String source) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : modelElement.getAnnotations()) {
            if (!source.equals(annotation.getSource())) continue;
            result.add(annotation);
        }
        return result;
    }

    private static void handleProblemAnnotations(ProductVersion productVersion) {
        List<Annotation> problemAnnotations = SetupUIPlugin.getAllAnnotations(productVersion, "http://www.eclipse.org/oomph/setup/Problem");
        List<Annotation> applicableNotificationAnnotations = SetupUIPlugin.gatherApplicableAnnotations(productVersion, problemAnnotations, null);
        if (!applicableNotificationAnnotations.isEmpty()) {
            SetupPropertyTester.setProblem((String)applicableNotificationAnnotations.get(0).getDetails().get((Object)"uri"));
        }
    }

    private static void handleNotificationAnnotations(ProductVersion productVersion) {
        List<Annotation> notificationAnnotations;
        List<Annotation> applicableNotificationAnnotations;
        if ("true".equals(PropertiesUtil.getProperty((String)"org.eclipse.oomph.setup.notification", (String)Boolean.toString(!Platform.inDevelopmentMode()))) && !(applicableNotificationAnnotations = SetupUIPlugin.gatherApplicableAnnotations(productVersion, notificationAnnotations = SetupUIPlugin.getAllAnnotations(productVersion, "http://www.eclipse.org/oomph/setup/Notification"), SetupUIPlugin::isRememberedNotificationURI)).isEmpty()) {
            SetupPropertyTester.setNotifications(applicableNotificationAnnotations);
            UIUtil.asyncExec(() -> {
                IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
                introManager.closeIntro(introManager.getIntro());
                UIUtil.asyncExec(() -> {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                    Command notificationsCommand = commandService.getCommand("org.eclipse.oomph.setup.notifications");
                    if (notificationsCommand != null && notificationsCommand.isEnabled()) {
                        try {
                            notificationsCommand.executeWithChecks(handlerService.createExecutionEvent(notificationsCommand, null));
                        }
                        catch (Exception ex) {
                            INSTANCE.log(ex, 2);
                        }
                    }
                });
            });
        }
    }

    private static List<Annotation> gatherApplicableAnnotations(ProductVersion productVersion, List<Annotation> annotations, Predicate<String> ignore) {
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        Profile profile = agent == null ? null : agent.getCurrentProfile();
        IQueryable queriable = null;
        SetupTaskPerformer performer = null;
        ArrayList<Annotation> applicableNotificationAnnotations = new ArrayList<Annotation>();
        block4: for (Annotation notificationAnnotation : annotations) {
            String uri = (String)notificationAnnotation.getDetails().get((Object)"uri");
            if (uri == null || ignore != null && ignore.test(uri)) continue;
            for (EObject eObject : notificationAnnotation.getContents()) {
                IQueryResult result;
                Requirement requirement;
                String filter;
                if (!(eObject instanceof Requirement) || profile == null) continue block4;
                if (queriable == null) {
                    IInstallableUnit jreIU = null;
                    try {
                        jreIU = P2Util.createJREIU((String)"jre");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (jreIU != null) {
                        ArrayList<IInstallableUnit> extraIUs = new ArrayList<IInstallableUnit>();
                        extraIUs.add(jreIU);
                        extraIUs.addAll(SetupUIPlugin.getInstalledJREs());
                        queriable = QueryUtil.compoundQueryable((IQueryable)profile, (IQueryable)new CollectionResult(extraIUs));
                    }
                }
                if ((filter = (requirement = (Requirement)eObject).getFilter()) != null) {
                    if (performer == null) {
                        try {
                            performer = SetupUIPlugin.createSetupTaskPerformer(productVersion.getProduct().getProductCatalog().getIndex().eResource().getResourceSet(), Trigger.MANUAL);
                        }
                        catch (Exception ex) {
                            continue block4;
                        }
                    }
                    if (!performer.matchesFilterContext(filter)) continue;
                }
                if (!(result = queriable.query(QueryUtil.createMatchQuery((IExpression)requirement.toIRequirement().getMatches(), (Object[])new Object[0]), null)).isEmpty() ? requirement.getMax() == 0 : requirement.getMin() > 0) continue block4;
            }
            applicableNotificationAnnotations.add(notificationAnnotation);
        }
        return applicableNotificationAnnotations;
    }

    private static List<IInstallableUnit> getInstalledJREs() {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        try {
            Object[] vmInstallTypes;
            Class javaRuntimeClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.launching", (String)"org.eclipse.jdt.launching.JavaRuntime");
            Object[] objectArray = vmInstallTypes = (Object[])ReflectUtil.invokeMethod((String)"getVMInstallTypes", (Object)javaRuntimeClass);
            int n = vmInstallTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object vmInstallType = objectArray[n2];
                String id = (String)ReflectUtil.invokeMethod((String)"getId", (Object)vmInstallType);
                if ("org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType".equals(id) || "org.eclipse.jdt.internal.launching.macosx.MacOSXType".equals(id)) {
                    Object[] vmInstalls = (Object[])ReflectUtil.invokeMethod((String)"getVMInstalls", (Object)vmInstallType);
                    Class vmStandinClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.launching", (String)"org.eclipse.jdt.launching.VMStandin");
                    Constructor constructor = ReflectUtil.getConstructor((Class)vmStandinClass, (Class[])new Class[]{vmInstalls.getClass().getComponentType()});
                    Object[] objectArray2 = vmInstalls;
                    int n3 = vmInstalls.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object vmInstall = objectArray2[n4];
                        Object vmStandin = constructor.newInstance(vmInstall);
                        String javaVersion = (String)ReflectUtil.invokeMethod((String)"getJavaVersion", vmStandin);
                        if (javaVersion != null) {
                            try {
                                Version version = Version.create((String)javaVersion);
                                MetadataFactory.InstallableUnitDescription iuDescription = new MetadataFactory.InstallableUnitDescription();
                                iuDescription.setId("installed.jre");
                                iuDescription.setVersion(version);
                                iuDescription.addProvidedCapabilities(List.of(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)"installed.jre", (Version)version)));
                                result.add(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iuDescription));
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static boolean isRememberedNotificationURI(String notificationURI) {
        return !SetupUIPlugin.rememberNotificationURI(notificationURI, SetupContext.GLOBAL_SETUPS_LOCATION_URI, false) || !SetupUIPlugin.rememberNotificationURI(notificationURI, SetupContext.CONFIGURATION_STATE_LOCATION_URI, false) || !SetupUIPlugin.rememberNotificationURI(notificationURI, SetupContext.WORKSPACE_STATE_LOCATION_URI, false);
    }

    public static void rememberNotificationURI(String notificationURI, URI baseLocation) {
        SetupUIPlugin.rememberNotificationURI(notificationURI, baseLocation, true);
    }

    private static boolean rememberNotificationURI(String notificationURI, URI baseLocation, boolean save) {
        boolean added;
        File file = new File(baseLocation.toFileString(), "notificationURIs.txt");
        LinkedHashSet<String> notifications = new LinkedHashSet<String>();
        try {
            if (file.isFile()) {
                notifications.addAll(IOUtil.readLines((File)file, (String)"UTF-8"));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if ((added = notifications.add(notificationURI)) && save) {
            try {
                ArrayList lines = new ArrayList(notifications);
                IOUtil.writeLines((File)file, (String)"UTF-8", lines.subList(0, Math.min(lines.size(), 500)));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return added;
    }

    private static void initJDTTemplateVariables() {
        try {
            boolean hasJDTUserName = !StringUtil.isEmpty((String)System.getProperty("jdt.user.name"));
            Class javaUIPluginClass = CommonPlugin.loadClass((String)"org.eclipse.jdt.ui", (String)"org.eclipse.jdt.internal.ui.JavaPlugin");
            Object javaUIPlugin = ReflectUtil.invokeMethod((String)"getDefault", (Object)javaUIPluginClass);
            Object codeTemplateContextRegistry = ReflectUtil.invokeMethod((String)"getCodeTemplateContextRegistry", (Object)javaUIPlugin);
            Iterator it = (Iterator)ReflectUtil.invokeMethod((String)"contextTypes", (Object)codeTemplateContextRegistry);
            block2: while (it.hasNext()) {
                TemplateContextType templateContextType = (TemplateContextType)it.next();
                Iterator it2 = templateContextType.resolvers();
                while (it2.hasNext()) {
                    TemplateVariableResolver templateVariableResolver = (TemplateVariableResolver)it2.next();
                    if (!"user".equals(templateVariableResolver.getType())) continue;
                    if (hasJDTUserName) {
                        templateContextType.addResolver((TemplateVariableResolver)new SimpleTemplateVariableResolver(templateVariableResolver.getType(), templateVariableResolver.getDescription()){

                            protected String resolve(TemplateContext context) {
                                return PropertiesUtil.getProperty((String)"jdt.user.name", (String)PropertiesUtil.getProperty((String)"user.name"));
                            }
                        });
                    }
                    templateContextType.addResolver((TemplateVariableResolver)new SimpleTemplateVariableResolver("location", Messages.SetupUIPlugin_locationVariableResolver_description){

                        protected String resolve(TemplateContext context) {
                            Object result = PropertiesUtil.getProperty((String)"jdt.user.location", (String)"");
                            if (!StringUtil.isEmpty((String)result) && !((String)result).startsWith(" ")) {
                                result = " " + (String)result;
                            }
                            return result;
                        }
                    });
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void mirror(final ResourceSet resourceSet, IProgressMonitor monitor, int work) {
        ResourceMirror resourceMirror = new ResourceMirror(resourceSet){

            protected void run(String taskName, IProgressMonitor monitor) {
                ArrayList<URI> uris = new ArrayList<URI>();
                URIConverter uriConverter = resourceSet.getURIConverter();
                URI[] uRIArray = new URI[]{SetupContext.INSTALLATION_SETUP_URI, SetupContext.WORKSPACE_SETUP_URI, SetupContext.USER_SETUP_URI};
                int n = uRIArray.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri = uRIArray[n2];
                    if (uri != null && uriConverter.exists(uri, null)) {
                        uris.add(uri);
                    }
                    ++n2;
                }
                this.perform(uris);
                this.resolveProxies();
            }
        };
        resourceMirror.begin((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)work));
    }

    private static Set<? extends EObject> checkCrossReferences(ResourceSet resourceSet, URI uri) {
        EList contents;
        HashSet<EObject> result = new HashSet<EObject>();
        Resource resource = resourceSet.getResource(uri, false);
        if (resource != null && !(contents = resource.getContents()).isEmpty()) {
            EObject eObject = (EObject)contents.get(0);
            for (EObject eCrossReference : eObject.eCrossReferences()) {
                Resource eResource = eCrossReference.eResource();
                if (eResource == null) continue;
                for (EObject content : eResource.getContents()) {
                    EObject eContainer = content.eContainer();
                    if (eContainer == null) continue;
                    result.add(eContainer);
                }
                eResource.unload();
            }
        }
        return result;
    }

    private static void performStartup(final IWorkbench workbench, IProgressMonitor monitor) {
        ResourceSet resourceSet;
        SetupTaskPerformer performer;
        HashSet<URI> neededRestartTasks;
        boolean restarting;
        block38: {
            try {
                BundlePool bundlePool;
                File bundlePoolLocation;
                String installFolderLocation;
                File eclipseExtensionFeaturesFolder;
                String installFolderLocation2;
                File bundlePoolLocation2;
                BundlePool bundlePool2;
                Profile currentProfile;
                Agent currentAgent = P2Util.getAgentManager().getCurrentAgent();
                if (currentAgent != null && (currentProfile = currentAgent.getCurrentProfile()) != null && (bundlePool2 = currentProfile.getBundlePool()) != null && (bundlePoolLocation2 = bundlePool2.getLocation()) != null && (installFolderLocation2 = currentProfile.getProperty("org.eclipse.equinox.p2.installFolder")) != null && !bundlePoolLocation2.equals(new File(installFolderLocation2))) {
                    eclipseExtensionFeaturesFolder = new File(bundlePoolLocation2, ".eclipseextension/features");
                    eclipseExtensionFeaturesFolder.mkdirs();
                }
                String string = installFolderLocation = (currentProfile = P2Util.getAgentManager().getCurrentAgent().getCurrentProfile()) != null ? currentProfile.getProperty("org.eclipse.equinox.p2.installFolder") : null;
                if (installFolderLocation != null && !(bundlePoolLocation = (bundlePool = currentProfile.getBundlePool()).getLocation()).equals(new File(installFolderLocation))) {
                    eclipseExtensionFeaturesFolder = new File(bundlePoolLocation, ".eclipseextension/features");
                    eclipseExtensionFeaturesFolder.mkdirs();
                }
            }
            catch (Throwable throwable) {
                INSTANCE.log(throwable, 2);
            }
            monitor.beginTask("", 105);
            Trigger trigger = Trigger.STARTUP;
            restarting = false;
            neededRestartTasks = new HashSet<URI>();
            try {
                File restartingFile = SetupUIPlugin.getRestartingFile();
                if (restartingFile.exists()) {
                    monitor.setTaskName(NLS.bind((String)Messages.SetupUIPlugin_loadRestartTasks_taskName, (Object)restartingFile));
                    Resource resource = SetupCoreUtil.createResourceSet().getResource(URI.createFileURI((String)restartingFile.toString()), true);
                    Annotation annotation = (Annotation)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)BasePackage.Literals.ANNOTATION);
                    resource.getContents().remove((Object)annotation);
                    if (ANNOTATION_SOURCE_INITIAL.equals(annotation.getSource())) {
                        if ("true".equals(annotation.getDetails().get((Object)ANNOTATION_DETAILS_KEY_OFFLINE))) {
                            System.setProperty("oomph.setup.offline.startup", "true");
                        }
                        if ("true".equals(annotation.getDetails().get((Object)ANNOTATION_DETAILS_KEY_MIRRORS))) {
                            System.setProperty("oomph.setup.mirrors.startup", "true");
                        }
                    } else {
                        for (EObject eObject : annotation.getReferences()) {
                            neededRestartTasks.add(EcoreUtil.getURI((EObject)eObject));
                        }
                        trigger = Trigger.get((String)annotation.getSource());
                        restarting = true;
                    }
                    IOUtil.deleteBestEffort((File)restartingFile);
                }
            }
            catch (Exception restartingFile) {
                // empty catch block
            }
            monitor.worked(1);
            performer = null;
            resourceSet = SetupCoreUtil.createResourceSet();
            SynchronizerManager.SynchronizationController synchronizationController = null;
            if (SynchronizerManager.Availability.AVAILABLE) {
                try {
                    synchronizationController = SynchronizerManager.INSTANCE.startSynchronization(false, false, false);
                }
                catch (Exception ex) {
                    INSTANCE.log(ex);
                }
            }
            monitor.setTaskName(Messages.SetupUIPlugin_createPerformerTask_name);
            try {
                List list;
                try {
                    Synchronization synchronization;
                    if (synchronizationController != null && (synchronization = synchronizationController.await()) != null) {
                        SynchronizerManager.INSTANCE.performSynchronization(synchronization, false, false);
                    }
                }
                catch (Exception ex) {
                    INSTANCE.log(ex);
                }
                resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
                SetupUIPlugin.mirror(resourceSet, monitor, 25);
                HashSet<Object> eContainers = new HashSet<Object>();
                eContainers.addAll(SetupUIPlugin.checkCrossReferences(resourceSet, SetupContext.INSTALLATION_SETUP_URI));
                if (SetupContext.WORKSPACE_SETUP_URI != null) {
                    eContainers.addAll(SetupUIPlugin.checkCrossReferences(resourceSet, SetupContext.WORKSPACE_SETUP_URI));
                }
                if (!eContainers.isEmpty()) {
                    resourceSet.getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITH_ETAG_CHECKING);
                    SetupUIPlugin.mirror(resourceSet, monitor, 75);
                    for (EObject eObject : eContainers) {
                        for (EObject eObject2 : eObject.eContents()) {
                        }
                    }
                } else {
                    monitor.worked(75);
                }
                performer = SetupUIPlugin.createSetupTaskPerformer(resourceSet, trigger);
                if (performer != null && !(list = performer.getUnresolvedVariables()).isEmpty()) {
                    performer.getResolvedVariables().addAll(list);
                    list.clear();
                }
            }
            catch (OperationCanceledException eContainers) {
                SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
                SetupUIPlugin.handleBrandingNotificationURI(resourceSet);
                break block38;
            }
            catch (Throwable ex) {
                try {
                    INSTANCE.log(ex);
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
                    SetupUIPlugin.handleBrandingNotificationURI(resourceSet);
                }
            }
            SetupContext.setSelf((SetupContext)SetupContext.createSelf((ResourceSet)resourceSet));
            SetupUIPlugin.handleBrandingNotificationURI(resourceSet);
        }
        monitor.worked(1);
        if (performer != null) {
            monitor.setTaskName(Messages.SetupUIPlugin_initPerformerTask_name);
            try {
                BaseResourceImpl.BaseHelperImpl helper = new BaseResourceImpl.BaseHelperImpl(null);
                performer.put(P2TaskUISevices.class, (Object)new P2TaskUIServicesPrompter());
                EList eList = performer.initNeededSetupTasks((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)2));
                if (restarting) {
                    Iterator it = eList.iterator();
                    while (it.hasNext()) {
                        String href;
                        SetupTask setupTask = (SetupTask)it.next();
                        if (setupTask.getPriority() != 200 && (href = helper.getHREF((EObject)setupTask)) != null && neededRestartTasks.contains(URI.createURI((String)href))) continue;
                        it.remove();
                    }
                }
                if (eList.isEmpty()) {
                    return;
                }
                performer.setSkipConfirmation(true);
            }
            catch (Throwable ex) {
                INSTANCE.log(ex);
                return;
            }
        } else {
            monitor.worked(2);
        }
        monitor.worked(1);
        monitor.setTaskName(Messages.SetupUIPlugin_launchSetupWizardTask_name);
        final SetupTaskPerformer finalPerfomer = performer;
        UIUtil.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] workbenchWindows;
                IWorkbenchWindow workbenchWindow;
                if (finalPerfomer != null) {
                    resourceSet.getResources().add((Object)finalPerfomer.getUser().eResource());
                }
                if ((workbenchWindow = workbench.getActiveWorkbenchWindow()) == null && (workbenchWindows = workbench.getWorkbenchWindows()).length > 0) {
                    workbenchWindow = workbenchWindows[0];
                }
                if (workbenchWindow != null) {
                    SetupWizard.Updater updater = finalPerfomer != null ? new SetupWizard.Updater(finalPerfomer) : new SetupWizard.Updater(SetupContext.createInstallationWorkspaceAndUser((ResourceSet)resourceSet));
                    ((SetupWizard)updater).openDialog(workbenchWindow.getShell());
                }
            }
        });
        monitor.worked(1);
    }

    private static SetupTaskPerformer createSetupTaskPerformer(ResourceSet resourceSet, Trigger trigger) throws Exception {
        SetupPrompter prompter = new SetupPrompter(){

            public OS getOS() {
                return OS.INSTANCE;
            }

            public String getVMPath() {
                return null;
            }

            public boolean promptVariables(List<? extends SetupTaskContext> contexts) {
                List<? extends SetupTaskContext> performers = contexts;
                for (SetupTaskPerformer setupTaskPerformer : performers) {
                    List unresolvedVariables = setupTaskPerformer.getUnresolvedVariables();
                    for (VariableTask variable : unresolvedVariables) {
                        if (variable.getType() == VariableType.PASSWORD) {
                            variable.setValue(PreferencesUtil.encrypt((String)" "));
                            continue;
                        }
                        return false;
                    }
                }
                return true;
            }

            public String getValue(VariableTask variable) {
                return null;
            }

            public UserCallback getUserCallback() {
                return null;
            }
        };
        return SetupTaskPerformer.createForIDE((ResourceSet)resourceSet, (SetupPrompter)prompter, (Trigger)trigger);
    }

    public static class Implementation
    extends EclipseUIPlugin {
        private boolean stopRecorder;

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
        }

        public void stop(BundleContext context) throws Exception {
            if (this.stopRecorder) {
                RecorderManager.Lifecycle.stop();
            }
            super.stop(context);
        }
    }
}

