/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.servlet;

import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.web.util.BasicAuthentication;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelServiceServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AbstractChannelServiceServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String ATTR_CHANNEL_SERVICE = String.valueOf(AbstractChannelServiceServlet.class.getName()) + ".channelService";
    private ServiceTracker<ChannelService, ChannelService> tracker;

    public void init() throws ServletException {
        super.init();
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        this.tracker = new ServiceTracker(context, ChannelService.class, null);
        this.tracker.open();
    }

    protected ChannelService getService(HttpServletRequest request) {
        return (ChannelService)request.getAttribute(ATTR_CHANNEL_SERVICE);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.trace("Request: {} / {}", (Object)request.getMethod(), (Object)request.getPathInfo());
        ChannelService service = (ChannelService)this.tracker.getService();
        if (service == null) {
            this.handleNoService(request, response);
        } else {
            request.setAttribute(ATTR_CHANNEL_SERVICE, (Object)service);
            super.service(request, response);
        }
    }

    protected void handleNoService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setStatus(503);
        response.setContentType("text/plain");
        response.getWriter().write("Channel service unavailable");
    }

    public void destroy() {
        this.tracker.close();
        super.destroy();
    }

    protected boolean authenticate(ChannelService.By by, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isAuthenticated(by, request)) {
            return true;
        }
        BasicAuthentication.request((HttpServletResponse)response, (String)"channel", (String)"Please authenticate");
        return false;
    }

    protected boolean isAuthenticated(ChannelService.By by, HttpServletRequest request) {
        String[] authToks = BasicAuthentication.parseAuthorization((HttpServletRequest)request);
        if (authToks == null) {
            return false;
        }
        if (!authToks[0].equals("deploy")) {
            return false;
        }
        String deployKey = authToks[1];
        logger.debug("Deploy key: '{}'", (Object)deployKey);
        ChannelService service = this.getService(request);
        if (service == null) {
            logger.info("Called 'isAuthenticated' without service");
            return false;
        }
        return service.getChannelDeployKeyStrings(by).orElse(Collections.emptySet()).contains(deployKey);
    }
}

