/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.mvnosgi.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

public class Pom {
    private final String groupId;
    private final String artifactId;
    private final String version;

    public Pom(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String toString() {
        try {
            StringWriter sw = new StringWriter();
            this.writePom(sw);
            return sw.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public void writePom(OutputStream stream) throws IOException {
        this.writePom(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
    }

    public void writePom(Writer writer) throws IOException {
        Model model = new Model();
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        new MavenXpp3Writer().write(writer, model);
    }
}

