/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectProcessor;
import org.eclipse.packagedrone.repo.channel.ChannelDetails;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.DeployKeysChannelAdapter;
import org.eclipse.packagedrone.repo.channel.DescriptorAdapter;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.deploy.DeployAuthService;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstance;
import org.eclipse.packagedrone.repo.channel.impl.ChannelProviderTracker;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceAccess;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceModelProvider;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceModify;
import org.eclipse.packagedrone.repo.channel.impl.DeployKeysChannelAdapterImpl;
import org.eclipse.packagedrone.repo.channel.impl.DescriptorAdapterImpl;
import org.eclipse.packagedrone.repo.channel.impl.Disposing;
import org.eclipse.packagedrone.repo.channel.impl.model.ChannelConfiguration;
import org.eclipse.packagedrone.repo.channel.provider.Channel;
import org.eclipse.packagedrone.repo.channel.provider.ChannelProvider;
import org.eclipse.packagedrone.repo.channel.stats.ChannelStatistics;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryTracker;
import org.eclipse.packagedrone.repo.utils.Splits;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;
import org.eclipse.packagedrone.utils.Locks;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.event.EventAdmin;

public class ChannelServiceImpl
implements ChannelService,
DeployAuthService {
    private static final MetaKey KEY_STORAGE = new MetaKey("channels", "service");
    private final BundleContext context;
    private final Lock readLock;
    private final Lock writeLock;
    private StorageManager manager;
    private StorageRegistration handle;
    private final Multimap<String, DeployGroup> deployKeysMap = HashMultimap.create();
    private ChannelAspectProcessor aspectProcessor;
    private ChannelProviderTracker providerTracker;
    private final Map<String, ChannelInstance> channels = new HashMap<String, ChannelInstance>();
    private EventAdmin eventAdmin;
    private ProcessorFactoryTracker processorFactoryTracker;
    private ConfiguredTriggerFactoryTracker triggerFactoryTracker;

    public ChannelServiceImpl() {
        this.context = FrameworkUtil.getBundle(ChannelServiceImpl.class).getBundleContext();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void setStorageManager(StorageManager manager) {
        this.manager = manager;
    }

    public void start() {
        this.aspectProcessor = new ChannelAspectProcessor(this.context);
        this.providerTracker = new ChannelProviderTracker(this.context);
        this.providerTracker.start();
        this.processorFactoryTracker = new ProcessorFactoryTracker(this.context);
        this.triggerFactoryTracker = new ConfiguredTriggerFactoryTracker(this.context);
        this.handle = this.manager.registerModel(1000L, KEY_STORAGE, (StorageModelProvider)new ChannelServiceModelProvider());
        try {
            this.manager.accessRun(KEY_STORAGE, ChannelServiceAccess.class, model -> {
                this.updateDeployGroupCache((ChannelServiceAccess)model);
                for (Map.Entry<String, ChannelConfiguration> entry : model.getChannels().entrySet()) {
                    this.loadChannel(entry.getKey(), entry.getValue());
                }
            });
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
    }

    public void stop() {
        this.dispose();
    }

    private void dispose() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.channels.values().stream().forEach(ChannelInstance::dispose);
            this.channels.clear();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        if (this.aspectProcessor != null) {
            this.aspectProcessor.close();
            this.aspectProcessor = null;
        }
        if (this.providerTracker != null) {
            this.providerTracker.stop();
            this.providerTracker = null;
        }
        if (this.processorFactoryTracker != null) {
            this.processorFactoryTracker.close();
            this.processorFactoryTracker = null;
        }
        if (this.triggerFactoryTracker != null) {
            this.triggerFactoryTracker.close();
            this.triggerFactoryTracker = null;
        }
    }

    private void loadChannel(String channelId, ChannelConfiguration configuration) {
        this.channels.put(channelId, new ChannelInstance(channelId, configuration.getProviderId(), configuration.getConfiguration(), this.providerTracker, this.aspectProcessor, this.eventAdmin, this.manager, this.processorFactoryTracker, this.triggerFactoryTracker));
    }

    private ChannelInformation accessState(ChannelServiceAccess channels, ChannelInstance channel) {
        return (ChannelInformation)channel.access(ChannelServiceImpl.buildId(channel.getChannelId(), channels), ReadableChannel.class, ReadableChannel::getInformation);
    }

    public Collection<ChannelInformation> list() {
        return this.accessChannels(channels -> this.channels.values().stream().map(instance -> this.accessState((ChannelServiceAccess)channels, (ChannelInstance)instance)).collect(Collectors.toList()));
    }

    protected Optional<ChannelInstance> find(ChannelService.By by) {
        switch (by.getType()) {
            case ID: {
                return this.findById((String)by.getQualifier());
            }
            case NAME: {
                return this.findByName((String)by.getQualifier());
            }
            case COMPOSITE: {
                ChannelService.By[] bys;
                ChannelService.By[] byArray = bys = (ChannelService.By[])by.getQualifier();
                int n = bys.length;
                int n2 = 0;
                while (n2 < n) {
                    ChannelService.By oneBy = byArray[n2];
                    Optional<ChannelInstance> result = this.find(oneBy);
                    if (result.isPresent()) {
                        return result;
                    }
                    ++n2;
                }
                return Optional.empty();
            }
        }
        throw new IllegalArgumentException(String.format("Unknown locator type: %s", by.getType()));
    }

    private Optional<ChannelInstance> findById(String id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.channels.get(id));
    }

    private Optional<ChannelInstance> findByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        String id = (String)this.manager.accessCall(KEY_STORAGE, ChannelServiceAccess.class, channels -> channels.mapToId(name));
        return this.findById(id);
    }

    public Optional<ChannelInformation> getState(ChannelService.By by) {
        return this.accessChannels(channels -> this.find(by).map(instance -> this.accessState((ChannelServiceAccess)channels, (ChannelInstance)instance)));
    }

    public ChannelId create(String providerId, ChannelDetails details, Map<MetaKey, String> configuration) {
        String channelId = UUID.randomUUID().toString();
        ChannelConfiguration cfg = new ChannelConfiguration();
        cfg.setProviderId(providerId);
        cfg.setConfiguration(configuration);
        cfg.setDescription(details.getDescription());
        this.providerTracker.run(providerId, p -> {
            ChannelProvider provider = (ChannelProvider)p.orElseThrow(() -> new IllegalStateException(String.format("Channel provider '%s' is not registered", providerId)));
            provider.create(channelId, configuration);
        });
        this.manager.accessRun(KEY_STORAGE, ChannelServiceModify.class, channels -> channels.createChannel(channelId, cfg));
        this.commitCreateChannel(channelId, providerId, configuration);
        return new ChannelId(channelId);
    }

    private void commitCreateChannel(String channelId, String providerId, Map<MetaKey, String> configuration) {
        ChannelInstance channel = new ChannelInstance(channelId, providerId, configuration, this.providerTracker, this.aspectProcessor, this.eventAdmin, this.manager, this.processorFactoryTracker, this.triggerFactoryTracker);
        Throwable throwable = null;
        Object var6_7 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.channels.put(channelId, channel);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private <R> R accessChannels(Function<ChannelServiceAccess, R> operation) {
        return (R)this.manager.accessCall(KEY_STORAGE, ChannelServiceAccess.class, channels -> operation.apply((ChannelServiceAccess)channels));
    }

    private <R> R modifyChannels(Function<ChannelServiceModify, R> operation) {
        return (R)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, channels -> operation.apply((ChannelServiceModify)channels));
    }

    private <R, T> R modifyChannel(ChannelService.By by, Function<ChannelInstance, R> operation) {
        return (R)this.modifyChannels(channels -> {
            ChannelInstance channelInstance = this.findChannel(by);
            return operation.apply(channelInstance);
        });
    }

    public <R, T> R accessCall(ChannelService.By by, Class<T> clazz, ChannelService.ChannelOperation<R, T> operation) {
        if (DeployKeysChannelAdapter.class.equals(clazz)) {
            return (R)this.modifyChannel(by, channelInstance -> this.handleDeployKeys((ChannelInstance)channelInstance, (ChannelService.ChannelOperation)operation));
        }
        if (DescriptorAdapter.class.equals(clazz)) {
            return (R)this.modifyChannel(by, channelInstance -> this.handleDescribe((ChannelInstance)channelInstance, (ChannelService.ChannelOperation)operation));
        }
        return (R)this.accessChannels(channels -> {
            ChannelInstance channelInstance = this.findChannel(by);
            ChannelId id = ChannelServiceImpl.buildId(channelInstance.getChannelId(), channels);
            return channelInstance.access(id, clazz, operation);
        });
    }

    private static ChannelId buildId(String channelId, ChannelServiceAccess channels) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(channels.getNameMappings(channelId));
        String description = channels.getDescription(channelId);
        return new ChannelId(channelId, names, description);
    }

    private <R> R handleDeployKeys(ChannelInstance channel, ChannelService.ChannelOperation<R, DeployKeysChannelAdapter> operation) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            return (R)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, model -> {
                DeployKeysChannelAdapterImpl adapter = new DeployKeysChannelAdapterImpl(channel.getChannelId(), (ChannelServiceModify)model){

                    @Override
                    public void assignDeployGroup(String groupId) {
                        super.assignDeployGroup(groupId);
                        StorageManager.executeAfterPersist(() -> ChannelServiceImpl.this.updateDeployGroupCache(this.model));
                    }

                    @Override
                    public void unassignDeployGroup(String groupId) {
                        super.unassignDeployGroup(groupId);
                        StorageManager.executeAfterPersist(() -> ChannelServiceImpl.this.updateDeployGroupCache(this.model));
                    }
                };
                return ChannelServiceImpl.runDisposing(operation, DeployKeysChannelAdapter.class, adapter);
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static <R, T> R runDisposing(ChannelService.ChannelOperation<R, T> operation, Class<T> clazz, T target) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Disposing<T> adapter = Disposing.proxy(clazz, target);){
                return (R)operation.process(adapter.getTarget());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Collection<DeployGroup>> getChannelDeployGroups(ChannelService.By by) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Optional<Collection<DeployGroup>> optional;
            Locks.Locked l = Locks.lock((Lock)this.readLock);
            try {
                Optional<ChannelInstance> channel = this.find(by);
                if (!channel.isPresent()) {
                    optional = Optional.empty();
                    return optional;
                }
                return Optional.ofNullable(this.deployKeysMap.get((Object)channel.get().getChannelId())).map(ArrayList::new);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (l == null) return optional;
                l.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    private <R> R handleDescribe(ChannelInstance channelEntry, ChannelService.ChannelOperation<R, DescriptorAdapter> operation) {
        return (R)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, model -> {
            DescriptorAdapterImpl dai = new DescriptorAdapterImpl(channelEntry.getChannelId(), (ChannelServiceModify)model);
            return ChannelServiceImpl.runDisposing(operation, DescriptorAdapter.class, dai);
        });
    }

    private ChannelInstance findChannel(ChannelService.By by) {
        Optional<ChannelInstance> channel;
        Throwable throwable = null;
        Object var4_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            channel = this.find(by);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!channel.isPresent()) {
            throw new ChannelNotFoundException(by.toString());
        }
        return channel.get();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean delete(ChannelService.By by) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Locks.Locked l = Locks.lock((Lock)this.writeLock);
            try {
                Optional<ChannelInstance> channelInstance = this.find(by);
                if (!channelInstance.isPresent()) {
                    return false;
                }
                ChannelInstance instance = channelInstance.get();
                Optional<Channel> channel = instance.getChannel();
                if (!channel.isPresent()) {
                    throw new IllegalStateException(String.format("Can only delete channel %s when the provider %s is present", instance.getChannelId(), instance.getProviderId()));
                }
                this.deleteChannel(instance);
                channel.get().delete();
                return true;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (l == null) return false;
                l.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    protected void deleteChannel(ChannelInstance channel) {
        this.manager.modifyRun(KEY_STORAGE, ChannelServiceModify.class, model -> {
            model.deleteChannel(channel.getChannelId());
            StorageManager.executeAfterPersist(() -> this.commitDeleteChannel(channel));
        });
    }

    public void wipeClean() {
        ArrayList<ChannelInstance> channels;
        Throwable throwable = null;
        Iterator iterator = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            channels = new ArrayList<ChannelInstance>(this.channels.values());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (ChannelInstance instance : channels) {
            Optional<Channel> channel = instance.getChannel();
            if (!channel.isPresent()) continue;
            this.deleteChannel(instance);
            this.channels.remove(instance.getChannelId());
            channel.get().delete();
        }
    }

    private void commitDeleteChannel(ChannelInstance channel) {
        this.channels.remove(channel.getChannelId());
        this.deployKeysMap.removeAll((Object)channel.getChannelId());
    }

    private void updateDeployGroupCache(ChannelServiceAccess model) {
        this.deployKeysMap.clear();
        for (Map.Entry<String, Set<String>> entry : model.getDeployGroupMap().entrySet()) {
            String channelId = entry.getKey();
            List groups = entry.getValue().stream().map(groupId -> model.getDeployGroup((String)groupId)).collect(Collectors.toList());
            this.deployKeysMap.putAll((Object)channelId, groups);
        }
    }

    public List<DeployGroup> listGroups(int position, int count) {
        return (List)this.manager.accessCall(KEY_STORAGE, ChannelServiceAccess.class, model -> Splits.split(model.getDeployGroups(), (int)position, (int)count));
    }

    public DeployGroup createGroup(String name) {
        return (DeployGroup)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, model -> model.createGroup(name));
    }

    public void deleteGroup(String groupId) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.manager.modifyRun(KEY_STORAGE, ChannelServiceModify.class, model -> {
                model.deleteGroup(groupId);
                StorageManager.executeAfterPersist(() -> this.updateDeployGroupCache((ChannelServiceAccess)model));
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateGroup(String groupId, String name) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.manager.modifyRun(KEY_STORAGE, ChannelServiceModify.class, model -> {
                model.updateGroup(groupId, name);
                StorageManager.executeAfterPersist(() -> this.updateDeployGroupCache((ChannelServiceAccess)model));
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DeployGroup getGroup(String groupId) {
        return (DeployGroup)this.manager.accessCall(KEY_STORAGE, ChannelServiceAccess.class, model -> model.getDeployGroup(groupId));
    }

    public DeployKey createDeployKey(String groupId, String name) {
        return (DeployKey)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, model -> {
            StorageManager.executeAfterPersist(() -> this.updateDeployGroupCache((ChannelServiceAccess)model));
            return model.createKey(groupId, name);
        });
    }

    public DeployKey deleteDeployKey(String keyId) {
        return (DeployKey)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, model -> {
            StorageManager.executeAfterPersist(() -> this.updateDeployGroupCache((ChannelServiceAccess)model));
            return model.deleteKey(keyId);
        });
    }

    public DeployKey getDeployKey(String keyId) {
        return (DeployKey)this.manager.accessCall(KEY_STORAGE, ChannelServiceAccess.class, model -> model.getDeployKey(keyId));
    }

    public DeployKey updateDeployKey(String keyId, String name) {
        return (DeployKey)this.manager.modifyCall(KEY_STORAGE, ChannelServiceModify.class, model -> {
            StorageManager.executeAfterPersist(() -> this.updateDeployGroupCache((ChannelServiceAccess)model));
            return model.updateKey(keyId, name);
        });
    }

    public ChannelStatistics getStatistics() {
        ChannelStatistics cs = new ChannelStatistics();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            Collection<ChannelInformation> cis = this.list();
            cs.setTotalNumberOfArtifacts(cis.stream().mapToLong(ci -> ci.getState().getNumberOfArtifacts()).sum());
            cs.setTotalNumberOfBytes(cis.stream().mapToLong(ci -> ci.getState().getNumberOfBytes()).sum());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return cs;
    }
}

